/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.contentSources.B2ContentSource;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.util.B2InputStreamExcerpt;
import java.io.IOException;
import java.io.InputStream;

class B2PartOfContentSource
implements B2ContentSource {
    private final B2ContentSource source;
    private final long start;
    private final long length;

    B2PartOfContentSource(B2ContentSource source, long start, long length) {
        this.source = source;
        this.start = start;
        this.length = length;
    }

    @Override
    public long getContentLength() throws IOException {
        return this.length;
    }

    @Override
    public String getSha1OrNull() throws IOException {
        return null;
    }

    @Override
    public Long getSrcLastModifiedMillisOrNull() throws IOException {
        throw new IllegalStateException("why are we asking about the srcLastModifiedMillis of a PART?");
    }

    @Override
    public InputStream createInputStream() throws IOException, B2Exception {
        return new B2InputStreamExcerpt(this.source.createInputStream(), this.start, this.length);
    }

    public String toString() {
        return "B2PartOfContentSource{start=" + this.start + ", length=" + this.length + ", source=" + this.source + '}';
    }
}

