/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2ListFilesIterableBase;
import com.backblaze.b2.client.B2StorageClientImpl;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.structures.B2FileVersion;
import com.backblaze.b2.client.structures.B2ListFilesResponse;
import com.backblaze.b2.client.structures.B2ListUnfinishedLargeFilesRequest;
import com.backblaze.b2.client.structures.B2ListUnfinishedLargeFilesResponse;
import java.util.Iterator;

public class B2ListUnfinishedLargeFilesIterable
extends B2ListFilesIterableBase {
    private final B2ListUnfinishedLargeFilesRequest request;

    public B2ListUnfinishedLargeFilesIterable(B2StorageClientImpl b2Client, B2ListUnfinishedLargeFilesRequest request) {
        super(b2Client);
        this.request = request;
    }

    @Override
    Iterator<B2FileVersion> createIter() throws B2Exception {
        return new Iter();
    }

    private class Iter
    extends B2ListFilesIterableBase.IterBase {
        private B2ListUnfinishedLargeFilesResponse currentResponse;

        Iter() throws B2Exception {
        }

        @Override
        protected B2ListFilesResponse getCurrentResponseOrNull() {
            return this.currentResponse;
        }

        @Override
        protected void advance() throws B2Exception {
            B2ListUnfinishedLargeFilesRequest.Builder builder = B2ListUnfinishedLargeFilesRequest.builder(B2ListUnfinishedLargeFilesIterable.this.request);
            if (this.currentResponse != null) {
                builder.setStartFileId(this.currentResponse.getNextFileId());
            }
            this.currentResponse = B2ListUnfinishedLargeFilesIterable.this.getClient().listUnfinishedLargeFiles(builder.build());
        }
    }
}

