/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2ListFilesIterableBase;
import com.backblaze.b2.client.B2StorageClientImpl;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.structures.B2FileVersion;
import com.backblaze.b2.client.structures.B2ListFileNamesRequest;
import com.backblaze.b2.client.structures.B2ListFileNamesResponse;
import com.backblaze.b2.client.structures.B2ListFilesResponse;
import java.util.Iterator;

public class B2ListFileNamesIterable
extends B2ListFilesIterableBase {
    private final B2ListFileNamesRequest request;

    public B2ListFileNamesIterable(B2StorageClientImpl b2Client, B2ListFileNamesRequest request) {
        super(b2Client);
        this.request = request;
    }

    @Override
    Iterator<B2FileVersion> createIter() throws B2Exception {
        return new Iter();
    }

    private class Iter
    extends B2ListFilesIterableBase.IterBase {
        private B2ListFileNamesResponse currentResponse;

        Iter() throws B2Exception {
            super(B2ListFileNamesIterable.this);
        }

        @Override
        protected void advance() throws B2Exception {
            B2ListFileNamesRequest.Builder builder = B2ListFileNamesRequest.builder(B2ListFileNamesIterable.this.request);
            if (this.currentResponse != null) {
                builder.setStartFileName(this.currentResponse.getNextFileName());
            }
            this.currentResponse = B2ListFileNamesIterable.this.getClient().listFileNames(builder.build());
        }

        @Override
        protected B2ListFilesResponse getCurrentResponseOrNull() {
            return this.currentResponse;
        }
    }
}

