/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.contentSources.B2ContentSource;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.exceptions.B2LocalException;
import com.backblaze.b2.util.B2IoUtils;
import com.backblaze.b2.util.B2Sha1AppenderInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

class B2ContentDetailsForUpload
implements Closeable {
    private final long contentLength;
    private final String contentSha1HeaderValue;
    private final InputStream inputStream;

    B2ContentDetailsForUpload(B2ContentSource source) throws B2Exception {
        String sha1HeaderValue;
        InputStream inputStream;
        String contentSha1;
        long contentLen;
        try {
            contentLen = source.getContentLength();
        }
        catch (IOException e) {
            throw new B2LocalException("read_failed", "failed to get contentLength from source: " + e, e);
        }
        try {
            contentSha1 = source.getSha1OrNull();
        }
        catch (IOException e) {
            throw new B2LocalException("read_failed", "trouble getting sha1 from source: " + e, e);
        }
        try {
            inputStream = source.createInputStream();
        }
        catch (IOException e) {
            throw new B2LocalException("read_failed", "failed to create inputStream from source: " + e, e);
        }
        if (contentSha1 == null) {
            sha1HeaderValue = "hex_digits_at_end";
            inputStream = B2Sha1AppenderInputStream.create(inputStream);
            contentLen += 40L;
        } else {
            sha1HeaderValue = contentSha1;
        }
        this.contentLength = contentLen;
        this.inputStream = inputStream;
        this.contentSha1HeaderValue = sha1HeaderValue;
    }

    long getContentLength() {
        return this.contentLength;
    }

    String getContentSha1HeaderValue() {
        return this.contentSha1HeaderValue;
    }

    InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void close() {
        B2IoUtils.closeQuietly(this.inputStream);
    }
}

