/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.io.location;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.maven.shared.io.location.FileLocation;
import org.apache.maven.shared.utils.io.FileUtils;

public class URLLocation
extends FileLocation {
    private final URL url;
    private final String tempFilePrefix;
    private final String tempFileSuffix;
    private final boolean tempFileDeleteOnExit;

    public URLLocation(URL url, String specification, String tempFilePrefix, String tempFileSuffix, boolean tempFileDeleteOnExit) {
        super(specification);
        this.url = url;
        this.tempFilePrefix = tempFilePrefix;
        this.tempFileSuffix = tempFileSuffix;
        this.tempFileDeleteOnExit = tempFileDeleteOnExit;
    }

    @Override
    protected void initFile() throws IOException {
        if (this.unsafeGetFile() == null) {
            File tempFile = File.createTempFile(this.tempFilePrefix, this.tempFileSuffix);
            if (this.tempFileDeleteOnExit) {
                tempFile.deleteOnExit();
            }
            FileUtils.copyURLToFile(this.url, tempFile);
            this.setFile(tempFile);
        }
    }
}

