/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class CustomLatestVerCalculation {
    public static void main(String[] args) throws ConfigurationException {
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@139.162.40.38:27017/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        MongoCollection<Document> latestDeviceBkpInfoColl = db.getCollection("LATEST_DEVICE_BACKUP_INFO");
        MongoCollection<Document> deviceBkpOverviewColl = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        FindIterable<Document> devices = deviceColl.find();
        for (Document device : devices) {
            FindIterable<Document> folders;
            MongoCollection<Document> bkpColl = db.getCollection(device.getString("destCollection"));
            String deviceUUID = device.getString("deviceUUID");
            System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "20");
            BasicDBObject andQuery = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            whereQuery.add(new BasicDBObject("folder", true));
            whereQuery.add(new BasicDBObject("present", true));
            andQuery.put("$and", whereQuery);
            ArrayList<Document> allFoldersList = new ArrayList<Document>();
            int skip = 0;
            System.out.println("getting folders................");
            while ((folders = bkpColl.find(andQuery).skip(skip * 500).limit(500)).first() != null) {
                for (Document document : folders) {
                    allFoldersList.add(document);
                }
                ++skip;
            }
            System.out.println("Done folders   " + allFoldersList.size() + " for deviceUUID " + deviceUUID);
            long fileSizes = 0L;
            for (Document folder : allFoldersList) {
                String folderName = "";
                folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
                andQuery = new BasicDBObject();
                whereQuery = new ArrayList();
                whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
                whereQuery.add(new BasicDBObject("folder", false));
                whereQuery.add(new BasicDBObject("present", true));
                whereQuery.add(new BasicDBObject("devicePath", folderName));
                andQuery.put("$and", whereQuery);
                FindIterable<Document> files = bkpColl.find(andQuery);
                ArrayList<BackUpImage> allFilesList = new ArrayList<BackUpImage>();
                System.out.println("...." + files);
                for (Document document : files) {
                    BackUpImage backUpImage = new BackUpImage();
                    backUpImage.setDevicePath(document.getString("devicePath"));
                    backUpImage.setFileName(document.getString("fileName"));
                    if (StringUtils.isEmpty(backUpImage.getDevicePath()) || StringUtils.isEmpty(backUpImage.getFileName())) continue;
                    backUpImage.setSize(document.getLong("size"));
                    allFilesList.add(backUpImage);
                }
                List<BackUpImage> list = CustomLatestVerCalculation.getFilteredBackupImageList(allFilesList);
                long folderSize = 0L;
                for (BackUpImage image : list) {
                    fileSizes += image.getSize();
                    folderSize += image.getSize();
                }
                System.out.println(String.valueOf(list.size()) + " .... path and size .... " + folderName + "....." + folderSize + " for deviceUUID " + deviceUUID);
            }
            System.out.println("Total size...................................... :" + fileSizes + " for deviceUUID " + deviceUUID);
            BasicDBObject andQuery1 = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
            whereQuery1.add(new BasicDBObject("deviceUUID", deviceUUID));
            whereQuery1.add(new BasicDBObject("isDecoupled", false));
            andQuery1.put("$and", whereQuery1);
            Document latestDeviceBkpInfo = (Document)latestDeviceBkpInfoColl.find(andQuery1).first();
            if (latestDeviceBkpInfo != null) continue;
            Document latestBkpOverviewInfo = new Document();
            latestBkpOverviewInfo.put("deviceUUID", (Object)deviceUUID);
            latestBkpOverviewInfo.put("latestVersionsSize", (Object)fileSizes);
            BasicDBObject bkpOverviewAnd = new BasicDBObject();
            ArrayList<BasicDBObject> bkpOverviewQuery = new ArrayList<BasicDBObject>();
            bkpOverviewQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            bkpOverviewQuery.add(new BasicDBObject("isDecoupled", false));
            bkpOverviewAnd.put("$and", bkpOverviewQuery);
            Document deviceBkpOverview = (Document)deviceBkpOverviewColl.find(andQuery1).first();
            if (deviceBkpOverview != null) {
                latestBkpOverviewInfo.put("storageUtilized", deviceBkpOverview.get("storageUtilized"));
            }
            latestBkpOverviewInfo.put("isDecoupled", device.get("decoupled"));
            latestDeviceBkpInfoColl.insertOne(latestBkpOverviewInfo);
        }
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        System.out.println("Inside grouping backup images");
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }
}

