/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class LatestVerUpdateWithThreadsAndCursor1 {
    private static TimerTask backupTimerTask;
    private static Timer timer;
    private static int count;
    int deviceuuidCount;
    private static int threads;
    private static int limit;
    private static List<Device> devList;

    static {
        devList = new ArrayList<Device>();
    }

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String thread = config.getProperty("thread").toString();
        String limitValue = config.getProperty("limit").toString();
        int threadCount = Integer.parseInt(thread);
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        MongoCollection<Document> latestDeviceBkpInfoColl = db.getCollection("LATEST_DEVICE_BACKUP_INFO");
        MongoCollection<Document> deviceProccesedForUpdate = db.getCollection("DEVICE_LATEST_VERSION_UPDATED");
        MongoCollection<Document> deviceBkpOverviewColl = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        FindIterable<Document> devices = null;
        devices = deviceColl.find();
        limit = Integer.parseInt(limitValue);
        System.out.println("Converting device Db object to list of  device ...");
        devList = new ArrayList<Device>();
        for (Document dev : devices) {
            Device device = new Device();
            device.setDeviceUUID(dev.getString("deviceUUID"));
            device.setDestCollection(dev.getString("destCollection"));
            device.setDecoupled((Boolean)dev.get("decoupled"));
            BasicDBObject andQuery1 = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
            whereQuery1.add(new BasicDBObject("deviceUUID", device.getDeviceUUID()));
            andQuery1.put("$and", whereQuery1);
            Document latestDeviceBkpInfo = (Document)deviceProccesedForUpdate.find(andQuery1).first();
            if (latestDeviceBkpInfo != null) continue;
            devList.add(device);
        }
        System.out.println("total device size is...." + devList.size());
        int threadSizeVal = threadCount;
        ExecutorService executor = Executors.newFixedThreadPool(threadSizeVal);
        ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
        LatestVerUpdateWithThreadsAndCursor1.checkThreadStatusAndStartUpdate(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, pool, deviceProccesedForUpdate);
        int i = 0;
        while (i < threadSizeVal) {
            System.out.println("Creating thread for first time>>>>>>>>> i value::");
            LatestVerUpdateWithThreadsAndCursor1.callUpdateDBEntries(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, pool, deviceProccesedForUpdate);
            ++i;
        }
        Device device = LatestVerUpdateWithThreadsAndCursor1.getDeviceFromList();
        if (device != null) {
            LatestVerUpdateWithThreadsAndCursor1.updateLatestSize(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, device, deviceProccesedForUpdate);
        }
    }

    private static synchronized Device getDeviceFromList() {
        Device dev = null;
        try {
            if (!CollectionUtils.isEmpty(devList) && devList.get(0) != null) {
                dev = devList.get(0);
                System.out.println(".............." + dev.getDeviceUUID());
                devList.remove(dev);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dev;
    }

    private static void checkThreadStatusAndStartUpdate(final MongoDatabase db, final MongoCollection latestDeviceBkpInfoColl, final MongoCollection deviceBkpOverviewColl, final CompletionService<String> pool, final MongoCollection deviceProccesedForUpdate) {
        if (timer == null) {
            timer = new Timer();
        }
        if (backupTimerTask == null) {
            backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        Future future = pool.take();
                        if (future.isDone()) {
                            System.out.println(String.valueOf(Thread.currentThread().getName()) + " future is done........");
                            LatestVerUpdateWithThreadsAndCursor1.callUpdateDBEntries(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, pool, deviceProccesedForUpdate);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            timer.schedule(backupTimerTask, 1000L, 1000L);
        }
    }

    private static void callUpdateDBEntries(MongoDatabase db, MongoCollection latestDeviceBkpInfoColl, MongoCollection deviceBkpOverviewColl, CompletionService<String> pool, MongoCollection deviceProccesedForUpdate) {
        Device device = LatestVerUpdateWithThreadsAndCursor1.getDeviceFromList();
        if (device != null) {
            Runnable uploadJob = () -> {
                try {
                    LatestVerUpdateWithThreadsAndCursor1.updateLatestSize(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, device, deviceProccesedForUpdate);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
            pool.submit(uploadJob, "");
        }
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    private static void updateLatestSize(MongoDatabase db, MongoCollection latestDeviceBkpInfoColl, MongoCollection deviceBkpOverviewColl, Device device, MongoCollection deviceProccesedForUpdate) {
        Document latestBkpOverviewInfo;
        Document latestDeviceBkpInfo;
        if (device == null) {
            System.out.println(String.valueOf(Thread.currentThread().getName()) + ".......Device is empty so return");
            return;
        }
        System.out.println(String.valueOf(Thread.currentThread().getName()) + "Satrted for device :" + device.getDeviceUUID() + " on " + System.currentTimeMillis());
        MongoCollection<Document> bkpColl = db.getCollection(device.getDestCollection());
        String tempDeviceRestoredCheckCollName = "DEVICE_" + device.getDeviceUUID();
        MongoCollection<Document> deviceRestoredCheckColl = db.getCollection(tempDeviceRestoredCheckCollName.toUpperCase());
        String deviceUUID = device.getDeviceUUID();
        Document deviceBkpOverview = (Document)deviceBkpOverviewColl.find(new BasicDBObject("deviceUUID", deviceUUID)).first();
        if (deviceRestoredCheckColl.count() > 0L) {
            System.out.println("....files are presnet so drop collection......" + tempDeviceRestoredCheckCollName.toUpperCase());
            deviceRestoredCheckColl.drop();
        }
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery.add(new BasicDBObject("folder", true));
        whereQuery.add(new BasicDBObject("present", true));
        andQuery.put("$and", whereQuery);
        ArrayList<Document> allFoldersList = new ArrayList<Document>();
        int skip = 0;
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " getting folders................");
        long latestFileSizes = 0L;
        while (true) {
            try (MongoCursor folders = bkpColl.find(andQuery).skip(skip * limit).limit(limit).iterator();){
                while (folders.hasNext()) {
                    Document document = (Document)folders.next();
                    allFoldersList.add(document);
                }
            }
            if (CollectionUtils.isEmpty(allFoldersList)) break;
            latestFileSizes = LatestVerUpdateWithThreadsAndCursor1.calacluateSizeForPaths(bkpColl, deviceUUID, allFoldersList, latestFileSizes, deviceRestoredCheckColl);
            allFoldersList = new ArrayList();
            ++skip;
        }
        BasicDBObject andQuery1 = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
        whereQuery1.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery1.add(new BasicDBObject("isDecoupled", false));
        andQuery1.put("$and", whereQuery1);
        try {
            if (!StringUtils.isEmpty(deviceUUID)) {
                latestDeviceBkpInfoColl.deleteMany(new BasicDBObject("deviceUUID", deviceUUID));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ((latestDeviceBkpInfo = (Document)latestDeviceBkpInfoColl.find(andQuery1).first()) == null) {
            latestBkpOverviewInfo = new Document();
            latestBkpOverviewInfo.put("deviceUUID", (Object)deviceUUID);
            latestBkpOverviewInfo.put("latestVersionsSize", (Object)latestFileSizes);
            BasicDBObject bkpOverviewAnd = new BasicDBObject();
            ArrayList<BasicDBObject> bkpOverviewQuery = new ArrayList<BasicDBObject>();
            bkpOverviewQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            bkpOverviewQuery.add(new BasicDBObject("createdTimeStamp", (Object)System.currentTimeMillis()));
            bkpOverviewQuery.add(new BasicDBObject("isDecoupled", false));
            bkpOverviewAnd.put("$and", bkpOverviewQuery);
            if (deviceBkpOverview != null) {
                latestBkpOverviewInfo.put("storageUtilized", deviceBkpOverview.get("storageUtilized"));
            }
            latestBkpOverviewInfo.put("isDecoupled", (Object)device.isDecoupled());
            latestDeviceBkpInfoColl.insertOne(latestBkpOverviewInfo);
        } else {
            BasicDBObject updateFields = new BasicDBObject();
            BasicDBObject updateQuery = new BasicDBObject();
            updateFields.append("latestVersionsSize", latestFileSizes);
            if (deviceBkpOverview != null) {
                updateFields.put("storageUtilized", deviceBkpOverview.get("storageUtilized"));
            }
            updateFields.append("latestVersionsSize", latestFileSizes);
            updateQuery.append("$set", updateFields);
            latestDeviceBkpInfoColl.updateOne(andQuery1, updateQuery);
        }
        latestBkpOverviewInfo = new Document();
        latestBkpOverviewInfo.put("deviceUUID", (Object)deviceUUID);
        latestBkpOverviewInfo.put("latestVersionsSize", (Object)latestFileSizes);
        deviceProccesedForUpdate.insertOne(latestBkpOverviewInfo);
        deviceRestoredCheckColl.drop();
        System.out.println(String.valueOf(Thread.currentThread().getName()) + "Ended for device :" + device.getDeviceUUID() + " on " + System.currentTimeMillis());
    }

    private static long calacluateSizeForPaths(MongoCollection bkpColl, String deviceUUID, List<Document> allFoldersList, long latestFileSizes, MongoCollection deviceRestoredCheckColl) {
        block3: for (Document folder : allFoldersList) {
            String folderName = "";
            folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
            BasicDBObject andQuery1 = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            whereQuery.add(new BasicDBObject("devicePath", folderName));
            whereQuery.add(new BasicDBObject("folder", false));
            whereQuery.add(new BasicDBObject("present", true));
            andQuery1.put("$and", whereQuery);
            int skip1 = 0;
            block4: while (true) {
                ArrayList<Document> allFilesList = new ArrayList<Document>();
                try (MongoCursor files = bkpColl.find(andQuery1).sort(new BasicDBObject("lastServerModifiedTime", (Object)-1)).skip(skip1 * limit).limit(limit).iterator();){
                    while (files.hasNext()) {
                        Document document = (Document)files.next();
                        allFilesList.add(document);
                    }
                }
                if (CollectionUtils.isEmpty(allFilesList)) continue block3;
                ++skip1;
                ArrayList<BackUpImage> allBkpImageList = new ArrayList<BackUpImage>();
                int k = 0;
                for (Document document : allFilesList) {
                    ++k;
                    BackUpImage backUpImage = new BackUpImage();
                    backUpImage.setDevicePath(document.getString("devicePath"));
                    backUpImage.setFileName(document.getString("fileName"));
                    backUpImage.setLastServerModifiedTime(document.getLong("lastServerModifiedTime"));
                    if (StringUtils.isEmpty(backUpImage.getDevicePath()) || StringUtils.isEmpty(backUpImage.getFileName())) continue;
                    backUpImage.setSize(document.getLong("size"));
                    allBkpImageList.add(backUpImage);
                }
                List<BackUpImage> list = LatestVerUpdateWithThreadsAndCursor1.getFilteredBackupImageList(allBkpImageList);
                Iterator<BackUpImage> iterator = list.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block4;
                    BackUpImage image = iterator.next();
                    BasicDBObject checkQuery = new BasicDBObject();
                    ArrayList<BasicDBObject> checkwhereQuery = new ArrayList<BasicDBObject>();
                    checkwhereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
                    checkwhereQuery.add(new BasicDBObject("devicePath", image.getDevicePath()));
                    checkwhereQuery.add(new BasicDBObject("fileName", image.getFileName()));
                    checkQuery.put("$and", checkwhereQuery);
                    Document alreadyProccedFile = (Document)deviceRestoredCheckColl.find(checkQuery).first();
                    if (alreadyProccedFile != null) continue;
                    latestFileSizes += image.getSize();
                    Document addedFile = new Document();
                    addedFile.put("deviceUUID", (Object)deviceUUID);
                    addedFile.put("devicePath", (Object)image.getDevicePath());
                    addedFile.put("fileName", (Object)image.getFileName());
                    deviceRestoredCheckColl.insertOne(addedFile);
                }
                break;
            }
        }
        return latestFileSizes;
    }
}

