/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.mongodb.client.MongoCollection;
import com.parablu.pcbd.domain.Office365;
import com.parablu.pcbd.domain.PciAuthorizationTokenElement;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class DumpODBDetails {
    private static final String PERSONAL_URL = "/personal/";
    private static final String BEARER = "Bearer ";
    public static final String HEADER_KEY_ACCEPT = "Accept";
    public static final String HEADER_VALUE_APPLICATION_JSON = "application/json;odata=verbose";
    public static final String HEADER_KEY_CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT = "Accept";
    private static final String APPLICATION_JSON_ODATA_VERBOSE = "application/json;odata=verbose";
    public static final String AUTHORIZATION = "Authorization";

    public static void main(String[] args) throws ConfigurationException, IOException {
        PciAuthorizationTokenElement authorizationTokenElement = DumpODBDetails.convertDocToPCIObj();
        String sizeUrl = DumpODBDetails.getParabluLibrarySizeUrl(authorizationTokenElement.getSharePointUrl(), "vskannan_tatabluescopesteel_com", "PB/1jy87vqulq43d");
        System.out.println(sizeUrl);
        System.out.println("Success...");
    }

    private static void sleepForGivenTime(long sleepTime) {
        long sleepTimeTemp = sleepTime;
        try {
            System.out.println("SleepTime is " + sleepTimeTemp);
            Thread.sleep(sleepTimeTemp * 1000L);
            System.out.println("SleepTime is completed " + sleepTimeTemp);
        }
        catch (InterruptedException e1) {
            System.out.println("Thread interupted error");
        }
    }

    public static String getParabluLibraryExistsUrl(String office365baseUrl, String accountId, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        pbFolderName = "";
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = DumpODBDetails.getPersonalSite(office365baseUrl, accountId);
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(personalSite) + "/_api/web/getFolderByServerRelativeUrl('" + personalUrl + DumpODBDetails.getEmailId(accountId) + "/" + pbFolderName1 + "/')";
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    public static int isFolderExists(String url, PciAuthorizationTokenElement authorizationTokenElement, int retryCount) {
        int result = 0;
        try {
            if (retryCount == 2) {
                System.out.println("Retry reached max so return ");
                return result;
            }
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty(AUTHORIZATION, BEARER + authorizationTokenElement.getAccessToken());
            con.setRequestProperty("Accept", "application/json;odata=verbose");
            int responseCode = con.getResponseCode();
            if (responseCode == 401) {
                authorizationTokenElement = Office365.getAccessToken(authorizationTokenElement);
                return DumpODBDetails.isFolderExists(url, authorizationTokenElement, ++retryCount);
            }
            if (responseCode == 200) {
                return responseCode;
            }
            result = responseCode;
        }
        catch (Exception e) {
            System.out.println("" + e);
            System.out.println("Exception while checking folder exists:" + e.getMessage());
            return 505;
        }
        return result;
    }

    public static String getParabluLibrarySizeUrl(String office365baseUrl, String accountId, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        pbFolderName = "";
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = DumpODBDetails.getPersonalSite(office365baseUrl, accountId);
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(personalSite) + "/_api/web/getFolderByServerRelativeUrl('" + personalUrl + DumpODBDetails.getEmailId(accountId) + "/" + pbFolderName1 + "/')?$select=StorageMetrics&$expand=StorageMetrics";
    }

    private static String getEmailId(String emailId) {
        String replacedEmailId = emailId.replace(".", "_");
        replacedEmailId = replacedEmailId.replace("@", "_");
        return replacedEmailId;
    }

    public static String getPersonalSite(String office365baseUrl, String accountId) {
        if (accountId.contains("sites/")) {
            return String.valueOf(office365baseUrl) + "/" + DumpODBDetails.getEmailId(accountId);
        }
        return String.valueOf(office365baseUrl) + PERSONAL_URL + DumpODBDetails.getEmailId(accountId);
    }

    private static PciAuthorizationTokenElement convertDocToPCIObj(MongoCollection tokenCollection) {
        Document tokenDoc = (Document)tokenCollection.find().first();
        PciAuthorizationTokenElement pciAuthorizationTokenElement = new PciAuthorizationTokenElement();
        pciAuthorizationTokenElement.setAccessToken(tokenDoc.getString("accessToken"));
        pciAuthorizationTokenElement.setAuthenticationToken(tokenDoc.getString("authenticationToken"));
        pciAuthorizationTokenElement.setClientId(tokenDoc.getString("clientId"));
        pciAuthorizationTokenElement.setSharePointUrl(tokenDoc.getString("sharePointUrl"));
        pciAuthorizationTokenElement.setClientSecret(tokenDoc.getString("clientSecret"));
        pciAuthorizationTokenElement.setCloudName(tokenDoc.getString("cloudName"));
        pciAuthorizationTokenElement.setRefreshToken(tokenDoc.getString("refreshToken"));
        return pciAuthorizationTokenElement;
    }

    private static PciAuthorizationTokenElement convertDocToPCIObj() {
        PciAuthorizationTokenElement pciAuthorizationTokenElement = new PciAuthorizationTokenElement();
        pciAuthorizationTokenElement.setAccessToken("eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsIng1dCI6InBpVmxsb1FEU01LeGgxbTJ5Z3FHU1ZkZ0ZwQSIsImtpZCI6InBpVmxsb1FEU01LeGgxbTJ5Z3FHU1ZkZ0ZwQSJ9.eyJhdWQiOiJodHRwczovL3RhdGFibHVlc2NvcGVzdGVlbC1teS5zaGFyZXBvaW50LmNvbS8iLCJpc3MiOiJodHRwczovL3N0cy53aW5kb3dzLm5ldC84ZDFhMGI3Zi0xYjdlLTQ2YzYtODA3OS0yMmUxMTliYzkzODkvIiwiaWF0IjoxNTc5NzExNTA2LCJuYmYiOjE1Nzk3MTE1MDYsImV4cCI6MTU3OTcxNTQwNiwiYWNyIjoiMSIsImFpbyI6IkFTUUEyLzhPQUFBQWdyYWxoR1poRGNCQmRaN21oNXgrUGtaZE9yM2k2TVBpTkRkVzNMMm10Um89IiwiYW1yIjpbInB3ZCJdLCJhcHBfZGlzcGxheW5hbWUiOiJQYXJhQmx1IEluYy4gQXBwIiwiYXBwaWQiOiIxMGJlZDM2Ny04NmI4LTRiODAtODE2NS0yMTc4MWYwMGI1MDAiLCJhcHBpZGFjciI6IjEiLCJmYW1pbHlfbmFtZSI6IkFkbWluIiwiZ2l2ZW5fbmFtZSI6IlBhcmFibHUiLCJpcGFkZHIiOiIxNjUuMjI1LjEwNi4xMDEiLCJuYW1lIjoiUGFyYWJsdSBBZG1pbiIsIm9pZCI6ImJjMTMwNGFkLTBlZDEtNDE1Yy05NjE1LWU2ZTNiNWM0OGFkNyIsIm9ucHJlbV9zaWQiOiJTLTEtNS0yMS0zODMzOTUwMDEtMTE5MjE5NjYxMy0zMTkyODMyNjY4LTQ0NjAxIiwicHVpZCI6IjEwMDMyMDAwNEU1OEMyQUQiLCJzY3AiOiJBbGxTaXRlcy5NYW5hZ2UgQWxsU2l0ZXMuV3JpdGUgTXlGaWxlcy5SZWFkIE15RmlsZXMuV3JpdGUiLCJzaWQiOiIwMzQ3M2NiYS1hZWE4LTQyOWItYjZmZS1lOWM5MzkyOGI1NmIiLCJzdWIiOiJHSXVNd3VNekZOZlMybzVpMHBmVDFYclk1c2I2a0NEb1JlZGx1bjQxWEE0IiwidGlkIjoiOGQxYTBiN2YtMWI3ZS00NmM2LTgwNzktMjJlMTE5YmM5Mzg5IiwidW5pcXVlX25hbWUiOiJwYXJhYmx1YWRtaW5AdGF0YWJsdWVzY29wZXN0ZWVsLmNvbSIsInVwbiI6InBhcmFibHVhZG1pbkB0YXRhYmx1ZXNjb3Blc3RlZWwuY29tIiwidXRpIjoiaTJZdUVyVjNpVWk1TnppNXZjWHZBQSIsInZlciI6IjEuMCIsIndpZHMiOlsiZjI4YTFmNTAtZjZlNy00NTcxLTgxOGItNmExMmYyYWY2YjZjIl19.BTDizM1nlh1y37Nc67tTPOuvIBuqKqu3xEF7k91uJW2UOEhHKePANB7asuZBiprzwQDjbd4faq8Z-QvP25qNPIbZpJm5EuySiwsfMLLqhnXaebaicYJkNaXZZ_j0oj9MDRy3Yp1lKIepe4GVMLKcba1kBWQoPwQWQZXfbo_o1MMqzpeB67Xy8GvN7cS3sC6ybpNDsKGSI8JCwIn8xC6hTSw39Mk5dUntodW1H4zYaNTalqgxmb3kPJm0dWO7glWuTMsUQGosOk-VMVFD0XJf0mZyn3qa8FXWQfTZ_w3wdYlgvqeQ4ymDc_Q1ivoXDATLul8z6XbiUxSae51Pp99IsA");
        pciAuthorizationTokenElement.setAuthenticationToken("eyJ0eXAiOiJKV1QiLCJhbGciOiJub25lIn0.eyJhdWQiOiIxMGJlZDM2Ny04NmI4LTRiODAtODE2NS0yMTc4MWYwMGI1MDAiLCJpc3MiOiJodHRwczovL3N0cy53aW5kb3dzLm5ldC84ZDFhMGI3Zi0xYjdlLTQ2YzYtODA3OS0yMmUxMTliYzkzODkvIiwiaWF0IjoxNTYxNDU5MDE5LCJuYmYiOjE1NjE0NTkwMTksImV4cCI6MTU2MTQ2MjkxOSwiYW1yIjpbInB3ZCJdLCJmYW1pbHlfbmFtZSI6IkFkbWluIiwiZ2l2ZW5fbmFtZSI6IlBhcmFibHUiLCJpcGFkZHIiOiIxNjUuMjI1LjEwNi4xMDEiLCJuYW1lIjoiUGFyYWJsdSBBZG1pbiIsIm9pZCI6ImJjMTMwNGFkLTBlZDEtNDE1Yy05NjE1LWU2ZTNiNWM0OGFkNyIsIm9ucHJlbV9zaWQiOiJTLTEtNS0yMS0zODMzOTUwMDEtMTE5MjE5NjYxMy0zMTkyODMyNjY4LTQ0NjAxIiwic3ViIjoiWk1la1JzdGZzVUZBbEVUcVBNeVh1V0RkMUJVSzdKX3ZUSThLM00tMU1sdyIsInRpZCI6IjhkMWEwYjdmLTFiN2UtNDZjNi04MDc5LTIyZTExOWJjOTM4OSIsInVuaXF1ZV9uYW1lIjoicGFyYWJsdWFkbWluQHRhdGFibHVlc2NvcGVzdGVlbC5jb20iLCJ1cG4iOiJwYXJhYmx1YWRtaW5AdGF0YWJsdWVzY29wZXN0ZWVsLmNvbSIsInZlciI6IjEuMCJ9.");
        pciAuthorizationTokenElement.setClientId("10bed367-86b8-4b80-8165-21781f00b500");
        pciAuthorizationTokenElement.setSharePointUrl("https://tatabluescopesteel-my.sharepoint.com/");
        pciAuthorizationTokenElement.setClientSecret("4SmQu/8jBuKJLQY8VRcHo5unBNHsA4Wn3IB1BRLDw0U=");
        pciAuthorizationTokenElement.setRefreshToken("AQABAAAAAABeAFzDwllzTYGDLh_qYbH85b-jbn4bUDKYSiZcmLAAKVpgJeNtkTxomhgs0ZI6cMCcB18pmuN3Mq_KQN-Z8qkowpFwPEejuoJ4wcXnyH6BYNPdtFtZaHWC14OSt4sF5uEfk-_q8Tnvhki1yhr-_aCe5qAKJ8C7jEqCM6ViwEF3eL4LavDNOXXQfUy28wQAWHA9LzDSlEbaZtmgRtkvinCyTJhUm1JTc_NmwmbtEs4n6Php8tNNNIEZR4RVBf31kqhuaMUZ8ZawdBKfa4b9-665RCLWumDXkqGuB0xZyoJpsYI9xsOn_Qche9Q_6p8WjjdqcYctB2Z6xxG36Zd8RHlnfZfJTxyLOmRQbb6tZKaKE7kV7uovQFNPd8sjxaaGQsoyMLqi9OPNl_YAKOaBJXfNcnBFD25pomm1cRprzKMPoefa6u-q9pbZTlux5rMn1Id-2ZwMRuAAYewrOTZ320E8-y0hi0cGcwLQjVDScpI0MHCtSowXYdHSMKnO4haxWaeNggC2BTPySnR3-sob_6zlbs-zvJZ2xrzw8bmV4HhjCpYdL-rjW-zcz4FipFIif5yeMZrjhhzeHR5VhdGmjTkCbhFzsRj7voR3v3t5WFIoZIebvSHpXosqbe2-tIYSgvllKNyes1eVvbF-xgflToHX48a0Zygv0E3PbYjBtQQmzgEfsC-EbwOYyp2tUbBvlyBCdxSsn-RjjCarETic8g2NSjZUoIZhoUKw9IQ3BbeEBm7g4YNEEiCbuktuZ_Qb1V9F3BSoWk-QAEuRm7u1zxxIxiBiTpWlzDkWrGLW5-StUO6MIrj8Op_ZLhKi_yK3LtUgAA");
        return pciAuthorizationTokenElement;
    }
}

