/*
 * Decompiled with CFR 0.152.
 */
package com.para;

import com.google.common.collect.Iterables;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.domain.Location;
import org.jclouds.openstack.swift.v1.SwiftApiMetadata;

public class BackBlazeUpload {
    static String clientFolderName = "";
    static String cloudStorage = "";
    static String mongofile = "";
    static String backBlazeId = "";
    static String backBlazeKey = "";
    static String bucketName = "";
    static String mongoIP = "";
    static boolean canProxy = false;
    static boolean canType = false;

    public static void main(String[] args) {
        try {
            if (args.length != 9) {
                System.out.println(" backBlazeId/ backBlazeKey/ bucketName/ folderName/ mongofilepath/ mongoIP:mongoPort cannot be empty in config file...Please configure and run again :)");
                System.exit(400);
            }
            backBlazeId = args[0];
            backBlazeKey = args[1];
            bucketName = args[2];
            clientFolderName = args[3];
            mongofile = args[4];
            mongoIP = args[5];
            canProxy = Boolean.parseBoolean(args[6]);
            canType = Boolean.parseBoolean(args[7]);
            cloudStorage = args[8];
            MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + "/parablu001");
            MongoClient client = new MongoClient(uri);
            MongoDatabase db = client.getDatabase(uri.getDatabase());
            MongoCollection mongoDBCollection = db.getCollection("MONGO_PROPERTIES");
            Document mongProperty = (Document)mongoDBCollection.find().first();
            System.out.println(mongProperty);
            BlobStoreContext context = BackBlazeUpload.getBlobStoreContext(cloudStorage, backBlazeId, backBlazeKey, "", "1048576", 2, mongProperty, canProxy, canType);
            BlobStore blobStore = context.getBlobStore();
            File file = new File(mongofile);
            String fileName = file.getName();
            fileName = String.valueOf(clientFolderName) + "/" + fileName;
            Location location = null;
            ApiMetadata apiMetadata = context.unwrap().getProviderMetadata().getApiMetadata();
            if (apiMetadata instanceof SwiftApiMetadata) {
                location = (Location)Iterables.getFirst((Iterable)blobStore.listAssignableLocations(), null);
            }
            System.out.println("..........................");
            Blob blob = blobStore.blobBuilder(fileName).payload(file).contentLength(file.length()).build();
            System.out.println("..........................121212122121");
            String putBlobStr = "";
            putBlobStr = file.length() > 0x500000L ? blobStore.putBlob(bucketName, blob, PutOptions.Builder.multipart()) : blobStore.putBlob(bucketName, blob);
            System.out.println(putBlobStr);
            System.out.println("Status.....0");
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static BlobStoreContext getBlobStoreContext(String providerId, String identity, String passKey, String endpointUrl, String partSize, int numThreads, Document mongProperty, boolean canProxy, boolean canType) {
        Properties properties = new Properties();
        properties.setProperty(String.valueOf(providerId) + ".identity", identity);
        properties.setProperty(String.valueOf(providerId) + ".credential", passKey);
        System.out.println("......providerId11221......." + providerId);
        System.out.println("......identity......." + identity);
        if (!(!canProxy || mongProperty == null || StringUtils.isEmpty((CharSequence)mongProperty.getString((Object)"proxyUserName")) || StringUtils.isEmpty((CharSequence)mongProperty.getString((Object)"proxyPort")) || StringUtils.isEmpty((CharSequence)mongProperty.getString((Object)"proxyHost")) || StringUtils.isEmpty((CharSequence)mongProperty.getString((Object)"proxyPassword")))) {
            if (canType) {
                properties.setProperty("jclouds.proxy-type", "SOCKS");
            }
            System.out.println("......inside .......");
            properties.setProperty("jclouds.proxy-user", mongProperty.getString((Object)"proxyUserName"));
            properties.setProperty("jclouds.proxy-host", mongProperty.getString((Object)"proxyHost"));
            properties.setProperty("jclouds.proxy-password", mongProperty.getString((Object)"proxyPassword"));
            properties.setProperty("jclouds.proxy-port", mongProperty.getString((Object)"proxyPort"));
        }
        ContextBuilder credentials = ContextBuilder.newBuilder((String)providerId).overrides(properties);
        System.out.println("................");
        return (BlobStoreContext)credentials.buildView(BlobStoreContext.class);
    }

    private static boolean createContainerIfNotExists(String containerNameTemp, BlobStore blobStore, Location location) {
        boolean blobExists = false;
        try {
            boolean containerExists = blobStore.containerExists(containerNameTemp);
            if (containerExists) {
                blobExists = true;
            } else {
                boolean isContainerCreated = blobStore.createContainerInLocation(location, containerNameTemp);
                if (isContainerCreated) {
                    blobExists = true;
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            blobExists = false;
        }
        return blobExists;
    }
}

