/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.DriveSearchParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.DriveRequestBuilder;
import com.microsoft.graph.requests.DriveSearchCollectionPage;
import com.microsoft.graph.requests.DriveSearchCollectionRequest;
import com.microsoft.graph.requests.GraphServiceClient;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.httpclient.util.HttpClientUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Request;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.message.BasicStatusLine;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Office365DownloadServiceImplDataTest {
    private static final String BEARER = "Bearer ";
    private static HttpResponse result;
    private PciAuthorizationTokenElement authorizationTokenElement;
    private String deviceUUID;
    private static String downloadUrl;
    private static String proxyUserName;
    private static String password;
    private static String host;
    private static int port;
    private String driveId;
    private static GraphServiceClient<Request> graphClient;
    private static String token;
    private static Logger logger;

    public Office365DownloadServiceImplDataTest(String proxyUserName, String password, String host, int port) {
        Office365DownloadServiceImplDataTest.proxyUserName = proxyUserName;
        Office365DownloadServiceImplDataTest.password = password;
        Office365DownloadServiceImplDataTest.host = host;
        Office365DownloadServiceImplDataTest.port = port;
    }

    public Office365DownloadServiceImplDataTest() {
    }

    public static void main(String[] args) throws IOException {
        token = "eyJ0eXAiOiJKV1QiLCJub25jZSI6IkhaSEt6S3d2NG9ZaGF0MHZ3TWt5czBoSmxXSUo4aXV6Y2FQV3NXN0hiZ2MiLCJhbGciOiJSUzI1NiIsIng1dCI6Im5PbzNaRHJPRFhFSzFqS1doWHNsSFJfS1hFZyIsImtpZCI6Im5PbzNaRHJPRFhFSzFqS1doWHNsSFJfS1hFZyJ9.eyJhdWQiOiJodHRwczovL2dyYXBoLm1pY3Jvc29mdC5jb20vIiwiaXNzIjoiaHR0cHM6Ly9zdHMud2luZG93cy5uZXQvYmZhM2RmYjAtOTFkNS00YmY3LTlhMGMtZmJmNmZmMzM3MTg3LyIsImlhdCI6MTYyNTc0NzIzMiwibmJmIjoxNjI1NzQ3MjMyLCJleHAiOjE2MjU3NTExMzIsImFjY3QiOjAsImFjciI6IjEiLCJhY3JzIjpbInVybjp1c2VyOnJlZ2lzdGVyc2VjdXJpdHlpbmZvIiwidXJuOm1pY3Jvc29mdDpyZXExIiwidXJuOm1pY3Jvc29mdDpyZXEyIiwidXJuOm1pY3Jvc29mdDpyZXEzIiwiYzEiLCJjMiIsImMzIiwiYzQiLCJjNSIsImM2IiwiYzciLCJjOCIsImM5IiwiYzEwIiwiYzExIiwiYzEyIiwiYzEzIiwiYzE0IiwiYzE1IiwiYzE2IiwiYzE3IiwiYzE4IiwiYzE5IiwiYzIwIiwiYzIxIiwiYzIyIiwiYzIzIiwiYzI0IiwiYzI1Il0sImFpbyI6IkFVUUF1LzhUQUFBQUZvN3U1QW5FRkUySWZVdzNzd0JyZEs1TXRTZkVRcm56WDlRUDFXVE00WEIrbXV3VXkycTF5aTNMMVRNbVV1U2twblRNVTFFS3ZXKzVSdjg4ZDUxanVRPT0iLCJhbXIiOlsicHdkIiwibWZhIl0sImFwcF9kaXNwbGF5bmFtZSI6IjM2NWthciIsImFwcGlkIjoiNzY1N2RkN2EtNTBhZC00M2NlLTkyMGYtYmE1ZjE2OWM1NmE1IiwiYXBwaWRhY3IiOiIxIiwiZmFtaWx5X25hbWUiOiJCQUNLVVAiLCJnaXZlbl9uYW1lIjoiR0FWTElTRCIsImlkdHlwIjoidXNlciIsImlwYWRkciI6IjEyMi4xODIuMTkyLjk2IiwibmFtZSI6IkdBVkxJU0QgQkFDS1VQIiwib2lkIjoiODNmZGVlY2MtZjI3NS00YzgyLTg5ODktNTQ2N2NjOTM4ZjMzIiwib25wcmVtX3NpZCI6IlMtMS01LTIxLTIwMDA0NzgzNTQtNjAyMTYyMzU4LTcyNTM0NTU0My05MzcwNiIsInBsYXRmIjoiMyIsInB1aWQiOiIxMDAzN0ZGRUE3NkZGODdDIiwicmgiOiIwLkFTVUFzTi1qdjlXUjkwdWFEUHYyX3pOeGgzcmRWM2F0VU01RGtnLTZYeGFjVnFVbEFPay4iLCJzY3AiOiJDb250YWN0cy5SZWFkV3JpdGUgQ29udGFjdHMuUmVhZFdyaXRlLlNoYXJlZCBEaXJlY3RvcnkuQWNjZXNzQXNVc2VyLkFsbCBEaXJlY3RvcnkuUmVhZC5BbGwgRGlyZWN0b3J5LlJlYWRXcml0ZS5BbGwgRVdTLkFjY2Vzc0FzVXNlci5BbGwgRmlsZXMuUmVhZC5BbGwgRmlsZXMuUmVhZFdyaXRlLkFsbCBHcm91cC5SZWFkV3JpdGUuQWxsIE1haWwuUmVhZFdyaXRlIE1haWwuUmVhZFdyaXRlLkFsbCBNYWlsLlJlYWRXcml0ZS5TaGFyZWQgTWFpbGJveFNldHRpbmdzLlJlYWRXcml0ZSBSb2xlTWFuYWdlbWVudC5SZWFkLkRpcmVjdG9yeSBSb2xlTWFuYWdlbWVudC5SZWFkV3JpdGUuRGlyZWN0b3J5IFRhc2tzLlJlYWRXcml0ZSBUYXNrcy5SZWFkV3JpdGUuU2hhcmVkIFVzZXIuUmVhZC5BbGwiLCJzdWIiOiJtYm0xc3JCcTdHYVlibTJsZ3hJc2ZHSlhWZEtxU0xIRHdiQlVNdlZKSmFnIiwidGVuYW50X3JlZ2lvbl9zY29wZSI6IkFTIiwidGlkIjoiYmZhM2RmYjAtOTFkNS00YmY3LTlhMGMtZmJmNmZmMzM3MTg3IiwidW5pcXVlX25hbWUiOiJnYXZsaXNkYmFja3VwQGdvZHJlamFncm92ZXQuY29tIiwidXBuIjoiZ2F2bGlzZGJhY2t1cEBnb2RyZWphZ3JvdmV0LmNvbSIsInV0aSI6IjdXLUsxdmdvb2stT3k2bU50ODhKQVEiLCJ2ZXIiOiIxLjAiLCJ3aWRzIjpbImI3OWZiZjRkLTNlZjktNDY4OS04MTQzLTc2YjE5NGU4NTUwOSJdLCJ4bXNfdGNkdCI6MTMzNjcyNTA0N30.bUFWNZoH8zEP0xh5I9SO4J9rI2FJxS693G3_SjTpSwI5ihrmOfZaXhHwAGrr8AljuCdPlPs1F5AxhWvNTXLLFYaJYiUcT3i-Jh0Ttbv5mYr4meCTQaD3CMFN6ak3kH1VyyTWOc1YGJEkCL62LcfKWBILPBkMnaUQniJ6kp3AZfnrIB6W1BOYeO1BS27UgZOvpKFl6Hd3qegJ-ujDYn-9WCI6-G4HqcuYvQrqVvUx_0s0qi-mpKbt_mN6xwdFlA18x1W-27liFj7YWokVmUb-QLdCRX042p2UWTi0X-8YyDMG5oNnwSw_b_zn3TMP26y2VQKE0sgI5WHPDiHmEKF21w";
        Office365DownloadServiceImplDataTest.getGraphClient();
        for (int i = 0; i < 1; ++i) {
            Office365DownloadServiceImplDataTest.loopFileDownloads();
        }
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString((String)deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        System.out.println("convert..." + convertedString);
        return convertedString;
    }

    protected static HttpResponse executeDownload() throws ClientProtocolException, IOException {
        System.out.println(" ............new path................." + downloadUrl);
        HttpGet httpGet = new HttpGet(downloadUrl);
        httpGet.addHeader("Authorization", BEARER + token);
        httpGet.addHeader("Accept", "application/json;odata=verbose");
        httpGet.addHeader("Content-Type", "*/*");
        if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
            System.out.println(" without proxy ....");
            HttpClient httpclient = Office365DownloadServiceImplDataTest.getSSlConnection();
            result = httpclient.execute((HttpUriRequest)httpGet);
        } else {
            System.out.println(" using proxy ....");
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
            CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            HttpHost proxy = new HttpHost(host, port);
            RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
            httpGet.setConfig(config);
            result = httpclient.execute((HttpUriRequest)httpGet);
        }
        System.out.println(result.getStatusLine().getReasonPhrase() + "...Inside execute..." + result.getStatusLine().getStatusCode());
        return result;
    }

    public static HttpClient getSSlConnection() {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }}, new SecureRandom());
        }
        catch (KeyManagementException e) {
            logger.trace("KeyManagementException: " + e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.trace("NoSuchAlgorithmException : " + e);
        }
        SSLSocketFactory sf = new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sf);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(httpsScheme);
        BasicClientConnectionManager cm = new BasicClientConnectionManager(schemeRegistry);
        return new DefaultHttpClient((ClientConnectionManager)cm);
    }

    protected HttpResponse executeDownloadUsingGraph() throws IOException, ClientProtocolException {
        try {
            HttpGet httpGet = new HttpGet(downloadUrl);
            httpGet.addHeader("Authorization", BEARER + this.authorizationTokenElement.getAccessToken());
            httpGet.addHeader("Accept", "application/json;odata=verbose");
            httpGet.addHeader("Content-Type", "*/*");
            if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                System.out.println("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
            }
            if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                System.out.println(" without proxy ....");
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                result = httpclient.execute((HttpUriRequest)httpGet);
            } else {
                System.out.println(" using proxy ....");
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                HttpHost proxy = new HttpHost(host, port);
                RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                httpGet.setConfig(config);
                result = httpclient.execute((HttpUriRequest)httpGet);
            }
            System.out.println(result.getStatusLine().getReasonPhrase() + "...Inside execute..." + result.getStatusLine().getStatusCode());
        }
        catch (GraphServiceException e) {
            logger.error("... failed graph exception ... " + e.getResponseCode());
            DefaultHttpResponseFactory factory = new DefaultHttpResponseFactory();
            result = factory.newHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, e.getResponseCode(), null), null);
        }
        return result;
    }

    public static void searchItem() throws IOException {
        block4: {
            String driveId = "";
            String id = "";
            try {
                DriveSearchParameterSet searchset = new DriveSearchParameterSet();
                searchset.q = "+jUhe8ac+11OFD3VIkXp8Q";
                DriveSearchCollectionPage search = (DriveSearchCollectionPage)((DriveSearchCollectionRequest)((DriveRequestBuilder)graphClient.users("samis@testpara.onmicrosoft.com").drives().byId("b!cojjwYW6I06HL4g7EaVDWXJ6poHprAZGmVW0O5eTNxR1lU0yD4W4SJO1-L7UUcqk")).search(searchset).buildRequest(new Option[0])).get();
                if (search == null) {
                    System.out.println("Search object is null...");
                    return;
                }
                String itemId = "";
                for (DriveItem driveItem : search.getCurrentPage()) {
                    System.out.println(driveItem.id + "..." + driveItem.name);
                    itemId = driveItem.id;
                }
                System.out.println("search result:" + itemId);
                System.out.println("driveId:" + driveId + " Item id:" + id);
                InputStream stream = graphClient.drives(driveId).items(itemId).content().buildRequest(new Option[0]).get();
                System.out.println("stream...." + stream.available());
                String text = IOUtils.toString((InputStream)stream, (String)StandardCharsets.UTF_8.name());
                System.out.println("text...." + text);
            }
            catch (GraphServiceException e) {
                System.out.println("exception...." + e.getMessage());
                if (e.getResponseCode() != 401) break block4;
                System.out.println("un authorized........");
            }
        }
    }

    public static void loopFileDownloads() {
        try {
            String driveid = "b!px_fqYvx_ECuVzald1Z3MFEfQJa5XuVLslfL0kpj-4GhBEZ1ae32QblezU5n23Te";
            ArrayList<String> folderPaths = new ArrayList<String>();
            folderPaths.add("1iun5ftrxanvo/4/aje+z+UK15EIbgtjckU9NQ");
            folderPaths.add("1iun5ftrxanvo/14/BNVdYxM+sH7_g9+37Of2hg");
            folderPaths.add("1iun5ftrxanvo/5/3OTdLBE5vlGAXZo40bGC_A");
            folderPaths.add("1iun5ftrxanvo/3/z6JyGTFZ8+b6Ae_dP+EKLw");
            folderPaths.add("1iun5ftrxanvo/2/f0TOWpKCp6HLtEBDeQfwuw");
            folderPaths.add("1iun5ftrxanvo/5/3OTdLBE5vlGAXZo40bGC_A");
            folderPaths.add("1iun5ftrxanvo/92/6rBa2p3u3vZpBlwLlSuahg");
            folderPaths.add("1iun5ftrxanvo/128/yMKw9U7n+aN0aoIgf6rp_w");
            folderPaths.add("1iun5ftrxanvo/7/u2NUZ5RcN6Egyt8jK8LJtg");
            folderPaths.add("1iun5ftrxanvo/1/IXmGsy_Q7qjgyuTYI8+X3Q");
            folderPaths.add("1iun5ftrxanvo/1/5W+oXOm27_v32Aw1jFNuzw");
            folderPaths.add("1iun5ftrxanvo/132/8ivMrvxJ9gAMogHZi4Pr6Q");
            folderPaths.add("1iun5ftrxanvo/3/3iJVSKjKiG8qjoFuW4A04A");
            folderPaths.add("1iun5ftrxanvo/2/OT5nUb9Fhha7kzq1bv36gg");
            folderPaths.add("1iun5ftrxanvo/92/turNRhxYJNv_6uWfssYvGw");
            folderPaths.add("1iun5ftrxanvo/1/gRGoV7hpDrJbWxSVGxqFZg");
            folderPaths.add("1iun5ftrxanvo/7/u2NUZ5RcN6Egyt8jK8LJtg");
            folderPaths.add("1iun5ftrxanvo/4/kstbgucMfpr+n5SJXuaw4w");
            folderPaths.add("1iun5ftrxanvo/7/KdItn+Flk9a_ilqD3kQA3g");
            folderPaths.add("1iun5ftrxanvo/2/8c4kGvEEewaD6hfBSkkrFQ");
            for (String folderPath : folderPaths) {
                downloadUrl = "https://graph.microsoft.com/v1.0/drives/" + driveid + "/root:/" + folderPath + ":/content";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("erro dowloadin....");
        }
    }

    private static GraphServiceClient<Request> getGraphClient() {
        String authorityHost = "https://login.microsoftonline.com";
        logger.debug("...helper constant ...." + PCHelperConstant.getMSClientId());
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("https://graph.microsoft.com/.default");
        TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
        GraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).buildClient();
        return graphClient;
    }

    private static boolean isPBDrive(String json) {
        boolean pbDrive = false;
        String webUrl = "";
        try {
            JSONObject jsonObject = new JSONObject(json);
            webUrl = (String)jsonObject.get("webUrl");
            String docLibraryName = webUrl.substring(webUrl.lastIndexOf("/") + 1);
            if (!StringUtils.isEmpty((String)docLibraryName) && docLibraryName.equalsIgnoreCase("PB")) {
                pbDrive = true;
            }
        }
        catch (Exception e) {
            logger.error(webUrl + "...unable to get drive .... " + e.getMessage());
            pbDrive = false;
        }
        return pbDrive;
    }

    public HttpResponse getResult() {
        return result;
    }

    public void setResult(HttpResponse result) {
        Office365DownloadServiceImplDataTest.result = result;
    }

    public PciAuthorizationTokenElement getToken() {
        return this.authorizationTokenElement;
    }

    public void setToken(PciAuthorizationTokenElement authorizationTokenElement) {
        this.authorizationTokenElement = authorizationTokenElement;
    }

    public String getDeviceUUID() {
        return this.deviceUUID;
    }

    public void setDeviceUUID(String deviceUUID) {
        this.deviceUUID = deviceUUID;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        Office365DownloadServiceImplDataTest.downloadUrl = downloadUrl;
    }

    public String getDriveId() {
        return this.driveId;
    }

    public void setDriveId(String driveId) {
        this.driveId = driveId;
    }

    static {
        token = "";
        logger = LoggerFactory.getLogger(Office365DownloadServiceImplDataTest.class);
    }
}

