/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.requests.GraphServiceClient;
import com.parablu.bluvault.udc.service.AADManagementService;
import com.parablu.cloud.security.service.impl.UserValidateService;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.AADAuthorizationTokenElement;
import com.parablu.paracloud.element.AADCredentialsElement;
import com.parablu.paracloud.element.AADUserElement;
import com.parablu.paracloud.element.AADUserNamesList;
import com.parablu.paracloud.element.GraphGroupInfo;
import com.parablu.paracloud.element.GraphResponseForMemberOf;
import com.parablu.paracloud.element.OktaUserElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pcbd.dao.AADDao;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.AuthorizationDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.MigrationStatusDao;
import com.parablu.pcbd.dao.PortalPropertiesDao;
import com.parablu.pcbd.dao.SettingsDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AADAuthorizationToken;
import com.parablu.pcbd.domain.AADCredentials;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.MigrationStatus;
import com.parablu.pcbd.domain.PortalProperties;
import com.parablu.pcbd.domain.Proxy;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.dao.SyncPolicyDao;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class AADManagementServiceImpl
extends UserValidateService
implements AADManagementService {
    private static Logger logger = LogManager.getLogger(AADManagementServiceImpl.class);
    public static final String AUTHORITY = "https://login.microsoftonline.com/common/";
    public static final String GRAPH_VERSION = "v1.0/";
    public static final String GRAPH_VERSION_BETA = "beta/";
    public static final String GRAPH_ME = "me";
    public static final String GRAPH_HOME = "https://graph.microsoft.com/";
    public static final String GRAPH_MEMBER_OF = "me/memberOf";
    public static final String GRAPH_USER_MEMBER_OF = "/memberOf";
    public static final String GRAPH_USERS = "/users/";
    public static final String GRAPH_GROUP_DELTA = "groups/delta";
    private static final String TOKEN_URL = "https://login.windows.net/";
    private static final String OAUTH2_TOKEN_URL = "/oauth2/token";
    private static final String TOKEN = "/token";
    private static final String UTF_8 = "UTF-8";
    private static final String REFRESH_TOKEN = "refresh_token";
    public static final String CONTENT_TYPE = "Content-Type";
    private static final String EXCEPTION = " Exception  :";
    private static final String BACK_UP_ENABLED = "Backup Enabled";
    private static final String SYNC_ENABLED = "Sync Enabled";
    private static final String AUTHORIZATION_CODE = "authorization_code";
    private static final String LOGIN_URL = "https://login.microsoftonline.com/";
    private static final String OKTA_LOGIN_URL = "/oauth2/v1";
    private static final String HTTPS = "https://";
    public static final String GRAPH_USER = "/users";
    private AADDao aadDao;
    private UserDao userDao;
    private BackupPolicyDao backupPolicyDao;
    private SyncPolicyDao syncPolicyDao;
    private MigrationStatusDao migrationStatusDao;
    private SettingsDao settingsDao;
    @Autowired
    private PortalPropertiesDao portalPropertiesDao;
    @Resource
    private CloudDao cloudDao;
    @Resource
    private DeviceDao deviceDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private AuthorizationDao authorizationDao;

    public CloudDao getCloudDao() {
        return this.cloudDao;
    }

    public void setCloudDao(CloudDao cloudDao) {
        this.cloudDao = cloudDao;
    }

    public DeviceDao getDeviceDao() {
        return this.deviceDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public AuthorizationDao getAuthorizationDao() {
        return this.authorizationDao;
    }

    public void setAuthorizationDao(AuthorizationDao authorizationDao) {
        this.authorizationDao = authorizationDao;
    }

    public AuditHistoryDao getAuditHistoryDao() {
        return this.auditHistoryDao;
    }

    public void setAuditHistoryDao(AuditHistoryDao auditHistoryDao) {
        this.auditHistoryDao = auditHistoryDao;
    }

    public AADDao getAadDao() {
        return this.aadDao;
    }

    public void setAadDao(AADDao aadDao) {
        this.aadDao = aadDao;
    }

    @Override
    public AADCredentialsElement getAADCredentials(int cloudId) {
        logger.debug("......Inside getAADCredentials....");
        AADCredentialsElement aadCredentialsElement = null;
        AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloudId);
        if (aadCredentials != null) {
            aadCredentialsElement = new AADCredentialsElement();
            BeanUtils.copyProperties((Object)aadCredentials, (Object)aadCredentialsElement);
            AADAuthorizationToken token = this.aadDao.getAADAuthorizationtoken(cloudId);
            if (token == null) {
                aadCredentialsElement.setAuthRequired(true);
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)token.getUser_principal())) {
                aadCredentialsElement.setUser_principal(token.getUser_principal());
            }
        }
        return aadCredentialsElement;
    }

    @Override
    public AADAuthorizationToken getAADAuthorizationToken(int cloudId) {
        logger.debug("......Inside getAADCredentials....");
        return this.aadDao.getAADAuthorizationtoken(cloudId);
    }

    @Override
    public void saveAADCredentials(int cloudId, AADCredentialsElement aadCredentials) {
        logger.debug("......Inside saveAADCredentials....");
        if (aadCredentials != null) {
            try {
                this.aadDao.removeAADCredentials(cloudId);
                AADCredentials credentials = new AADCredentials();
                BeanUtils.copyProperties((Object)aadCredentials, (Object)credentials);
                HashMap groupConfig = new HashMap();
                Map groupConfig2 = credentials.getGroupConfig();
                for (Map.Entry entry : groupConfig2.entrySet()) {
                    groupConfig.put(((String)entry.getKey()).replace(".", "#").toLowerCase(), entry.getValue());
                }
                credentials.setGroupConfig(groupConfig);
                this.aadDao.saveAADCredentials(cloudId, credentials);
            }
            catch (Exception e) {
                logger.debug("failed during save ad creadentials" + e);
                logger.error("failed during save ad creadentials......" + e.getMessage());
            }
        }
    }

    @Override
    public void saveAADAuthorizationtoken(int cloudId, AADAuthorizationTokenElement aadAuthorizationTokenElement) {
        logger.debug("......Inside saveAADAuthorizationtoken...." + aadAuthorizationTokenElement.toString());
        if (aadAuthorizationTokenElement != null) {
            AADAuthorizationToken authorizationToken = this.aadDao.getAADAuthorizationtoken(cloudId);
            if (authorizationToken == null) {
                authorizationToken = new AADAuthorizationToken();
            }
            BeanUtils.copyProperties((Object)aadAuthorizationTokenElement, (Object)authorizationToken);
            try {
                AADUserElement aadUserElement = this.getAADUserByAccessToken(authorizationToken.getAccess_token());
                if (aadUserElement != null && !org.springframework.util.StringUtils.isEmpty((Object)aadUserElement.getMail())) {
                    authorizationToken.setUser_principal(aadUserElement.getMail());
                }
            }
            catch (Exception e) {
                logger.debug("failed getUserInfoFromGraph" + e);
                logger.error("failed getUserInfoFromGraph......" + e.getMessage());
            }
            logger.debug("......Inside saveAADAuthorizationtoken...." + authorizationToken.toString());
            this.aadDao.saveAADAuthorizationtoken(cloudId, authorizationToken);
        }
    }

    @Override
    public AADUserElement getAADUserByAccessToken(String accessToken) throws IOException, JsonParseException, JsonMappingException {
        String userInfoFromGraph = this.getUserInfoFromGraph(accessToken);
        logger.debug(".....userInfoFromGraph......." + userInfoFromGraph);
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        AADUserElement aadUserElement = (AADUserElement)mapper.readValue(userInfoFromGraph, AADUserElement.class);
        return aadUserElement;
    }

    public UserDao getUserDao() {
        return this.userDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public BackupPolicyDao getBackupPolicyDao() {
        return this.backupPolicyDao;
    }

    public void setBackupPolicyDao(BackupPolicyDao backupPolicyDao) {
        this.backupPolicyDao = backupPolicyDao;
    }

    public SyncPolicyDao getSyncPolicyDao() {
        return this.syncPolicyDao;
    }

    public void setSyncPolicyDao(SyncPolicyDao syncPolicyDao) {
        this.syncPolicyDao = syncPolicyDao;
    }

    public MigrationStatusDao getMigrationStatusDao() {
        return this.migrationStatusDao;
    }

    public void setMigrationStatusDao(MigrationStatusDao migrationStatusDao) {
        this.migrationStatusDao = migrationStatusDao;
    }

    public Object getAccessTokenFromUserCredentials(String username, String password, String clientID) {
        logger.debug("...clientID...." + clientID);
        AuthenticationResult result = null;
        ExecutorService service = Executors.newSingleThreadExecutor();
        try (Closeable close = service::shutdown;){
            AuthenticationContext context = new AuthenticationContext(AUTHORITY, false, service);
            if (this.getProxy(1) != null) {
                context.setProxy(this.getProxy(1));
            }
            Future future = context.acquireToken(GRAPH_HOME, clientID, username, password, null);
            result = (AuthenticationResult)future.get();
        }
        catch (Exception exp) {
            logger.error("Exception while getting AccessToken From UserCredentials................." + exp);
            logger.trace("Exception while getting AccessToken From UserCredentials................." + exp.getMessage());
        }
        return result;
    }

    @Override
    public Object getAADUser(Cloud cloud, String userName, String password) {
        AADUserElement user = null;
        try {
            String userString;
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloud.getCloudId());
            if (aadCredentials == null) {
                logger.debug("AAD crediential is empty so return");
                return user;
            }
            AuthenticationResult authenticationResult = (AuthenticationResult)this.getAccessTokenFromUserCredentials(userName, password, aadCredentials.getClientIdForLogin());
            if (authenticationResult != null && !org.springframework.util.StringUtils.isEmpty((Object)authenticationResult.getAccessToken()) && (user = (AADUserElement)mapper.readValue(userString = this.getUserInfoFromGraph(authenticationResult.getAccessToken()), AADUserElement.class)) != null) {
                String userGroupInfo;
                boolean bkpEnabled = false;
                boolean syncEnabled = false;
                if (!CollectionUtils.isEmpty((Map)aadCredentials.getGroupConfig()) && !org.springframework.util.StringUtils.isEmpty((Object)(userGroupInfo = this.getUserGroupsFromUserToken(authenticationResult.getAccessToken())))) {
                    GraphResponseForMemberOf forMemberOf = (GraphResponseForMemberOf)mapper.readValue(userGroupInfo, GraphResponseForMemberOf.class);
                    if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupConfig().keySet().stream().filter(line -> !org.springframework.util.StringUtils.isEmpty((Object)line)).collect(Collectors.toSet()))) {
                        List groupInfo = forMemberOf.getGroupInfo();
                        List groupNames = groupInfo.stream().map(group -> group.getDisplayName().toLowerCase()).collect(Collectors.toList());
                        for (String groupName : aadCredentials.getGroupConfig().keySet()) {
                            if (org.springframework.util.StringUtils.isEmpty((Object)groupName)) {
                                if ("BACKUP".equals(aadCredentials.getGroupConfig().get(groupName))) {
                                    bkpEnabled = true;
                                }
                                if ("SYNC".equals(aadCredentials.getGroupConfig().get(groupName))) {
                                    syncEnabled = true;
                                    continue;
                                }
                                bkpEnabled = true;
                                syncEnabled = true;
                                continue;
                            }
                            if (CollectionUtils.isEmpty(groupNames) || !groupNames.contains(groupName.toLowerCase())) continue;
                            if ("BACKUP".equals(aadCredentials.getGroupConfig().get(groupName))) {
                                bkpEnabled = true;
                                continue;
                            }
                            if ("SYNC".equals(aadCredentials.getGroupConfig().get(groupName))) {
                                syncEnabled = true;
                                continue;
                            }
                            bkpEnabled = true;
                            syncEnabled = true;
                        }
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get(""))) {
                    if (((String)aadCredentials.getGroupConfig().get("")).equals("BACKUP")) {
                        bkpEnabled = true;
                    } else if (((String)aadCredentials.getGroupConfig().get("")).equals("SYNC")) {
                        syncEnabled = true;
                    } else {
                        bkpEnabled = true;
                        syncEnabled = true;
                    }
                }
                if (bkpEnabled && syncEnabled) {
                    user.setProductType("BOTH");
                } else if (bkpEnabled) {
                    user.setProductType("BACKUP");
                } else if (syncEnabled) {
                    user.setProductType("SYNC");
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception while getting userInfo from UserName and Password................." + e);
            logger.trace("Exception while getting userInfo from UserName and Password................." + e.getMessage());
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserInfoFromGraph(String accessToken) {
        CloseableHttpResponse result;
        CloseableHttpClient httpclient;
        StringBuilder response;
        block22: {
            response = new StringBuilder();
            httpclient = null;
            HttpGet httpGet = null;
            result = null;
            try {
                String url = "https://graph.microsoft.com/beta/me";
                Proxy proxy = this.settingsDao.getProxy(1);
                if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                    logger.debug("host :" + PCHelperConstant.getProxyHost());
                    logger.debug("port :" + PCHelperConstant.getProxyPort());
                    HttpHost proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                    httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                } else {
                    httpclient = HttpClients.custom().build();
                }
                httpGet = new HttpGet(url);
                httpGet.addHeader("Authorization", "Bearer " + accessToken);
                httpGet.addHeader("Accept", "application/json");
                result = httpclient.execute((HttpUriRequest)httpGet);
                int httpResponseCode = result.getStatusLine().getStatusCode();
                logger.debug("Status code ..." + httpResponseCode);
                if (httpResponseCode == 200) {
                    InputStream inputStream = result.getEntity().getContent();
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                        String inputLine;
                        while ((inputLine = in.readLine()) != null) {
                            response.append(inputLine);
                        }
                    }
                }
                if (httpGet == null) break block22;
            }
            catch (Exception e) {
                block23: {
                    try {
                        logger.error("Exception while getting userInfo ................." + e);
                        logger.trace("Exception while getting userInfo ................." + e.getMessage());
                        if (httpGet == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (httpGet != null) {
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                        throw throwable;
                    }
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
            }
            httpGet.releaseConnection();
        }
        this.closeResponse(result);
        this.closeHttpClient(httpclient);
        return response.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUserGroupsFromUserToken(String accessToken) {
        CloseableHttpResponse result;
        CloseableHttpClient httpclient;
        StringBuilder response;
        block21: {
            response = new StringBuilder();
            httpclient = null;
            HttpGet httpGet = null;
            result = null;
            try {
                String url = "https://graph.microsoft.com/v1.0/me/memberOf";
                Proxy proxy = this.settingsDao.getProxy(1);
                if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                    logger.debug("host :" + PCHelperConstant.getProxyHost());
                    logger.debug("port :" + PCHelperConstant.getProxyPort());
                    HttpHost proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                    httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                } else {
                    httpclient = HttpClients.custom().build();
                }
                httpGet = new HttpGet(url);
                httpGet.addHeader("Authorization", "Bearer " + accessToken);
                httpGet.addHeader("Accept", "application/json");
                result = httpclient.execute((HttpUriRequest)httpGet);
                int httpResponseCode = result.getStatusLine().getStatusCode();
                logger.debug("getUserGroupsFromGraph ........response code ......... " + httpResponseCode);
                InputStream inputStream = result.getEntity().getContent();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                }
                if (httpGet == null) break block21;
            }
            catch (Exception e) {
                try {
                    throw new BaseException("Exception while getting groups " + e.getMessage(), 500);
                }
                catch (Throwable throwable) {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    throw throwable;
                }
            }
            httpGet.releaseConnection();
        }
        this.closeResponse(result);
        this.closeHttpClient(httpclient);
        logger.debug("getUserGroupsFromGraph ........... body..........." + response.toString());
        return response.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAllGroupInfo(String accessToken) {
        CloseableHttpResponse result;
        CloseableHttpClient httpclient;
        StringBuilder response;
        block21: {
            response = new StringBuilder();
            httpclient = null;
            HttpGet httpGet = null;
            result = null;
            try {
                String url = "https://graph.microsoft.com/v1.0/me/memberOf";
                Proxy proxy = this.settingsDao.getProxy(1);
                if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                    logger.debug("host :" + PCHelperConstant.getProxyHost());
                    logger.debug("port :" + PCHelperConstant.getProxyPort());
                    HttpHost proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                    httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                } else {
                    httpclient = HttpClients.custom().build();
                }
                httpGet = new HttpGet(url);
                httpGet.addHeader("Authorization", "Bearer " + accessToken);
                httpGet.addHeader("Accept", "application/json");
                result = httpclient.execute((HttpUriRequest)httpGet);
                int httpResponseCode = result.getStatusLine().getStatusCode();
                logger.debug("getUserGroupsFromGraph ........response code ......... " + httpResponseCode);
                InputStream inputStream = result.getEntity().getContent();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                }
                if (httpGet == null) break block21;
            }
            catch (Exception e) {
                try {
                    throw new BaseException("Exception while getting groups " + e.getMessage(), 500);
                }
                catch (Throwable throwable) {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    throw throwable;
                }
            }
            httpGet.releaseConnection();
        }
        this.closeResponse(result);
        this.closeHttpClient(httpclient);
        logger.debug("getUserGroupsFromGraph ........... body..........." + response.toString());
        return response.toString();
    }

    @Override
    public List<AADUserElement> getAADUsersFromUserNames(int cloudId, AADUserNamesList aadUserNameList) {
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadToken == null || org.springframework.util.StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return null;
        }
        ArrayList<AADUserElement> aadUsersList = new ArrayList<AADUserElement>();
        for (String userName : aadUserNameList.getAadUserNames()) {
            User user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
            if (user == null || user != null && user.isGuest()) {
                AADUserElement aadUser = this.getAADUserFromUserName(cloudId, userName);
                if (aadUser != null) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)aadUser.getProductType())) {
                        logger.debug("user is not part any group " + aadUser.getUserPrincipalName());
                        continue;
                    }
                    aadUser.setUserName(userName);
                    aadUsersList.add(aadUser);
                    continue;
                }
                logger.debug("...........User " + userName + " .........  Not found in AAD Or token expired.........");
                continue;
            }
            logger.debug("$##############################" + userName + " ........present in our db....");
        }
        logger.debug("...........aadUsersList size... " + aadUsersList.size());
        return aadUsersList;
    }

    @Override
    public AADUserElement getAADUserFromUserName(int cloudId, String userName) {
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadToken == null || org.springframework.util.StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return null;
        }
        AADUserElement aadUser = null;
        User user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        if (user == null) {
            aadUser = this.getAADUserFromUserName(userName, aadToken);
            if (aadUser != null) {
                logger.debug("...........User " + aadUser.getUserName() + " .........found in AAD");
                String productType = "";
                AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloudId);
                logger.debug(".................." + aadCredentials.toString());
                if (!CollectionUtils.isEmpty((Map)aadCredentials.getGroupConfig())) {
                    boolean bkpEnabled = false;
                    boolean syncEnabled = false;
                    boolean o365Enabled = false;
                    if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupConfig().keySet().stream().filter(line -> !org.springframework.util.StringUtils.isEmpty((Object)line)).collect(Collectors.toSet()))) {
                        List<String> userMemberOf = this.getAADUserGroupInfo(userName, aadToken);
                        if (!CollectionUtils.isEmpty(userMemberOf)) {
                            for (String group : userMemberOf) {
                                logger.debug("User is memeber of ............" + group.toLowerCase());
                                if (org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get(group.toLowerCase()))) continue;
                                if (((String)aadCredentials.getGroupConfig().get(group)).equals("BACKUP")) {
                                    bkpEnabled = true;
                                    continue;
                                }
                                if (((String)aadCredentials.getGroupConfig().get(group)).equals("SYNC")) {
                                    syncEnabled = true;
                                    continue;
                                }
                                if (((String)aadCredentials.getGroupConfig().get(group)).equals("O365")) {
                                    o365Enabled = true;
                                    continue;
                                }
                                bkpEnabled = true;
                                syncEnabled = true;
                            }
                        }
                    } else {
                        productType = (String)aadCredentials.getGroupConfig().values().iterator().next();
                    }
                    logger.debug("............................" + (String)aadCredentials.getGroupConfig().get("") + "........" + !org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get("")));
                    if (!org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get(""))) {
                        if (((String)aadCredentials.getGroupConfig().get("")).equals("BACKUP")) {
                            bkpEnabled = true;
                        } else if (((String)aadCredentials.getGroupConfig().get("")).equals("SYNC")) {
                            syncEnabled = true;
                        } else if (((String)aadCredentials.getGroupConfig().get("")).equals("O365")) {
                            o365Enabled = true;
                        } else {
                            bkpEnabled = true;
                            syncEnabled = true;
                        }
                    }
                    if (bkpEnabled && syncEnabled && o365Enabled) {
                        productType = "BACKUPSYNCO365";
                    } else if (bkpEnabled && syncEnabled) {
                        productType = "BACKUPSYNC";
                    } else if (bkpEnabled) {
                        productType = "BACKUP";
                    } else if (syncEnabled) {
                        productType = "SYNC";
                    } else if (o365Enabled) {
                        productType = "O365";
                    }
                }
                aadUser.setProductType(productType);
            } else {
                logger.debug("...........User " + userName + " .........  Not found in AAD");
            }
        } else {
            logger.debug("$##############################" + userName + " ........present in our db....");
        }
        if (aadUser != null) {
            logger.debug("AAD User Element ...." + aadUser.toString());
        }
        return aadUser;
    }

    @Override
    public AADUserElement getAADUserFromUserNameToSync(int cloudId, String userName) {
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadToken == null || org.springframework.util.StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return null;
        }
        AADUserElement aadUser = null;
        aadUser = this.getAADUserFromUserName(userName, aadToken);
        if (aadUser != null) {
            logger.debug(aadUser.getId() + "...........User . .........found in AAD.." + aadUser.getUserPrincipalName() + "....user..." + userName);
            String productType = "";
            AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloudId);
            logger.debug(".................." + aadCredentials.toString());
            if (!CollectionUtils.isEmpty((Map)aadCredentials.getGroupConfig())) {
                boolean bkpEnabled = false;
                boolean syncEnabled = false;
                boolean o365Enabled = false;
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupConfig().keySet().stream().map(line -> line).filter(line -> !org.springframework.util.StringUtils.isEmpty((Object)line)).collect(Collectors.toSet()))) {
                    List<String> userMemberOf = this.getAADUserGroupInfo(userName, aadToken);
                    if (!CollectionUtils.isEmpty(userMemberOf)) {
                        for (String group : userMemberOf) {
                            logger.debug(aadUser.getUserPrincipalName() + "...User is member of ............" + group);
                            if (org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get(group))) continue;
                            if (((String)aadCredentials.getGroupConfig().get(group)).equals("BACKUP")) {
                                bkpEnabled = true;
                                continue;
                            }
                            if (((String)aadCredentials.getGroupConfig().get(group)).equals("SYNC")) {
                                syncEnabled = true;
                                continue;
                            }
                            if (((String)aadCredentials.getGroupConfig().get(group)).equals("O365")) {
                                o365Enabled = true;
                                continue;
                            }
                            bkpEnabled = true;
                            syncEnabled = true;
                            o365Enabled = true;
                        }
                    }
                } else {
                    productType = (String)aadCredentials.getGroupConfig().values().iterator().next();
                }
                logger.debug(bkpEnabled + ".." + syncEnabled + "..." + o365Enabled + ".......checkmemberof...................." + (String)aadCredentials.getGroupConfig().get("") + "........" + !org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get("")));
                if (!org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get(""))) {
                    if (((String)aadCredentials.getGroupConfig().get("")).equals("BACKUP")) {
                        bkpEnabled = true;
                    } else if (((String)aadCredentials.getGroupConfig().get("")).equals("SYNC")) {
                        syncEnabled = true;
                    } else if (((String)aadCredentials.getGroupConfig().get("")).equals("O365")) {
                        o365Enabled = true;
                    } else {
                        bkpEnabled = true;
                        syncEnabled = true;
                        o365Enabled = true;
                    }
                }
                if (bkpEnabled && syncEnabled) {
                    productType = "BOTH";
                    aadUser.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
                    aadUser.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
                    aadUser.setDefaultOdbPolicy(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
                } else if (bkpEnabled) {
                    productType = "BACKUP";
                    aadUser.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
                } else if (syncEnabled) {
                    productType = "SYNC";
                    aadUser.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
                } else if (o365Enabled) {
                    productType = "O365";
                    aadUser.setDefaultOdbPolicy(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
                }
            }
            aadUser.setProductType(productType);
        } else {
            logger.debug("...........User " + userName + " .........  Not found in AAD");
        }
        return aadUser;
    }

    @Override
    public void synUserAttributes(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloudId);
        AADAuthorizationToken authToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadCredentials != null && authToken != null && !org.springframework.util.StringUtils.isEmpty((Object)authToken.getAccess_token())) {
            List<AADUserElement> aadUserElements = this.syncNewGroupChanges(cloud, aadCredentials, authToken);
            if (CollectionUtils.isEmpty(aadUserElements)) {
                logger.debug("....no users to sync check the group....");
                return;
            }
            aadCredentials = this.aadDao.getAADCredentials(cloudId);
            Set groupsInDB = aadCredentials.getGroupConfig().keySet().stream().filter(group -> !org.springframework.util.StringUtils.isEmpty((Object)group)).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(groupsInDB)) {
                logger.debug("Group name is empty after collection so retun..");
                return;
            }
            ArrayList<AADUserElement> result = new ArrayList<AADUserElement>();
            HashSet<String> titles = new HashSet<String>();
            for (AADUserElement item : aadUserElements) {
                if (!titles.add(item.getUserPrincipalName())) continue;
                result.add(item);
            }
            logger.debug(aadUserElements.size() + "...overall list before and after.." + result.size());
            aadUserElements = result;
            Map<String, AADUserElement> aadMap = aadUserElements.stream().collect(Collectors.toMap(aaduser -> aaduser.getUserPrincipalName().toLowerCase(), aaduser -> aaduser));
            List allUsers = this.userDao.getAllUsers(cloudId);
            HashMap<String, User> userMap = new HashMap<String, User>();
            for (User user : allUsers) {
                if (user.isLocalUser()) continue;
                String userName = user.getUserName();
                if (!org.springframework.util.StringUtils.isEmpty((Object)user.getAadLoginId())) {
                    userName = user.getAadLoginId();
                }
                userMap.put(userName.toLowerCase(), user);
            }
            for (User user : allUsers) {
                logger.debug("guest user..." + user.getUserName());
                if (!user.isGuest()) continue;
                logger.debug("guest user.mail.." + user.getEmailId());
                if (!aadMap.containsKey(user.getUserName().toLowerCase()) && !aadMap.containsKey(user.getEmailId())) continue;
                this.userDao.removeUserbyID(cloudId, user.getUserId().toString());
                userMap.remove(user.getUserName());
                userMap.remove(user.getEmailId());
                logger.debug("removeUserbyID.........." + user.getUserId());
            }
            logger.debug(aadMap.size() + ".....map diff ..." + userMap.size());
            for (Map.Entry entry : userMap.entrySet()) {
                User existingUser = (User)entry.getValue();
                if (aadMap.containsKey(entry.getKey())) {
                    long totalExchangekpUsers;
                    long totalOdbBkpUsers;
                    int noOfExchangeUsersAllowed;
                    int noOfOneDriveUsersAllowed;
                    long totalBkpUsers;
                    int noOfBkpUsersAllowed;
                    long totalSyncUsers;
                    int noOfSyncUsersAllowed;
                    AADUserElement aadUserElement = aadMap.get(entry.getKey());
                    logger.debug("...already in user iteration..." + (String)entry.getKey());
                    boolean anyChange = false;
                    if (!anyChange && aadUserElement.isBackupEnabled() != existingUser.isBackupEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isSyncEnabled() != existingUser.isSyncEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isO365Enabled() != existingUser.isOnedriveBkpEnabled()) {
                        anyChange = true;
                    }
                    if (existingUser.isSoftBlockEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange) continue;
                    if (aadUserElement.isSyncEnabled() && (long)(noOfSyncUsersAllowed = cloud.getNoOfSyncUsersAllowed()) <= (totalSyncUsers = this.userDao.countOfPresentSyncUsers(cloud.getCloudId(), cloud.getCloudName(), true))) {
                        logger.debug(" SYNC USER LIMIT REACHED........");
                        aadUserElement.setSyncEnabled(false);
                    }
                    if (aadUserElement.isBackupEnabled() && (long)(noOfBkpUsersAllowed = cloud.getNoOfBackupUsersAllowed()) <= (totalBkpUsers = this.userDao.countOfPresentBackupUsers(cloud.getCloudId(), cloud.getCloudName(), true, true))) {
                        logger.debug(" BACKUP USER LIMIT REACHED........");
                        aadUserElement.setBackupEnabled(false);
                    }
                    if (aadUserElement.isO365Enabled() && (long)((noOfOneDriveUsersAllowed = cloud.getNoOfOneDriveUsersAllowed()) + (noOfExchangeUsersAllowed = cloud.getNoOfExchangeUsersAllowed())) <= (totalOdbBkpUsers = this.userDao.countOfPresentOnedriveUsers(cloud.getCloudId(), true)) + (totalExchangekpUsers = this.userDao.countOfPresentExchangeUsers(cloud.getCloudId(), true))) {
                        logger.debug("Office USER LIMIT REACHED........");
                        aadUserElement.setO365Enabled(false);
                    }
                    if (!(aadUserElement.isBackupEnabled() || aadUserElement.isSyncEnabled() || aadUserElement.isO365Enabled() || existingUser.isSoftBlockEnabled())) {
                        logger.error(existingUser.getUserName() + "...user limit reached ...." + existingUser.isSoftBlockEnabled());
                        return;
                    }
                    boolean previStatus = existingUser.isActive();
                    existingUser.setBackupEnabled(aadUserElement.isBackupEnabled());
                    existingUser.setSyncEnabled(aadUserElement.isSyncEnabled());
                    existingUser.setOnedriveBkpEnabled(aadUserElement.isO365Enabled());
                    existingUser.setExchangeBkpEnabled(aadUserElement.isO365Enabled());
                    existingUser.setSoftBlockEnabled(false);
                    existingUser.setActive(true);
                    this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                    this.deviceDao.updateUserStatusInDeviceBkpOverview(cloudId, existingUser);
                    this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                    continue;
                }
                logger.debug("...inside blocking existing user" + (String)entry.getKey());
                if (cloudProperties != null && cloudProperties.isSoftBlockEnabled()) {
                    existingUser.setSoftBlockEnabled(true);
                    this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                    continue;
                }
                boolean previStatus = existingUser.isActive();
                existingUser.setBackupEnabled(false);
                existingUser.setSyncEnabled(false);
                existingUser.setOnedriveBkpEnabled(false);
                existingUser.setActive(false);
                this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                this.deviceDao.updateUserInfoInDeviceBkpOverview(cloud.getCloudId(), existingUser);
                this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                this.changeDeviceStatusAndAduit(cloud, existingUser);
            }
            for (Map.Entry entry : aadMap.entrySet()) {
                if (userMap.containsKey(entry.getKey())) continue;
                logger.debug("...adding new user to user collection..." + (String)entry.getKey());
                AADUserElement aadUserElement = aadMap.get(entry.getKey());
                this.updateOrCreateAADUserInfo(cloud, aadUserElement);
            }
        } else {
            logger.debug("Either aadCredentials or authToken or accessToken is Empty so no Sync");
        }
    }

    private List<AADUserElement> syncNewGroupChanges(Cloud cloud, AADCredentials aadCredentials, AADAuthorizationToken authToken) {
        ArrayList<Object> aadUserElements = new ArrayList<AADUserElement>();
        try {
            Set groupsInDB = aadCredentials.getGroupConfig().keySet().stream().filter(group -> !org.springframework.util.StringUtils.isEmpty((Object)group)).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(groupsInDB)) {
                logger.debug("Group name is empty so retun..");
                return aadUserElements;
            }
            groupsInDB = groupsInDB.stream().map(String::toLowerCase).collect(Collectors.toSet());
            ArrayList<String> userGroupMembers = new ArrayList<String>();
            for (String groupName : groupsInDB) {
                logger.debug("..group nnmae.. " + groupName);
                String groupId = this.getGroupId(cloud.getCloudId(), groupName);
                logger.debug("..group nnmae1.. " + groupName + "..groupId.." + groupId);
                List<String> groupMembersInfo = this.getGroupMembersInfo(groupId, authToken);
                userGroupMembers.addAll(groupMembersInfo);
            }
            logger.debug("...usermemberslist..." + userGroupMembers.size());
            for (String memberId : userGroupMembers) {
                logger.debug("Inside.....member..." + memberId);
                AADUserElement aadUser = this.getAADUserFromUserNameToSync(cloud.getCloudId(), memberId);
                if (aadUser == null) continue;
                boolean isSyncEnabled = false;
                boolean isBackupEnabled = false;
                boolean isO365Enabled = false;
                List list = cloud.getCloudCustomisableDetails();
                for (CloudCustomisableDetails customisableDetails : list) {
                    if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                        isSyncEnabled = true;
                    }
                    if (customisableDetails.getName().equalsIgnoreCase(BACK_UP_ENABLED)) {
                        isBackupEnabled = true;
                    }
                    if (!"OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
                    isO365Enabled = true;
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)aadUser.getProductType())) {
                    logger.debug("User not part of any product" + aadUser.getUserName());
                    continue;
                }
                if ("SYNC".equalsIgnoreCase(aadUser.getProductType())) {
                    isBackupEnabled = false;
                    isO365Enabled = false;
                }
                if ("BACKUP".equalsIgnoreCase(aadUser.getProductType())) {
                    isSyncEnabled = false;
                    isO365Enabled = false;
                }
                if ("O365".equalsIgnoreCase(aadUser.getProductType())) {
                    isSyncEnabled = false;
                    isBackupEnabled = false;
                }
                aadUser.setBackupEnabled(isBackupEnabled);
                aadUser.setSyncEnabled(isSyncEnabled);
                aadUser.setO365Enabled(isO365Enabled);
                aadUserElements.add(aadUser);
            }
        }
        catch (Exception e) {
            logger.error(" Exception  :..........." + e);
            logger.debug(" Exception  :..........." + e.getMessage());
            aadUserElements = new ArrayList();
        }
        return aadUserElements;
    }

    @Override
    public AADUserElement getAADUsersFromUserName(int cloudId, String userName) {
        AADUserElement aadUser = null;
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadToken == null || org.springframework.util.StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return null;
        }
        User user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        if (user == null || user != null && user.isGuest()) {
            aadUser = this.getAADUserFromUserName(userName, aadToken);
            if (aadUser != null) {
                logger.debug("...........User " + aadUser.getUserName() + " .........found in AAD");
            } else {
                logger.debug("...........User " + userName + " .........  Not found in AAD");
            }
        } else {
            logger.debug("$##############################" + userName + " ........present in our db....");
        }
        return aadUser;
    }

    @Override
    public boolean checkTokenExpired(int cloudId) {
        boolean isTokenExpired = false;
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadToken == null || org.springframework.util.StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return isTokenExpired;
        }
        AADAuthorizationToken accessTokenAndUpdateInDB = this.getAccessTokenAndUpdateInDB(aadToken);
        if (accessTokenAndUpdateInDB == null) {
            logger.debug("..token is expred so send the mail");
            isTokenExpired = true;
        }
        return isTokenExpired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private AADUserElement getAADUserFromUserName(String userName, AADAuthorizationToken authToken) {
        response = new StringBuilder();
        httpclient = null;
        httpGet = null;
        result = null;
        aadUser = null;
        retry = false;
        retryCount = 0;
        mapper = new ObjectMapper();
        do {
            block26: {
                block30: {
                    block27: {
                        block29: {
                            block24: {
                                block25: {
                                    mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                                    url = this.getUserInfoUrl(userName);
                                    AADManagementServiceImpl.logger.debug("url to get the user from aad:" + url);
                                    proxy = this.settingsDao.getProxy(1);
                                    if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                                        AADManagementServiceImpl.logger.debug("host :" + PCHelperConstant.getProxyHost());
                                        AADManagementServiceImpl.logger.debug("port :" + PCHelperConstant.getProxyPort());
                                        proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                                        routePlanner = new DefaultProxyRoutePlanner(proxyval);
                                        httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                                    } else {
                                        httpclient = HttpClients.custom().build();
                                    }
                                    httpGet = new HttpGet(url);
                                    httpGet.addHeader("Authorization", "Bearer " + authToken.getAccess_token());
                                    httpGet.addHeader("Accept", "application/json");
                                    result = httpclient.execute((HttpUriRequest)httpGet);
                                    httpResponseCode = result.getStatusLine().getStatusCode();
                                    AADManagementServiceImpl.logger.debug("getAADUserFromUserName ........response code ......... " + httpResponseCode);
                                    if (httpResponseCode != 401) ** GOTO lbl47
                                    retry = true;
                                    ++retryCount;
                                    if ((authToken = this.getAccessTokenAndUpdateInDB(authToken)) != null) break block24;
                                    AADManagementServiceImpl.logger.debug("..token is expred ....");
                                    routePlanner = null;
                                    if (httpGet == null) break block25;
                                    httpGet.releaseConnection();
                                }
                                this.closeResponse(result);
                                this.closeHttpClient(httpclient);
                                return routePlanner;
                            }
                            this.getAADUserFromUserName(userName, authToken);
                            break block26;
lbl47:
                            // 1 sources

                            if (httpResponseCode != 200) break block27;
                            inputStream = result.getEntity().getContent();
                            in = new BufferedReader(new InputStreamReader(inputStream));
                            var16_18 = null;
                            try {
                                while ((inputLine = in.readLine()) != null) {
                                    response.append(inputLine);
                                }
                            }
                            catch (Throwable var17_21) {
                                var16_18 = var17_21;
                                throw var17_21;
                            }
                            finally {
                                if (in != null) {
                                    if (var16_18 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable var17_20) {
                                            var16_18.addSuppressed(var17_20);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                            }
                            aadUser = (AADUserElement)mapper.readValue(response.toString(), AADUserElement.class);
                            if (httpGet == null) break block29;
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                        break;
                    }
                    try {
                        AADManagementServiceImpl.logger.debug("..........user not fount.........");
                        if (httpGet == null) break block30;
                    }
                    catch (Exception e) {
                        block31: {
                            try {
                                AADManagementServiceImpl.logger.trace("" + e);
                                AADManagementServiceImpl.logger.error(" ERROR trying to get AADUser From UserName " + e.getMessage());
                                retry = true;
                                ++retryCount;
                                if (httpGet == null) break block31;
                            }
                            catch (Throwable var20_24) {
                                if (httpGet != null) {
                                    httpGet.releaseConnection();
                                }
                                this.closeResponse(result);
                                this.closeHttpClient(httpclient);
                                throw var20_24;
                            }
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                    }
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                break;
            }
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
        } while (retry && retryCount < 2);
        return aadUser;
    }

    private void closeHttpClient(CloseableHttpClient httpclient) {
        if (httpclient != null) {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                logger.error("error in closing http client:" + e.getMessage());
            }
        }
    }

    private void closeResponse(CloseableHttpResponse result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (IOException e) {
                logger.error("error in closing http client:" + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List<String> getAADUserGroupInfo(String userName, AADAuthorizationToken authToken) {
        response = new StringBuilder();
        userMemeberOf = new ArrayList<String>();
        userMemeberOfSet = new HashSet<T>();
        retry = false;
        retryCount = 0;
        httpclient = null;
        httpGet = null;
        result = null;
        mapper = new ObjectMapper();
        if (userName.contains("#")) {
            userName.replace("#", "%23");
        }
        if (userName.contains("%")) {
            userName.replace("%", "%25");
        }
        url = "https://graph.microsoft.com/v1.0//users/" + userName + "/memberOf";
        isSkipTokenAvailable = false;
        do {
            block29: {
                block33: {
                    block31: {
                        block32: {
                            block27: {
                                block28: {
                                    mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                                    AADManagementServiceImpl.logger.debug(".....url...." + url);
                                    proxy = this.settingsDao.getProxy(1);
                                    if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                                        AADManagementServiceImpl.logger.debug("host :" + PCHelperConstant.getProxyHost());
                                        AADManagementServiceImpl.logger.debug("port :" + PCHelperConstant.getProxyPort());
                                        proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                                        routePlanner = new DefaultProxyRoutePlanner(proxyval);
                                        httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                                    } else {
                                        httpclient = HttpClients.custom().build();
                                    }
                                    httpGet = new HttpGet(url);
                                    httpGet.addHeader("Authorization", "Bearer " + authToken.getAccess_token());
                                    httpGet.addHeader("Accept", "application/json");
                                    result = httpclient.execute((HttpUriRequest)httpGet);
                                    httpResponseCode = result.getStatusLine().getStatusCode();
                                    AADManagementServiceImpl.logger.debug(userName + "..........getAADUserFromUserName ........response code ......... " + httpResponseCode);
                                    if (httpResponseCode != 401) ** GOTO lbl56
                                    retry = true;
                                    ++retryCount;
                                    accessTokenAndUpdateInDB = this.getAccessTokenAndUpdateInDB(authToken);
                                    if (accessTokenAndUpdateInDB != null) break block27;
                                    AADManagementServiceImpl.logger.debug("token is expired so return");
                                    var17_19 = null;
                                    if (httpGet == null) break block28;
                                    httpGet.releaseConnection();
                                }
                                this.closeResponse(result);
                                this.closeHttpClient(httpclient);
                                return var17_19;
                            }
                            this.getAADUserGroupInfo(userName, authToken);
                            break block29;
lbl56:
                            // 1 sources

                            if (httpResponseCode != 200) break block29;
                            inputStream = result.getEntity().getContent();
                            in = new BufferedReader(new InputStreamReader(inputStream));
                            var18_20 = null;
                            try {
                                while ((inputLine = in.readLine()) != null) {
                                    response.append(inputLine);
                                }
                            }
                            catch (Throwable inputLine) {
                                var18_20 = inputLine;
                                throw inputLine;
                            }
                            finally {
                                if (in != null) {
                                    if (var18_20 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable inputLine) {
                                            var18_20.addSuppressed(inputLine);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                            }
                            forMemberOf = (GraphResponseForMemberOf)mapper.readValue(response.toString(), GraphResponseForMemberOf.class);
                            if (forMemberOf != null && !CollectionUtils.isEmpty((Collection)forMemberOf.getGroupInfo())) {
                                groupInfo = forMemberOf.getGroupInfo();
                                userMemberList = groupInfo.stream().map((Function<GraphGroupInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getAADUserGroupInfo$9(com.parablu.paracloud.element.GraphGroupInfo ), (Lcom/parablu/paracloud/element/GraphGroupInfo;)Ljava/lang/String;)()).collect(Collectors.toList());
                                userMemeberOf.addAll(userMemberList);
                                userMemeberOfSet.addAll(userMemberList);
                            }
                            response = new StringBuilder();
                            if (org.springframework.util.StringUtils.isEmpty((Object)forMemberOf.getNextLink())) ** GOTO lbl105
                            AADManagementServiceImpl.logger.debug(url + ".... link available....." + forMemberOf.getNextLink());
                            if (!url.equalsIgnoreCase(forMemberOf.getNextLink())) break block31;
                            AADManagementServiceImpl.logger.debug(url + ".... link available.but same...." + userMemeberOfSet);
                            isSkipTokenAvailable = false;
                            if (httpGet == null) break block32;
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                        break;
                    }
                    try {
                        url = forMemberOf.getNextLink();
                        isSkipTokenAvailable = true;
lbl105:
                        // 2 sources

                        if (!org.springframework.util.StringUtils.isEmpty((Object)forMemberOf.getNextLink())) break block29;
                        AADManagementServiceImpl.logger.debug("....no link available.....");
                        isSkipTokenAvailable = false;
                        if (httpGet == null) break block33;
                    }
                    catch (Exception e) {
                        block34: {
                            try {
                                AADManagementServiceImpl.logger.trace("" + e);
                                AADManagementServiceImpl.logger.error(" ERROR trying to get getAADUserGroupInfo " + e.getMessage());
                                retry = true;
                                ++retryCount;
                                if (httpGet == null) break block34;
                            }
                            catch (Throwable var22_26) {
                                if (httpGet != null) {
                                    httpGet.releaseConnection();
                                }
                                this.closeResponse(result);
                                this.closeHttpClient(httpclient);
                                throw var22_26;
                            }
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                    }
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                break;
            }
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
        } while (retry && retryCount < 2 || isSkipTokenAvailable);
        return userMemeberOf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AADAuthorizationToken getAccessTokenAndUpdateInDB(AADAuthorizationToken aadAuthToken) {
        CloseableHttpResponse result;
        CloseableHttpClient httpclient;
        block11: {
            int httpResponseCode;
            String refreshToken;
            String accessToken;
            HttpPost httPost;
            block9: {
                AADAuthorizationToken aADAuthorizationToken;
                block10: {
                    AADCredentials aadCredentials = this.aadDao.getAADCredentials(1);
                    httpclient = null;
                    httPost = null;
                    result = null;
                    accessToken = "";
                    refreshToken = "";
                    logger.debug("  getAccessToken............HttpURLConnection.............................");
                    Proxy proxy = this.settingsDao.getProxy(1);
                    if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                        logger.debug("host :" + PCHelperConstant.getProxyHost());
                        logger.debug("port :" + PCHelperConstant.getProxyPort());
                        HttpHost proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                        httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                    } else {
                        httpclient = HttpClients.custom().build();
                    }
                    String loginUrl = TOKEN_URL + aadCredentials.getTenentId() + OAUTH2_TOKEN_URL;
                    httPost = new HttpPost(loginUrl);
                    logger.debug("...loginUrl..." + loginUrl);
                    ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                    params.add(new BasicNameValuePair("grant_type", REFRESH_TOKEN));
                    params.add(new BasicNameValuePair("client_id", aadCredentials.getClientId()));
                    params.add(new BasicNameValuePair(REFRESH_TOKEN, aadAuthToken.getRefresh_token()));
                    params.add(new BasicNameValuePair("client_secret", aadCredentials.getSecretKey()));
                    httPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, UTF_8));
                    httPost.setHeader(CONTENT_TYPE, "application/x-www-form-urlencoded");
                    result = httpclient.execute((HttpUriRequest)httPost);
                    httpResponseCode = result.getStatusLine().getStatusCode();
                    logger.debug("......getAccessTokenAndUpdateInDB....." + httpResponseCode);
                    if (httpResponseCode != 400) break block9;
                    logger.error("TOKEN has expired so remap the token...... ");
                    aADAuthorizationToken = null;
                    if (httPost == null) break block10;
                    httPost.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                return aADAuthorizationToken;
            }
            try {
                String line;
                InputStream inputStream = result.getEntity().getContent();
                BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder response = new StringBuilder("");
                while ((line = rd.readLine()) != null) {
                    response.append(line);
                }
                rd.close();
                JSONObject jsonObject = new JSONObject(response.toString());
                accessToken = jsonObject.optString("access_token");
                logger.debug(httpResponseCode + "...aceestoken................." + accessToken);
                refreshToken = jsonObject.optString(REFRESH_TOKEN);
                this.aadDao.updateRefreshToken(1, refreshToken, accessToken);
                aadAuthToken.setAccess_token(accessToken);
                aadAuthToken.setRefresh_token(refreshToken);
                if (httPost == null) break block11;
            }
            catch (Exception e) {
                block12: {
                    try {
                        logger.trace("" + e);
                        logger.error(" ERROR trying to get access token ...HttpURLConnection " + e.getMessage());
                        if (httPost == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (httPost != null) {
                            httPost.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                        throw throwable;
                    }
                    httPost.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
            }
            httPost.releaseConnection();
        }
        this.closeResponse(result);
        this.closeHttpClient(httpclient);
        return aadAuthToken;
    }

    private void updateOrCreateAADUserInfo(Cloud cloud, AADUserElement aadUserElement) {
        try {
            User existingUser;
            boolean exchangeBkpEnabled;
            boolean odbBkpEnabled;
            boolean isBackupEnabled;
            boolean isSyncEnabled;
            block33: {
                logger.debug(aadUserElement.getProductType() + "............updateOrCreateAADUserInfo......................." + aadUserElement.getUserPrincipalName());
                isSyncEnabled = false;
                isBackupEnabled = false;
                odbBkpEnabled = false;
                exchangeBkpEnabled = false;
                List list = cloud.getCloudCustomisableDetails();
                for (CloudCustomisableDetails customisableDetails : list) {
                    if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                        isSyncEnabled = true;
                    }
                    if (customisableDetails.getName().equalsIgnoreCase(BACK_UP_ENABLED)) {
                        isBackupEnabled = true;
                    }
                    if ("OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                        odbBkpEnabled = true;
                    }
                    if (!"Exchange Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
                    exchangeBkpEnabled = true;
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)aadUserElement.getProductType())) {
                    logger.debug("User not part of any product");
                    return;
                }
                if ("SYNC".equalsIgnoreCase(aadUserElement.getProductType())) {
                    isBackupEnabled = false;
                    exchangeBkpEnabled = false;
                    odbBkpEnabled = false;
                }
                if ("BACKUP".equalsIgnoreCase(aadUserElement.getProductType())) {
                    isSyncEnabled = false;
                    exchangeBkpEnabled = false;
                    odbBkpEnabled = false;
                }
                if ("O365".equalsIgnoreCase(aadUserElement.getProductType())) {
                    isSyncEnabled = false;
                    isBackupEnabled = false;
                }
                User user = new User();
                UUID uuid = UUID.randomUUID();
                String recoveryKey = String.valueOf(uuid);
                user.setSecurityRecoveryKey(recoveryKey);
                user.setActive(true);
                user.setSoftBlockEnabled(false);
                user.setAdmin(false);
                user.setBackupEnabled(isBackupEnabled);
                user.setSyncEnabled(isSyncEnabled);
                user.setFirstLogin(true);
                user.setShareEnabled(true);
                user.setUserName(aadUserElement.getUserPrincipalName());
                if (org.springframework.util.StringUtils.isEmpty((Object)aadUserElement.getMail())) {
                    user.setEmailId(aadUserElement.getUserPrincipalName());
                } else {
                    user.setEmailId(aadUserElement.getMail());
                }
                user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
                user.setDisplayName(aadUserElement.getDisplayName());
                user.setMigratedBy("AUTO");
                user.setlocalUser(false);
                user.setLocation(aadUserElement.getOfficeLocation());
                user.setDepartment(aadUserElement.getDepartment());
                user.setAccountStatus(true);
                user.setUserNameLowerCase(aadUserElement.getUserPrincipalName().toLowerCase());
                if (isBackupEnabled) {
                    user.setPolicyName(aadUserElement.getDefaultPolicy());
                }
                if (isSyncEnabled) {
                    user.setSyncPolicyName(aadUserElement.getDefaultSyncPolicy());
                }
                user.setOnedriveBkpEnabled(odbBkpEnabled);
                user.setExchangeBkpEnabled(exchangeBkpEnabled);
                if (odbBkpEnabled) {
                    user.setOneDrivePolicyName(aadUserElement.getDefaultOdbPolicy());
                }
                if (exchangeBkpEnabled) {
                    user.setExchangePolicyName(aadUserElement.getDefaultOdbPolicy());
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)aadUserElement.getDefaultOdbPolicy())) {
                    user.setOneDrivePolicyName(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
                }
                UserElement userElement = new UserElement();
                BeanUtils.copyProperties((Object)user, (Object)userElement);
                existingUser = null;
                try {
                    long totalExchangekpUsers;
                    int noOfExchangeUsersAllowed;
                    long totalOdbBkpUsers;
                    int noOfOdbBkpUsersAllowed;
                    long totalBkpUsers;
                    int noOfBkpUsersAllowed;
                    long totalSyncUsers;
                    int noOfSyncUsersAllowed;
                    if (isSyncEnabled && (long)(noOfSyncUsersAllowed = cloud.getNoOfSyncUsersAllowed()) <= (totalSyncUsers = this.userDao.countOfPresentSyncUsers(cloud.getCloudId(), cloud.getCloudName(), true))) {
                        logger.debug(" SYNC USER LIMIT REACHED........");
                        isSyncEnabled = false;
                    }
                    if (isBackupEnabled && (long)(noOfBkpUsersAllowed = cloud.getNoOfBackupUsersAllowed()) <= (totalBkpUsers = this.userDao.countOfPresentBackupUsers(cloud.getCloudId(), cloud.getCloudName(), true, true))) {
                        logger.debug(" BACKUP USER LIMIT REACHED........");
                        isBackupEnabled = false;
                    }
                    if (odbBkpEnabled && (long)(noOfOdbBkpUsersAllowed = cloud.getNoOfOneDriveUsersAllowed()) <= (totalOdbBkpUsers = this.userDao.countOfPresentOnedriveUsers(cloud.getCloudId(), true))) {
                        logger.debug("Onedrive USER LIMIT REACHED........");
                        odbBkpEnabled = false;
                    }
                    if (exchangeBkpEnabled && (long)(noOfExchangeUsersAllowed = cloud.getNoOfExchangeUsersAllowed()) <= (totalExchangekpUsers = this.userDao.countOfPresentExchangeUsers(cloud.getCloudId(), true))) {
                        logger.debug("exchange USER LIMIT REACHED........");
                        odbBkpEnabled = false;
                    }
                    PortalProperties portalProperties = this.portalPropertiesDao.getPortalProperties(cloud.getCloudId(), PCHelperConstant.getPropertyValueComponentName());
                    logger.debug(".....BLUDRIVE_MODE..." + portalProperties.getComponentsProperties().get("BLUDRIVE_MODE"));
                    if (portalProperties.getComponentsProperties().get("BLUDRIVE_MODE").toString().equals("false")) {
                        user.setSyncAccessType("WEBANDENDPOINT");
                        logger.debug("....BLUDRIVE_MODE is false so set ..WEBANDENDPOINT");
                    } else {
                        user.setSyncAccessType("WEBONLY");
                        logger.debug("....BLUDRIVE_MODE is true so set ..WEBONLY");
                    }
                    user.setOnedriveBkpEnabled(odbBkpEnabled);
                    user.setExchangeBkpEnabled(exchangeBkpEnabled);
                    user.setBackupEnabled(isBackupEnabled);
                    user.setSyncEnabled(isSyncEnabled);
                    String googleSecretKey = this.getGoogleSecurityKey();
                    logger.debug("googleSecretKey for AAD ....." + googleSecretKey);
                    user.setGoogleSecretKey(googleSecretKey);
                    userElement.setGoogleSecretKey(googleSecretKey);
                    userElement.setOnedriveBkpEnabled(odbBkpEnabled);
                    userElement.setExchangeBkpEnabled(exchangeBkpEnabled);
                    userElement.setBackupEnabled(isBackupEnabled);
                    userElement.setSyncEnabled(isSyncEnabled);
                    userElement.setAzureUniqueId(aadUserElement.getId());
                    userElement.setUserPrinicipalName(aadUserElement.getUserPrincipalName());
                    userElement.setSyncAccessType(user.getSyncAccessType());
                    logger.debug("...aad creating user...." + userElement.getUserName() + ".." + isBackupEnabled + "..." + isSyncEnabled + "..." + odbBkpEnabled + "..." + exchangeBkpEnabled);
                    if (!(isBackupEnabled || isSyncEnabled || odbBkpEnabled || exchangeBkpEnabled)) {
                        logger.error("...user limit reached ....");
                        return;
                    }
                    logger.debug("...acturalcreating user...." + userElement.getUserName() + ".." + isBackupEnabled + "..." + isSyncEnabled + "..." + odbBkpEnabled + "..." + exchangeBkpEnabled);
                    UserElement createduserElement = this.createUser(cloud.getCloudId(), cloud.getCloudName(), userElement, true, this.userDao);
                    if (createduserElement != null) {
                        MigrationStatus migrationStatus = new MigrationStatus();
                        migrationStatus.setMigratedBy("AUTO");
                        migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
                        migrationStatus.setMigrated(true);
                        migrationStatus.setUserName(user.getUserName());
                        migrationStatus.setEmailId(user.getEmailId());
                        this.migrationStatusDao.saveMigrationStatus(cloud.getCloudId(), migrationStatus);
                        this.saveStatisticToDatabase(cloud.getCloudId(), cloud.getCloudName(), "MIGRATION", "AUTO", aadUserElement.getUserPrincipalName(), "AAD", System.currentTimeMillis(), PCActionTypes.ADD_USER_MIGRATION.getActionTypeValue());
                    }
                }
                catch (BaseException e) {
                    logger.debug("...error message " + e.getMessage());
                    if (e.getErrorStatus() != 1200) break block33;
                    logger.debug("User already exists......");
                    existingUser = this.userDao.getUserByUserNameOrAADLoginId(cloud.getCloudId(), aadUserElement.getUserPrincipalName());
                }
            }
            if (existingUser != null) {
                logger.debug("...inside updating existing user" + odbBkpEnabled + ".." + exchangeBkpEnabled);
                boolean previStatus = existingUser.isActive();
                existingUser.setBackupEnabled(isBackupEnabled);
                existingUser.setSyncEnabled(isSyncEnabled);
                existingUser.setOnedriveBkpEnabled(odbBkpEnabled);
                existingUser.setExchangeBkpEnabled(exchangeBkpEnabled);
                if (!(isBackupEnabled || isSyncEnabled || odbBkpEnabled || exchangeBkpEnabled)) {
                    existingUser.setActive(false);
                    existingUser.setSoftBlockEnabled(true);
                } else if (!existingUser.isActive()) {
                    long countOfPresentUsers = this.userDao.countOfPresentUsers(cloud.getCloudId(), cloud.getCloudName(), true);
                    int noOfUsersAllowed = cloud.getNoOfUsersAllowed();
                    if ((long)noOfUsersAllowed <= countOfPresentUsers) {
                        logger.debug(noOfUsersAllowed + "..User limit reached........." + countOfPresentUsers);
                        return;
                    }
                    existingUser.setActive(true);
                    existingUser.setSoftBlockEnabled(false);
                }
                this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                this.deviceDao.updateUserInfoInDeviceBkpOverview(cloud.getCloudId(), existingUser);
                this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                if (!existingUser.isActive()) {
                    this.changeDeviceStatusAndAduit(cloud, existingUser);
                }
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e);
            logger.debug(EXCEPTION + e.getMessage());
        }
    }

    private void changeDeviceStatusAndAduit(Cloud cloud, User user) {
        List<Device> blockedDevices = this.blockUnblockDevicebyUserName(cloud.getCloudId(), cloud.getCloudName(), user.getUserName(), true);
        if (blockedDevices != null) {
            for (Device device : blockedDevices) {
                this.saveStatisticToDatabase(cloud, "Blocked device", "AUTO", device.getDeviceName(), "AAD Sync", System.currentTimeMillis(), PCActionTypes.ADD_USER_MIGRATION.getActionTypeValue());
            }
        }
    }

    private List<Device> blockUnblockDevicebyUserName(int cloudId, String cloudName, String userName, boolean toBlock) {
        List devices = new ArrayList();
        ArrayList<Device> blockedDevice = new ArrayList<Device>();
        devices = this.deviceDao.getDeviceByUserName(cloudId, userName);
        if (!CollectionUtils.isEmpty(devices)) {
            for (Device device : devices) {
                if (device.isBlocked()) continue;
                this.deviceDao.blockUnblockDevice(cloudId, cloudName, device, toBlock);
                this.deviceDao.updateDeviceStatusInOverview(cloudId, device.getDeviceUUID(), toBlock);
                if (toBlock) {
                    User user = this.userDao.getUserByName(cloudId, device.getUserName());
                    this.authorizationDao.deleteAuthTokenByUserAndUniqueID(cloudId, user, device.getDeviceUUID());
                }
                blockedDevice.add(device);
            }
        }
        return blockedDevice;
    }

    private void saveStatisticToDatabase(Cloud cloud, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloud.getCloudId(), cloud.getCloudName(), audit);
    }

    public void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        audit.setActionType(actionType);
        this.userDao.saveAudit(cloudId, cloudName, audit);
    }

    private void setAuditForAADBlockedOrUnblocked(int cloudId, String cloudName, String userName, boolean isActive, boolean previStatus) {
        if (!isActive && previStatus) {
            this.saveStatisticToDatabase(cloudId, cloudName, "BLOCKED", "AUTO", userName, "AAD", System.currentTimeMillis(), PCActionTypes.AAD_USER_BLOCKED.getActionTypeValue());
        } else if (isActive && !previStatus) {
            this.saveStatisticToDatabase(cloudId, cloudName, "UNBLOCKED", "AUTO", userName, "AAD", System.currentTimeMillis(), PCActionTypes.AAD_USER_UNBLOCKED.getActionTypeValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupFromIDGraph(String accessToken, String groupId, AADAuthorizationToken aadAuthToken) {
        StringBuilder response;
        block25: {
            response = new StringBuilder();
            CloseableHttpClient httpclient = null;
            HttpGet httpGet = null;
            CloseableHttpResponse result = null;
            try {
                Object routePlanner;
                String url = "https://graph.microsoft.com/v1.0/groups/" + groupId;
                Proxy proxy = this.settingsDao.getProxy(1);
                if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                    logger.debug("host :" + PCHelperConstant.getProxyHost());
                    logger.debug("port :" + PCHelperConstant.getProxyPort());
                    HttpHost proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                    routePlanner = new DefaultProxyRoutePlanner(proxyval);
                    httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                } else {
                    httpclient = HttpClients.custom().build();
                }
                httpGet = new HttpGet(url);
                httpGet.addHeader("Authorization", "Bearer " + accessToken);
                httpGet.addHeader("Accept", "application/json");
                result = httpclient.execute((HttpUriRequest)httpGet);
                int httpResponseCode = result.getStatusLine().getStatusCode();
                logger.debug("....getGroupFromIDGraph httpResponseCode code ..." + httpResponseCode);
                if (httpResponseCode == 404) {
                    routePlanner = "";
                    return routePlanner;
                }
                if (httpResponseCode == 401) {
                    logger.debug("...inside update...");
                    aadAuthToken = this.getAccessTokenAndUpdateInDB(aadAuthToken);
                    routePlanner = this.getGroupFromIDGraph(aadAuthToken.getAccess_token(), groupId, aadAuthToken);
                    return routePlanner;
                }
                logger.debug(url + "....getGroupFromIDGraph Status code ..." + httpResponseCode);
                if (httpResponseCode != 200) break block25;
                InputStream inputStream = result.getEntity().getContent();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
            }
        }
        logger.debug("....responsefrom getGroupFromIDGraph..." + response.toString());
        return response.toString();
    }

    private void getUserProductType(AADUserElement user, ObjectMapper mapper, AADCredentials aadCredentials, String accessToken) throws IOException, JsonParseException, JsonMappingException {
        String userGroupInfo;
        boolean bkpEnabled = false;
        boolean syncEnabled = false;
        if (!CollectionUtils.isEmpty((Map)aadCredentials.getGroupConfig()) && !org.springframework.util.StringUtils.isEmpty((Object)(userGroupInfo = this.getUserGroupsFromUserToken(accessToken)))) {
            GraphResponseForMemberOf forMemberOf = (GraphResponseForMemberOf)mapper.readValue(userGroupInfo, GraphResponseForMemberOf.class);
            if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupConfig().keySet().stream().filter(line -> !org.springframework.util.StringUtils.isEmpty((Object)line)).collect(Collectors.toSet()))) {
                List groupInfo = forMemberOf.getGroupInfo();
                List<Object> groupNames = new ArrayList();
                if (org.springframework.util.StringUtils.isEmpty((Object)((GraphGroupInfo)groupInfo.get(0)).getDisplayName())) {
                    HashSet<String> groupNamesSet = new HashSet<String>();
                    for (GraphGroupInfo group2 : groupInfo) {
                        GraphGroupInfo graphGroupInfo;
                        AADAuthorizationToken aadAuthorizationToken = this.getAADAuthorizationToken(1);
                        logger.debug(aadAuthorizationToken.getAccess_token() + "....check group name...." + group2.getId());
                        if (aadAuthorizationToken == null) continue;
                        String groupStr = this.getGroupFromIDGraph(aadAuthorizationToken.getAccess_token(), group2.getId(), aadAuthorizationToken);
                        logger.debug("....empty check group name...." + groupStr);
                        if (org.springframework.util.StringUtils.isEmpty((Object)groupStr) || (graphGroupInfo = (GraphGroupInfo)mapper.readValue(groupStr, GraphGroupInfo.class)) == null || org.springframework.util.StringUtils.isEmpty((Object)graphGroupInfo.getDisplayName())) continue;
                        groupNamesSet.add(graphGroupInfo.getDisplayName().toLowerCase());
                        logger.debug("..EXISTINGGROUPS...." + graphGroupInfo.getDisplayName().toLowerCase());
                    }
                    groupNames.addAll(groupNamesSet);
                } else {
                    groupNames = groupInfo.stream().map(group -> group.getDisplayName().toLowerCase()).collect(Collectors.toList());
                }
                logger.debug("...group name list...." + groupNames.size());
                if (CollectionUtils.isEmpty(groupNames)) {
                    logger.error("....emptygroups...contact parablu....");
                    return;
                }
                for (String groupName : aadCredentials.getGroupConfig().keySet()) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)groupName)) {
                        if ("BACKUP".equals(aadCredentials.getGroupConfig().get(groupName))) {
                            bkpEnabled = true;
                        }
                        if ("SYNC".equals(aadCredentials.getGroupConfig().get(groupName))) {
                            syncEnabled = true;
                            continue;
                        }
                        bkpEnabled = true;
                        syncEnabled = true;
                        continue;
                    }
                    if (CollectionUtils.isEmpty(groupNames) || !groupNames.contains(groupName.toLowerCase())) continue;
                    if ("BACKUP".equals(aadCredentials.getGroupConfig().get(groupName))) {
                        bkpEnabled = true;
                        continue;
                    }
                    if ("SYNC".equals(aadCredentials.getGroupConfig().get(groupName))) {
                        syncEnabled = true;
                        continue;
                    }
                    bkpEnabled = true;
                    syncEnabled = true;
                }
            }
        }
        user.setPassword(accessToken);
        if (!org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get(""))) {
            if (((String)aadCredentials.getGroupConfig().get("")).equals("BACKUP")) {
                bkpEnabled = true;
            } else if (((String)aadCredentials.getGroupConfig().get("")).equals("SYNC")) {
                syncEnabled = true;
            } else {
                bkpEnabled = true;
                syncEnabled = true;
            }
        }
        if (bkpEnabled && syncEnabled) {
            user.setProductType("BOTH");
        } else if (bkpEnabled) {
            user.setProductType("BACKUP");
        } else if (syncEnabled) {
            user.setProductType("SYNC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AADUserElement getAADUserByCode(String code, Cloud cloud, boolean callFromPortal, String redirectUrlFromHeader, String accessToken) {
        AADUserElement aadUserElement;
        block44: {
            aadUserElement = null;
            CloseableHttpResponse response = null;
            HttpPost httppost = null;
            CloseableHttpClient httpclient = null;
            AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloud.getCloudId());
            ArrayList<String> tenants = new ArrayList<String>();
            if (cloud.getMultiTenantAADEnabled() == 1) {
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getTenants())) {
                    tenants.addAll(aadCredentials.getTenants());
                } else {
                    tenants.add(aadCredentials.getTenentId());
                }
            } else {
                tenants.add(aadCredentials.getTenentId());
            }
            if (aadCredentials == null || CollectionUtils.isEmpty(tenants)) {
                logger.debug("AAD credentials is empty....");
                return aadUserElement;
            }
            String grantType = AUTHORIZATION_CODE;
            String applicationID = aadCredentials.getClientId();
            String redirectURI = aadCredentials.getEndpointRedirectURI();
            if (callFromPortal) {
                redirectURI = org.springframework.util.StringUtils.isEmpty((Object)redirectUrlFromHeader) ? aadCredentials.getPortalRedirectURI() : redirectUrlFromHeader;
            }
            try {
                if (StringUtils.isNotEmpty((String)accessToken)) {
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                    aadUserElement = this.getAADUserElementByAccessToken(aadCredentials, accessToken, mapper, cloud, (String)tenants.get(0));
                    break block44;
                }
                for (String tenantId : tenants) {
                    Throwable throwable;
                    InputStream instream;
                    String loginUrl = LOGIN_URL + tenantId + OAUTH2_TOKEN_URL;
                    if (!org.springframework.util.StringUtils.isEmpty((Object)aadCredentials.getLoginMode()) && aadCredentials.getLoginMode().equalsIgnoreCase("Okta")) {
                        loginUrl = HTTPS + tenantId + OKTA_LOGIN_URL + TOKEN;
                    }
                    logger.debug("Login url:" + loginUrl + "\nredirect uri:" + redirectURI);
                    Proxy proxy = this.settingsDao.getProxy(1);
                    if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                        logger.debug("host :" + PCHelperConstant.getProxyHost());
                        logger.debug("port :" + PCHelperConstant.getProxyPort());
                        HttpHost proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                        httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                    } else {
                        httpclient = HttpClients.custom().build();
                    }
                    httppost = new HttpPost(loginUrl);
                    logger.debug("...loginUrl..." + loginUrl);
                    ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                    params.add(new BasicNameValuePair("grant_type", grantType));
                    params.add(new BasicNameValuePair("client_id", applicationID));
                    params.add(new BasicNameValuePair("code", code));
                    params.add(new BasicNameValuePair("redirect_uri", redirectURI));
                    params.add(new BasicNameValuePair("client_secret", aadCredentials.getSecretKey()));
                    httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, UTF_8));
                    httppost.setHeader(CONTENT_TYPE, "application/x-www-form-urlencoded");
                    response = httpclient.execute((HttpUriRequest)httppost);
                    HttpEntity entity = response.getEntity();
                    logger.debug("Status code " + response.getStatusLine().getStatusCode());
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 200) {
                        if (entity != null) {
                            instream = entity.getContent();
                            throwable = null;
                            try {
                                JSONObject json = new JSONObject(IOUtils.toString((InputStream)instream, (String)UTF_8));
                                accessToken = json.getString("access_token");
                                ObjectMapper mapper = new ObjectMapper();
                                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                                logger.debug("accessToken......." + accessToken);
                                aadUserElement = this.getAADUserElementByAccessToken(aadCredentials, accessToken, mapper, cloud, tenantId);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (instream != null) {
                                    if (throwable != null) {
                                        try {
                                            instream.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        instream.close();
                                    }
                                }
                            }
                        }
                    } else {
                        instream = entity.getContent();
                        throwable = null;
                        try {
                            logger.debug(IOUtils.toString((InputStream)instream, (String)UTF_8));
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (instream != null) {
                                if (throwable != null) {
                                    try {
                                        instream.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    instream.close();
                                }
                            }
                        }
                    }
                    if (statusCode != 200) continue;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(EXCEPTION + e);
                logger.debug(EXCEPTION + e.getMessage());
            }
            finally {
                if (httppost != null) {
                    httppost.releaseConnection();
                }
                this.closeResponseEntity((HttpResponse)response);
                this.closeHttpClient(httpclient);
            }
        }
        return aadUserElement;
    }

    public void closeResponseEntity(HttpResponse response) {
        block6: {
            try {
                logger.debug("inside closing response entity.....");
                if (response == null || response.getEntity() == null || !response.getEntity().isStreaming()) break block6;
                try {
                    if (response.getEntity().getContent() != null) {
                        response.getEntity().getContent().close();
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                    logger.trace("" + e);
                }
                catch (Exception e) {
                    logger.error("Exception in closing response entity");
                    logger.trace("" + e);
                }
            }
            catch (Exception e) {
                logger.error("Exception in closing response entity outside");
                logger.trace("" + e);
            }
        }
    }

    private AADUserElement getAADUserElementByAccessToken(AADCredentials aadCredentials, String accessToken, ObjectMapper mapper, Cloud cloud, String tenantId) throws IOException, JsonParseException, JsonMappingException {
        AADUserElement aadUserElement;
        if (!org.springframework.util.StringUtils.isEmpty((Object)aadCredentials.getLoginMode()) && aadCredentials.getLoginMode().equalsIgnoreCase("Okta")) {
            String userString = this.getUserInfoFromOkta(accessToken, aadCredentials);
            logger.debug(".......userString from okta..." + userString);
            OktaUserElement oktaUserElement = new OktaUserElement();
            oktaUserElement = (OktaUserElement)mapper.readValue(userString, OktaUserElement.class);
            aadUserElement = new AADUserElement();
            BeanUtils.copyProperties((Object)oktaUserElement, (Object)aadUserElement);
            aadUserElement.setProductType("BOTH");
            aadUserElement.setPassword(accessToken);
            logger.debug(".......user mail id from okta..." + aadUserElement.getMail());
        } else {
            String userString = this.getUserInfoFromGraph(accessToken);
            aadUserElement = (AADUserElement)mapper.readValue(userString, AADUserElement.class);
            if (aadUserElement != null) {
                if (cloud.getGraphAADEnabled() == 0) {
                    this.getUserProductType(aadUserElement, mapper, aadCredentials, accessToken);
                } else {
                    this.getNewAADUserProductType(cloud.getCloudId(), aadUserElement, aadCredentials);
                }
                aadUserElement.setPassword(accessToken);
            } else {
                logger.debug("AAD element is empty");
            }
        }
        return aadUserElement;
    }

    public AADUserElement getNewAADUserProductType(int cloudId, AADUserElement aadUser, AADCredentials aadCredentials) {
        logger.debug("...........User " + aadUser.getUserName() + " .........found in AAD");
        String productType = "";
        logger.debug(aadUser.getUserPrincipalName() + ".................." + aadCredentials.toString());
        if (!CollectionUtils.isEmpty((Map)aadCredentials.getGroupConfig())) {
            boolean bkpEnabled = false;
            boolean syncEnabled = false;
            boolean o365Enabled = false;
            if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupConfig().keySet().stream().filter(line -> !org.springframework.util.StringUtils.isEmpty((Object)line)).collect(Collectors.toSet()))) {
                List<String> userMemberOf = this.getNewAADUserMemberInfo(aadUser.getId(), aadCredentials);
                if (!CollectionUtils.isEmpty(userMemberOf)) {
                    for (String group : userMemberOf) {
                        logger.debug("User is memeber of ............" + group.toLowerCase());
                        if (org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get(group.toLowerCase()))) continue;
                        if (((String)aadCredentials.getGroupConfig().get(group)).equals("BACKUP")) {
                            bkpEnabled = true;
                            continue;
                        }
                        if (((String)aadCredentials.getGroupConfig().get(group)).equals("SYNC")) {
                            syncEnabled = true;
                            continue;
                        }
                        if (((String)aadCredentials.getGroupConfig().get(group)).equals("O365")) {
                            o365Enabled = true;
                            continue;
                        }
                        bkpEnabled = true;
                        syncEnabled = true;
                    }
                }
            } else {
                productType = (String)aadCredentials.getGroupConfig().values().iterator().next();
            }
            logger.debug("............................" + (String)aadCredentials.getGroupConfig().get("") + "........" + !org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get("")));
            if (!org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get(""))) {
                if (((String)aadCredentials.getGroupConfig().get("")).equals("BACKUP")) {
                    bkpEnabled = true;
                } else if (((String)aadCredentials.getGroupConfig().get("")).equals("SYNC")) {
                    syncEnabled = true;
                } else if (((String)aadCredentials.getGroupConfig().get("")).equals("O365")) {
                    o365Enabled = true;
                } else {
                    bkpEnabled = true;
                    syncEnabled = true;
                }
            }
            if (bkpEnabled && syncEnabled && o365Enabled) {
                productType = "BOTH";
            } else if (bkpEnabled) {
                productType = "BACKUP";
            } else if (syncEnabled) {
                productType = "SYNC";
            } else if (o365Enabled) {
                productType = "O365";
            }
            aadUser.setProductType(productType);
            if (org.springframework.util.StringUtils.isEmpty((Object)productType)) {
                logger.debug("..user not part of any product...." + aadUser.getUserName());
                return null;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)productType)) {
                return aadUser;
            }
        }
        if (aadUser != null) {
            logger.debug(aadUser.getProductType() + "...prod ..AAD User Element ...." + aadUser.toString());
        }
        return aadUser;
    }

    private List<String> getNewAADUserMemberInfo(String userName, AADCredentials aadCredentials) {
        ArrayList<String> tenants = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)aadCredentials.getTenants())) {
            tenants.addAll(aadCredentials.getTenants());
        } else {
            tenants.add(aadCredentials.getTenentId());
        }
        String clientId = aadCredentials.getClientId();
        String secret = aadCredentials.getSecretKey();
        ArrayList<String> userMemeberOf = new ArrayList<String>();
        for (String tenantId : tenants) {
            Set groupsInDB = aadCredentials.getGroupConfig().keySet().stream().filter(group -> !org.springframework.util.StringUtils.isEmpty((Object)group)).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(groupsInDB)) {
                logger.debug("Group name is empty so retun..");
                return new ArrayList<String>();
            }
            groupsInDB = groupsInDB.stream().map(String::toLowerCase).collect(Collectors.toSet());
            for (String groupName : groupsInDB) {
                logger.debug("..group nnmae.. " + groupName);
                String groupId = this.getNewGroupId(1, groupName, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantId);
                logger.debug("..group nnmae1.. " + groupName + "..groupId.." + groupId);
                List<String> groupMembersInfo = this.getNewGroupMembersInfo(groupId, clientId, secret, tenantId);
                if (CollectionUtils.isEmpty(groupMembersInfo) || !groupMembersInfo.contains(userName)) continue;
                userMemeberOf.add(groupName);
            }
        }
        logger.debug(userName + "...user-groups...." + userMemeberOf.size());
        return userMemeberOf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserInfoFromOkta(String accessToken, AADCredentials aadCredentials) {
        CloseableHttpResponse result;
        CloseableHttpClient httpclient;
        StringBuilder response;
        block22: {
            response = new StringBuilder();
            httpclient = null;
            HttpGet httpGet = null;
            result = null;
            try {
                String url = HTTPS + aadCredentials.getTenentId() + OKTA_LOGIN_URL + "/userinfo";
                Proxy proxy = this.settingsDao.getProxy(1);
                if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                    logger.debug("host :" + PCHelperConstant.getProxyHost());
                    logger.debug("port :" + PCHelperConstant.getProxyPort());
                    HttpHost proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                    httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                } else {
                    httpclient = HttpClients.custom().build();
                }
                httpGet = new HttpGet(url);
                httpGet.addHeader("Authorization", "Bearer " + accessToken);
                httpGet.addHeader("Accept", "application/json");
                result = httpclient.execute((HttpUriRequest)httpGet);
                int httpResponseCode = result.getStatusLine().getStatusCode();
                logger.debug("Status code ..." + httpResponseCode);
                if (httpResponseCode == 200) {
                    InputStream inputStream = result.getEntity().getContent();
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                        String inputLine;
                        while ((inputLine = in.readLine()) != null) {
                            response.append(inputLine);
                        }
                    }
                }
                if (httpGet == null) break block22;
            }
            catch (Exception e) {
                block23: {
                    try {
                        logger.error(EXCEPTION + e);
                        logger.debug(EXCEPTION + e.getMessage());
                        if (httpGet == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (httpGet != null) {
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                        throw throwable;
                    }
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
            }
            httpGet.releaseConnection();
        }
        this.closeResponse(result);
        this.closeHttpClient(httpclient);
        return response.toString();
    }

    private java.net.Proxy getProxy(int cloudId) {
        int port;
        String host;
        Proxy proxy = this.settingsDao.getProxy(cloudId);
        if (proxy != null) {
            String userNameVal = proxy.getUserName();
            String passwordVal = proxy.getPassword();
            host = proxy.getHost();
            port = Integer.parseInt(proxy.getPort());
        } else {
            String userNameVal = PCHelperConstant.getProxyUserName();
            String passwordVal = PCHelperConstant.getProxyPassword();
            host = PCHelperConstant.getProxyHost();
            port = PCHelperConstant.getProxyPort();
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)host) || port <= 0) {
            return null;
        }
        return new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
    }

    public SettingsDao getSettingsDao() {
        return this.settingsDao;
    }

    public void setSettingsDao(SettingsDao settingsDao) {
        this.settingsDao = settingsDao;
    }

    private String getGoogleSecurityKey() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        Base32 base32 = new Base32();
        String googleSecretKey = base32.encodeToString(bytes);
        return googleSecretKey;
    }

    private String getUserInfoUrl(String userName) {
        if (userName.contains("#")) {
            userName = userName.replace("#", "%23");
        }
        String url = userName.startsWith("$") ? "https://graph.microsoft.com/beta//users('" + userName + "')" : "https://graph.microsoft.com/beta//users/" + userName;
        return url;
    }

    @Override
    public List<AADCredentialsElement> getAllAADCredentials(int cloudId) {
        ArrayList<AADCredentialsElement> aadCredentialsElementList = new ArrayList<AADCredentialsElement>();
        List aadCredentialsList = this.aadDao.getAllAADCredentials(cloudId);
        for (AADCredentials aadCredentials : aadCredentialsList) {
            if (aadCredentials == null) continue;
            AADCredentialsElement aadCredentialsElement = new AADCredentialsElement();
            BeanUtils.copyProperties((Object)aadCredentials, (Object)aadCredentialsElement);
            aadCredentialsElement.setId(aadCredentials.getId().toString());
            AADAuthorizationToken token = this.aadDao.getAADAuthorizationtoken(cloudId);
            if (token == null) {
                aadCredentialsElement.setAuthRequired(true);
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)token.getUser_principal())) {
                aadCredentialsElement.setUser_principal(token.getUser_principal());
            }
            aadCredentialsElementList.add(aadCredentialsElement);
        }
        return aadCredentialsElementList;
    }

    @Override
    public AADCredentialsElement getAADCredentials(int cloudId, String aadCredId) {
        AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloudId, aadCredId);
        AADCredentialsElement aadCredentialsElement = null;
        if (aadCredentials != null) {
            aadCredentialsElement = new AADCredentialsElement();
            BeanUtils.copyProperties((Object)aadCredentials, (Object)aadCredentialsElement);
            aadCredentialsElement.setId(aadCredentials.getId().toString());
            AADAuthorizationToken token = this.aadDao.getAADAuthorizationtoken(cloudId);
            if (token == null) {
                aadCredentialsElement.setAuthRequired(true);
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)token.getUser_principal())) {
                aadCredentialsElement.setUser_principal(token.getUser_principal());
            }
        }
        return aadCredentialsElement;
    }

    @Override
    public void deleteAADCredentials(int cloudId, String aadCredId) {
        this.aadDao.deleteAADCredentials(cloudId, aadCredId);
    }

    @Override
    public void syncNewUserAttributes(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloudId);
        ArrayList<String> tenants = new ArrayList<String>();
        logger.debug("..before getting tenants...");
        if (aadCredentials != null) {
            if (cloud.getMultiTenantAADEnabled() == 1) {
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getTenants())) {
                    tenants.addAll(aadCredentials.getTenants());
                } else {
                    tenants.add(aadCredentials.getTenentId());
                }
            } else {
                tenants.add(aadCredentials.getTenentId());
            }
        }
        logger.debug("..after getting tenants..." + tenants.size());
        if (aadCredentials != null) {
            ArrayList<AADUserElement> aadUserElements = new ArrayList<AADUserElement>();
            for (String tenantId : tenants) {
                logger.debug("..processing tenantId..." + tenantId);
                List<AADUserElement> aadUserElementsList = this.syncAADNewGroupChanges(cloud, aadCredentials, tenantId);
                aadUserElements.addAll(aadUserElementsList);
            }
            if (CollectionUtils.isEmpty(aadUserElements)) {
                logger.debug("....no users to sync check the group....");
                return;
            }
            Set groupsInDB = aadCredentials.getGroupConfig().keySet().stream().filter(group -> !org.springframework.util.StringUtils.isEmpty((Object)group)).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(groupsInDB)) {
                logger.debug("Group name is empty after collection so retun..");
                return;
            }
            ArrayList<AADUserElement> result = new ArrayList<AADUserElement>();
            HashSet<String> titles = new HashSet<String>();
            for (AADUserElement item : aadUserElements) {
                if (!titles.add(item.getUserPrincipalName())) continue;
                result.add(item);
            }
            logger.debug(aadUserElements.size() + "...overall list before and after.." + result.size());
            aadUserElements = result;
            Map<String, AADUserElement> aadMap = aadUserElements.stream().collect(Collectors.toMap(aaduser -> aaduser.getUserPrincipalName().toLowerCase(), aaduser -> aaduser));
            List allUsers = this.userDao.getAllUsers(cloudId);
            HashMap<String, User> userMap = new HashMap<String, User>();
            for (User user : allUsers) {
                if (user.isLocalUser()) continue;
                String userName = user.getUserName();
                if (!org.springframework.util.StringUtils.isEmpty((Object)user.getAadLoginId())) {
                    userName = user.getAadLoginId();
                }
                userMap.put(userName.toLowerCase(), user);
            }
            for (User user : allUsers) {
                logger.debug("guest user..." + user.getUserName());
                if (!user.isGuest()) continue;
                logger.debug("guest user.mail.." + user.getEmailId());
                if (!aadMap.containsKey(user.getUserName().toLowerCase()) && !aadMap.containsKey(user.getEmailId())) continue;
                this.userDao.removeUserbyID(cloudId, user.getUserId().toString());
                userMap.remove(user.getUserName());
                userMap.remove(user.getEmailId());
                allUsers.remove(user);
                logger.debug("removeUserbyID..........");
            }
            logger.debug(aadMap.size() + ".....map diff ..." + userMap.size());
            for (Map.Entry entry : userMap.entrySet()) {
                User existingUser = (User)entry.getValue();
                if (aadMap.containsKey(entry.getKey())) {
                    AADUserElement aadUserElement = aadMap.get(entry.getKey());
                    logger.debug("...already in user iteration...");
                    boolean anyChange = false;
                    if (!anyChange && aadUserElement.isBackupEnabled() != existingUser.isBackupEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isSyncEnabled() != existingUser.isSyncEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isO365Enabled() != existingUser.isOnedriveBkpEnabled()) {
                        anyChange = true;
                    }
                    if (existingUser.isSoftBlockEnabled()) {
                        anyChange = true;
                    }
                    if (anyChange) {
                        long totalExchangekpUsers;
                        long totalOdbBkpUsers;
                        int noOfExchangeUsersAllowed;
                        int noOfOneDriveUsersAllowed;
                        long totalBkpUsers;
                        int noOfBkpUsersAllowed;
                        long totalSyncUsers;
                        int noOfSyncUsersAllowed;
                        if (aadUserElement.isBackupEnabled() && (long)(noOfSyncUsersAllowed = cloud.getNoOfSyncUsersAllowed()) <= (totalSyncUsers = this.userDao.countOfPresentSyncUsers(cloud.getCloudId(), cloud.getCloudName(), true))) {
                            logger.debug(" SYNC USER LIMIT REACHED........");
                            aadUserElement.setSyncEnabled(false);
                        }
                        if (aadUserElement.isBackupEnabled() && (long)(noOfBkpUsersAllowed = cloud.getNoOfBackupUsersAllowed()) <= (totalBkpUsers = this.userDao.countOfPresentBackupUsers(cloud.getCloudId(), cloud.getCloudName(), true, true))) {
                            logger.debug(" BACKUP USER LIMIT REACHED........");
                            aadUserElement.setBackupEnabled(false);
                        }
                        if (aadUserElement.isO365Enabled() && (long)((noOfOneDriveUsersAllowed = cloud.getNoOfOneDriveUsersAllowed()) + (noOfExchangeUsersAllowed = cloud.getNoOfExchangeUsersAllowed())) <= (totalOdbBkpUsers = this.userDao.countOfPresentOnedriveUsers(cloud.getCloudId(), true)) + (totalExchangekpUsers = this.userDao.countOfPresentExchangeUsers(cloud.getCloudId(), true))) {
                            logger.debug("Office USER LIMIT REACHED........");
                            aadUserElement.setO365Enabled(false);
                        }
                        if (!(aadUserElement.isBackupEnabled() || aadUserElement.isSyncEnabled() || aadUserElement.isO365Enabled() || existingUser.isSoftBlockEnabled())) {
                            logger.error(existingUser.getUserName() + "...user limit reached ...." + existingUser.isSoftBlockEnabled());
                            continue;
                        }
                        boolean previStatus = existingUser.isActive();
                        existingUser.setBackupEnabled(aadUserElement.isBackupEnabled());
                        existingUser.setSyncEnabled(aadUserElement.isSyncEnabled());
                        existingUser.setOnedriveBkpEnabled(aadUserElement.isO365Enabled());
                        existingUser.setExchangeBkpEnabled(aadUserElement.isO365Enabled());
                        existingUser.setLocation(aadUserElement.getOfficeLocation());
                        existingUser.setDepartment(aadUserElement.getDepartment());
                        existingUser.setSoftBlockEnabled(false);
                        existingUser.setActive(true);
                        this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                        this.deviceDao.updateUserStatusInDeviceBkpOverview(cloudId, existingUser);
                        this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                        continue;
                    }
                    existingUser = this.userDao.getUserByUserNameOrAADLoginId(cloudId, (String)entry.getKey());
                    if (existingUser == null) continue;
                    logger.debug("..updating user location and department...");
                    existingUser.setLocation(aadUserElement.getOfficeLocation());
                    existingUser.setDepartment(aadUserElement.getDepartment());
                    this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                    continue;
                }
                logger.debug("...inside blocking existing user" + (String)entry.getKey());
                if (cloudProperties != null && cloudProperties.isSoftBlockEnabled()) {
                    existingUser.setSoftBlockEnabled(true);
                    this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                    continue;
                }
                boolean previStatus = existingUser.isActive();
                existingUser.setBackupEnabled(false);
                existingUser.setSyncEnabled(false);
                existingUser.setOnedriveBkpEnabled(false);
                existingUser.setActive(false);
                this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                this.deviceDao.updateUserInfoInDeviceBkpOverview(cloud.getCloudId(), existingUser);
                this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                this.changeDeviceStatusAndAduit(cloud, existingUser);
            }
            for (Map.Entry entry : aadMap.entrySet()) {
                if (userMap.containsKey(entry.getKey())) continue;
                logger.debug("...adding new user to user collection..." + (String)entry.getKey());
                AADUserElement aadUserElement = aadMap.get(entry.getKey());
                this.updateOrCreateAADUserInfo(cloud, aadUserElement);
            }
        } else {
            logger.debug("Either aadCredentials or authToken or accessToken is Empty so no Sync");
        }
    }

    private List<AADUserElement> syncAADNewGroupChanges(Cloud cloud, AADCredentials aadCredentials, String tenantId) {
        ArrayList<Object> aadUserElements = new ArrayList<AADUserElement>();
        try {
            Set groupsInDB = aadCredentials.getGroupConfig().keySet().stream().filter(group -> !org.springframework.util.StringUtils.isEmpty((Object)group)).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(groupsInDB)) {
                logger.debug("Group name is empty so retun..");
                return aadUserElements;
            }
            groupsInDB = groupsInDB.stream().map(String::toLowerCase).collect(Collectors.toSet());
            ArrayList<String> userGroupMembers = new ArrayList<String>();
            for (String groupName : groupsInDB) {
                logger.debug("..group nnmae.. " + groupName);
                String groupId = this.getNewGroupId(cloud.getCloudId(), groupName, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantId);
                logger.debug("..group nnmae1.. " + groupName + "..groupId.." + groupId);
                List<String> groupMembersInfo = this.getNewGroupMembersInfo(groupId, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantId);
                userGroupMembers.addAll(groupMembersInfo);
            }
            logger.debug("...usermemberslist..." + userGroupMembers.size());
            for (String memberId : userGroupMembers) {
                logger.debug("Inside.....member..." + memberId);
                AADUserElement aadUser = this.getNewAADUserFromUserNameToSync(cloud.getCloudId(), memberId, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantId);
                if (aadUser == null) continue;
                boolean isSyncEnabled = false;
                boolean isBackupEnabled = false;
                boolean isO365Enabled = false;
                List list = cloud.getCloudCustomisableDetails();
                for (CloudCustomisableDetails customisableDetails : list) {
                    if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                        isSyncEnabled = true;
                    }
                    if (customisableDetails.getName().equalsIgnoreCase(BACK_UP_ENABLED)) {
                        isBackupEnabled = true;
                    }
                    if (!"OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
                    isO365Enabled = true;
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)aadUser.getProductType())) {
                    logger.debug("User not part of any product" + aadUser.getUserName());
                    continue;
                }
                if ("SYNC".equalsIgnoreCase(aadUser.getProductType())) {
                    isBackupEnabled = false;
                    isO365Enabled = false;
                }
                if ("BACKUP".equalsIgnoreCase(aadUser.getProductType())) {
                    isSyncEnabled = false;
                    isO365Enabled = false;
                }
                if ("O365".equalsIgnoreCase(aadUser.getProductType())) {
                    isSyncEnabled = false;
                    isBackupEnabled = false;
                }
                aadUser.setBackupEnabled(isBackupEnabled);
                aadUser.setSyncEnabled(isSyncEnabled);
                aadUser.setO365Enabled(isO365Enabled);
                aadUserElements.add(aadUser);
            }
        }
        catch (Exception e) {
            logger.error(" Exception  :..........." + e);
            logger.debug(" Exception  :..........." + e.getMessage());
            aadUserElements = new ArrayList();
        }
        return aadUserElements;
    }

    public AADUserElement getNewAADUserFromUserNameToSync(int cloudId, String userName, String clientId, String secret, String tenantId) {
        AADUserElement aadUser = null;
        aadUser = this.getNewAADUserFromUserName(userName, clientId, secret, tenantId);
        if (aadUser != null) {
            logger.debug(aadUser.getId() + "...........User . .........found in AAD.." + aadUser.getUserPrincipalName() + "....user..." + userName);
            String productType = "";
            AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloudId);
            logger.debug(".................." + aadCredentials.toString());
            if (!CollectionUtils.isEmpty((Map)aadCredentials.getGroupConfig())) {
                boolean bkpEnabled = false;
                boolean syncEnabled = false;
                boolean o365Enabled = false;
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupConfig().keySet().stream().map(line -> line).filter(line -> !org.springframework.util.StringUtils.isEmpty((Object)line)).collect(Collectors.toSet()))) {
                    List<String> userMemberOf = this.getNewAADUserGroupInfo(userName, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantId);
                    if (!CollectionUtils.isEmpty(userMemberOf)) {
                        for (String group : userMemberOf) {
                            if (org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get(group))) continue;
                            if (((String)aadCredentials.getGroupConfig().get(group)).equals("BACKUP")) {
                                bkpEnabled = true;
                                continue;
                            }
                            if (((String)aadCredentials.getGroupConfig().get(group)).equals("SYNC")) {
                                syncEnabled = true;
                                continue;
                            }
                            if (((String)aadCredentials.getGroupConfig().get(group)).equals("O365")) {
                                o365Enabled = true;
                                continue;
                            }
                            bkpEnabled = true;
                            syncEnabled = true;
                            o365Enabled = true;
                        }
                    }
                } else {
                    productType = (String)aadCredentials.getGroupConfig().values().iterator().next();
                }
                logger.debug(bkpEnabled + ".." + syncEnabled + "..." + o365Enabled + ".......checkmemberof...................." + (String)aadCredentials.getGroupConfig().get("") + "........" + userName);
                if (!org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get(""))) {
                    if (((String)aadCredentials.getGroupConfig().get("")).equals("BACKUP")) {
                        bkpEnabled = true;
                    } else if (((String)aadCredentials.getGroupConfig().get("")).equals("SYNC")) {
                        syncEnabled = true;
                    } else if (((String)aadCredentials.getGroupConfig().get("")).equals("O365")) {
                        o365Enabled = true;
                    } else {
                        bkpEnabled = true;
                        syncEnabled = true;
                        o365Enabled = true;
                    }
                }
                if (bkpEnabled && syncEnabled) {
                    productType = "BOTH";
                    aadUser.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
                    aadUser.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
                    aadUser.setDefaultOdbPolicy(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
                } else if (bkpEnabled) {
                    productType = "BACKUP";
                    aadUser.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
                } else if (syncEnabled) {
                    productType = "SYNC";
                    aadUser.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
                } else if (o365Enabled) {
                    productType = "O365";
                    aadUser.setDefaultOdbPolicy(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
                }
            }
            aadUser.setProductType(productType);
        } else {
            logger.debug("...........User " + userName + " .........  Not found in AAD");
        }
        return aadUser;
    }

    public AADUserElement getNewAADUserFromUserName(int cloudId, String userName, String clientId, String secret, String tenantId) {
        AADUserElement aadUser = null;
        User user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        if (user == null || user != null && user.isGuest()) {
            aadUser = this.getNewAADUserFromUserName(userName, clientId, secret, tenantId);
            if (aadUser != null) {
                logger.debug("...........User " + aadUser.getUserName() + " .........found in AAD");
                String productType = "";
                AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloudId);
                logger.debug(".................." + aadCredentials.toString());
                if (!CollectionUtils.isEmpty((Map)aadCredentials.getGroupConfig())) {
                    boolean bkpEnabled = false;
                    boolean syncEnabled = false;
                    boolean o365Enabled = false;
                    if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupConfig().keySet().stream().filter(line -> !org.springframework.util.StringUtils.isEmpty((Object)line)).collect(Collectors.toSet()))) {
                        List<String> userMemberOf = this.getNewAADUserGroupInfo(userName, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantId);
                        if (!CollectionUtils.isEmpty(userMemberOf)) {
                            for (String group : userMemberOf) {
                                logger.debug("User is memeber of ............" + group.toLowerCase());
                                if (org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get(group.toLowerCase()))) continue;
                                if (((String)aadCredentials.getGroupConfig().get(group)).equals("BACKUP")) {
                                    bkpEnabled = true;
                                    continue;
                                }
                                if (((String)aadCredentials.getGroupConfig().get(group)).equals("SYNC")) {
                                    syncEnabled = true;
                                    continue;
                                }
                                if (((String)aadCredentials.getGroupConfig().get(group)).equals("O365")) {
                                    o365Enabled = true;
                                    continue;
                                }
                                bkpEnabled = true;
                                syncEnabled = true;
                            }
                        }
                    } else {
                        productType = (String)aadCredentials.getGroupConfig().values().iterator().next();
                    }
                    logger.debug("............................" + (String)aadCredentials.getGroupConfig().get("") + "........" + !org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get("")));
                    if (!org.springframework.util.StringUtils.isEmpty(aadCredentials.getGroupConfig().get(""))) {
                        if (((String)aadCredentials.getGroupConfig().get("")).equals("BACKUP")) {
                            bkpEnabled = true;
                        } else if (((String)aadCredentials.getGroupConfig().get("")).equals("SYNC")) {
                            syncEnabled = true;
                        } else if (((String)aadCredentials.getGroupConfig().get("")).equals("O365")) {
                            o365Enabled = true;
                        } else {
                            bkpEnabled = true;
                            syncEnabled = true;
                        }
                    }
                    if (bkpEnabled && syncEnabled && o365Enabled) {
                        productType = "BOTH";
                    } else if (bkpEnabled) {
                        productType = "BACKUP";
                    } else if (syncEnabled) {
                        productType = "SYNC";
                    } else if (o365Enabled) {
                        productType = "O365";
                    }
                }
                aadUser.setProductType(productType);
            } else {
                logger.debug("...........User " + userName + " .........  Not found in AAD");
            }
        } else {
            logger.debug("$##############################" + userName + " ........present in our db....");
        }
        if (aadUser != null) {
            logger.debug("AAD User Element ...." + aadUser.toString());
        }
        return aadUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AADUserElement getNewAADUserFromUserName(String userName, String clientId, String secret, String tenantId) {
        StringBuilder responseStr = new StringBuilder();
        CloseableHttpClient httpclient = null;
        Object httpGet = null;
        CloseableHttpResponse result = null;
        AADUserElement aadUser = null;
        boolean retry = false;
        int retryCount = 0;
        OkHttpClient okHttpClient = AADManagementServiceImpl.getOkHttpClient(clientId, secret, tenantId);
        ObjectMapper mapper = new ObjectMapper();
        do {
            try {
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                String url = this.getUserInfoUrl(userName);
                logger.debug(tenantId + "url to get the user from aad latest :" + url);
                HttpUrl.Builder httpBuilder = HttpUrl.parse((String)url).newBuilder();
                Request request = new Request.Builder().url(httpBuilder.build()).build();
                Response response = okHttpClient.newCall(request).execute();
                int httpResponseCode = response.code();
                logger.debug(tenantId + "...getNewAADUserFromUserName ........response code ......... " + httpResponseCode);
                if (httpResponseCode == 200) {
                    InputStream inputStream = response.body().byteStream();
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                        String inputLine;
                        while ((inputLine = in.readLine()) != null) {
                            responseStr.append(inputLine);
                        }
                    }
                    aadUser = (AADUserElement)mapper.readValue(responseStr.toString(), AADUserElement.class);
                    break;
                }
                logger.debug("..........user not fount.........");
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.trace("" + e);
                logger.error(" ERROR trying to get AADUser From UserName " + e.getMessage());
                retry = true;
            }
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
            }
        } while (retry && ++retryCount < 2);
        return aadUser;
    }

    public static OkHttpClient getOkHttpClient(String clientId, String secret, String tenantId) {
        String authorityHost = "https://login.microsoftonline.com";
        OkHttpClient httpClient = null;
        if (!org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            Authenticator proxyAuthenticator = new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)PCHelperConstant.getProxyUserName(), (String)PCHelperConstant.getProxyPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            };
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()));
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).clientSecret(secret).tenantId(tenantId)).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            httpClient = com.microsoft.graph.httpcore.HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()))).proxyAuthenticator(proxyAuthenticator).build();
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).clientSecret(secret).tenantId(tenantId)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            httpClient = com.microsoft.graph.httpcore.HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().build();
        }
        return httpClient;
    }

    public GraphServiceClient<Request> getGraphClient(String clientId, String secret, String tenantId) {
        String authorityHost = "https://login.microsoftonline.com";
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).clientSecret(secret).tenantId(tenantId)).authorityHost(authorityHost)).build();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("https://graph.microsoft.com/.default");
        TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
        GraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).buildClient();
        return graphClient;
    }

    @Override
    public String getTenantIdForGraphAADUsersFromUserNames(Cloud cloud, String userName) {
        String tenantId = "";
        AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloud.getCloudId());
        ArrayList<String> tenants = new ArrayList<String>();
        if (cloud.getMultiTenantAADEnabled() == 1) {
            if (!CollectionUtils.isEmpty((Collection)aadCredentials.getTenants())) {
                tenants.addAll(aadCredentials.getTenants());
            } else {
                tenants.add(aadCredentials.getTenentId());
            }
        } else {
            tenants.add(aadCredentials.getTenentId());
        }
        for (String tenantIdval : tenants) {
            logger.debug(userName + "...checking in tenant..." + tenantId);
            AADUserElement aadUser = this.getNewAADUserFromUserName(cloud.getCloudId(), userName, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantIdval);
            if (aadUser == null) continue;
            tenantId = tenantIdval;
            break;
        }
        logger.debug("...user exists in ..." + tenantId);
        return tenantId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getNewAADUserGroupInfo(String userName, String clientId, String secret, String tenantId) {
        StringBuilder responseStr = new StringBuilder();
        ArrayList<String> userMemeberOf = new ArrayList<String>();
        HashSet userMemeberOfSet = new HashSet();
        boolean retry = false;
        int retryCount = 0;
        CloseableHttpClient httpclient = null;
        Object httpGet = null;
        CloseableHttpResponse result = null;
        ObjectMapper mapper = new ObjectMapper();
        String url = "https://graph.microsoft.com/v1.0//users/" + userName + GRAPH_USER_MEMBER_OF;
        boolean isSkipTokenAvailable = false;
        OkHttpClient okHttpClient = AADManagementServiceImpl.getOkHttpClient(clientId, secret, tenantId);
        do {
            try {
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                logger.debug(".....url...." + url);
                HttpUrl.Builder httpBuilder = HttpUrl.parse((String)url).newBuilder();
                Request request = new Request.Builder().url(httpBuilder.build()).build();
                Response response = okHttpClient.newCall(request).execute();
                int httpResponseCode = response.code();
                logger.debug(userName + "..........getAADUserFromUserName ........response code ......... " + httpResponseCode);
                if (httpResponseCode != 200) continue;
                InputStream inputStream = response.body().byteStream();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        responseStr.append(inputLine);
                    }
                }
                GraphResponseForMemberOf forMemberOf = (GraphResponseForMemberOf)mapper.readValue(responseStr.toString(), GraphResponseForMemberOf.class);
                if (forMemberOf != null && !CollectionUtils.isEmpty((Collection)forMemberOf.getGroupInfo())) {
                    List groupInfo = forMemberOf.getGroupInfo();
                    List userMemberList = groupInfo.stream().map(group -> group.getDisplayName().toLowerCase()).collect(Collectors.toList());
                    userMemeberOf.addAll(userMemberList);
                    userMemeberOfSet.addAll(userMemberList);
                }
                responseStr = new StringBuilder();
                if (!org.springframework.util.StringUtils.isEmpty((Object)forMemberOf.getNextLink())) {
                    logger.debug(url + ".... link available....." + forMemberOf.getNextLink());
                    if (url.equalsIgnoreCase(forMemberOf.getNextLink())) {
                        logger.debug(url + ".... link available.but same...." + userMemeberOfSet);
                        isSkipTokenAvailable = false;
                        break;
                    }
                    url = forMemberOf.getNextLink();
                    isSkipTokenAvailable = true;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)forMemberOf.getNextLink())) continue;
                logger.debug("....no link available.....");
                isSkipTokenAvailable = false;
                break;
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(" ERROR trying to get getAADUserGroupInfo " + e.getMessage());
                retry = true;
                ++retryCount;
            }
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
            }
        } while (retry && retryCount < 2 || isSkipTokenAvailable);
        return userMemeberOf;
    }

    @Override
    public List<AADUserElement> getGraphAADUsersFromUserNames(Cloud cloud, AADUserNamesList aadUserNameList) {
        int cloudId = cloud.getCloudId();
        ArrayList<AADUserElement> aadUsersList = new ArrayList<AADUserElement>();
        AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloudId);
        ArrayList<String> tenants = new ArrayList<String>();
        if (cloud.getMultiTenantAADEnabled() == 1) {
            if (!CollectionUtils.isEmpty((Collection)aadCredentials.getTenants())) {
                tenants.addAll(aadCredentials.getTenants());
            } else {
                tenants.add(aadCredentials.getTenentId());
            }
        } else {
            tenants.add(aadCredentials.getTenentId());
        }
        logger.debug("...tenants present..." + tenants.size());
        for (String userName : aadUserNameList.getAadUserNames()) {
            User user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
            if (user == null || user != null && user.isGuest()) {
                AADUserElement aadUser = null;
                for (String tenantId : tenants) {
                    logger.debug("...checking in tenant..." + tenantId);
                    aadUser = this.getNewAADUserFromUserName(cloudId, userName, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantId);
                    if (aadUser == null) continue;
                    break;
                }
                if (aadUser != null) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)aadUser.getProductType())) {
                        logger.debug("user is not part any group " + aadUser.getUserPrincipalName());
                        continue;
                    }
                    aadUser.setUserName(userName);
                    aadUsersList.add(aadUser);
                    continue;
                }
                logger.debug("...........User " + userName + " .........  Not found in AAD Or token expired.........");
                continue;
            }
            logger.debug("$##############################" + userName + " ........present in our db....");
        }
        logger.debug("...........aadUsersList size... " + aadUsersList.size());
        return aadUsersList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List<String> getGroupMembersInfo(String groupId, AADAuthorizationToken authToken) {
        response = new StringBuilder();
        userMemeberOfSet = new HashSet<E>();
        retry = false;
        retryCount = 0;
        httpclient = null;
        httpGet = null;
        result = null;
        mapper = new ObjectMapper();
        url = "https://graph.microsoft.com/v1.0/groups/" + groupId + "/members";
        isSkipTokenAvailable = false;
        userMemberList = new ArrayList<String>();
        do {
            block30: {
                block34: {
                    block32: {
                        block33: {
                            block28: {
                                block29: {
                                    mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                                    AADManagementServiceImpl.logger.debug(".....group members url...." + url);
                                    proxy = this.settingsDao.getProxy(1);
                                    if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                                        AADManagementServiceImpl.logger.debug("host :" + PCHelperConstant.getProxyHost());
                                        AADManagementServiceImpl.logger.debug("port :" + PCHelperConstant.getProxyPort());
                                        proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                                        routePlanner = new DefaultProxyRoutePlanner(proxyval);
                                        httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                                    } else {
                                        httpclient = HttpClients.custom().build();
                                    }
                                    httpGet = new HttpGet(url);
                                    httpGet.addHeader("Authorization", "Bearer " + authToken.getAccess_token());
                                    httpGet.addHeader("Accept", "application/json");
                                    result = httpclient.execute((HttpUriRequest)httpGet);
                                    httpResponseCode = result.getStatusLine().getStatusCode();
                                    AADManagementServiceImpl.logger.debug(groupId + "..........getAADUserFromUserName ........response code ......... " + httpResponseCode);
                                    if (httpResponseCode != 401) ** GOTO lbl50
                                    retry = true;
                                    ++retryCount;
                                    accessTokenAndUpdateInDB = this.getAccessTokenAndUpdateInDB(authToken);
                                    if (accessTokenAndUpdateInDB != null) break block28;
                                    AADManagementServiceImpl.logger.debug("token is expired so return");
                                    var17_19 = null;
                                    if (httpGet == null) break block29;
                                    httpGet.releaseConnection();
                                }
                                this.closeResponse(result);
                                this.closeHttpClient(httpclient);
                                return var17_19;
                            }
                            this.getGroupMembersInfo(groupId, authToken);
                            break block30;
lbl50:
                            // 1 sources

                            if (httpResponseCode != 200) break block30;
                            inputStream = result.getEntity().getContent();
                            in = new BufferedReader(new InputStreamReader(inputStream));
                            var18_20 = null;
                            try {
                                while ((inputLine = in.readLine()) != null) {
                                    response.append(inputLine);
                                }
                            }
                            catch (Throwable inputLine) {
                                var18_20 = inputLine;
                                throw inputLine;
                            }
                            finally {
                                if (in != null) {
                                    if (var18_20 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable inputLine) {
                                            var18_20.addSuppressed(inputLine);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                            }
                            jsonObject = new JSONObject(response.toString());
                            arr = jsonObject.optString("value");
                            if (jsonObject != null) {
                                AADManagementServiceImpl.logger.debug("..jsonobject....." + jsonObject.toString());
                                if (!org.springframework.util.StringUtils.isEmpty((Object)jsonObject.optString("@odata.nextLink"))) {
                                    AADManagementServiceImpl.logger.debug("..jsonobjectnext....." + jsonObject.optString("@odata.nextLink"));
                                }
                            }
                            AADManagementServiceImpl.logger.debug("..outputvaaaaa....." + arr);
                            jsonArray = new JSONArray(arr);
                            for (i = 0; i < jsonArray.length(); ++i) {
                                object = (JSONObject)jsonArray.get(i);
                                displayName = object.get("mail");
                                AADManagementServiceImpl.logger.debug(displayName + "..objfound..." + object);
                                if (displayName == null) continue;
                                AADManagementServiceImpl.logger.debug(displayName + "..founduser..." + object);
                                userMemberList.add((String)object.get("id"));
                            }
                            nextLink = "";
                            if (!org.springframework.util.StringUtils.isEmpty((Object)jsonObject.optString("@odata.nextLink"))) {
                                AADManagementServiceImpl.logger.debug("..jsonobjectnext....." + jsonObject.optString("@odata.nextLink"));
                                nextLink = jsonObject.optString("@odata.nextLink");
                            }
                            response = new StringBuilder();
                            if (org.springframework.util.StringUtils.isEmpty((Object)nextLink)) ** GOTO lbl112
                            AADManagementServiceImpl.logger.debug(url + ".... link available....." + nextLink);
                            if (!url.equalsIgnoreCase(nextLink)) break block32;
                            AADManagementServiceImpl.logger.debug(url + ".... link available.but same...." + userMemeberOfSet);
                            isSkipTokenAvailable = false;
                            if (httpGet == null) break block33;
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                        break;
                    }
                    try {
                        url = nextLink;
                        isSkipTokenAvailable = true;
lbl112:
                        // 2 sources

                        if (!org.springframework.util.StringUtils.isEmpty((Object)nextLink)) break block30;
                        AADManagementServiceImpl.logger.debug("....no link available.....");
                        isSkipTokenAvailable = false;
                        if (httpGet == null) break block34;
                    }
                    catch (Exception e) {
                        block35: {
                            try {
                                AADManagementServiceImpl.logger.trace("" + e);
                                AADManagementServiceImpl.logger.error(" ERROR trying to get getAADUserGroupInfo " + e.getMessage());
                                retry = true;
                                ++retryCount;
                                if (httpGet == null) break block35;
                            }
                            catch (Throwable var23_30) {
                                if (httpGet != null) {
                                    httpGet.releaseConnection();
                                }
                                this.closeResponse(result);
                                this.closeHttpClient(httpclient);
                                throw var23_30;
                            }
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                    }
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                break;
            }
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
        } while (retry && retryCount < 2 || isSkipTokenAvailable);
        return userMemberList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List<String> getNewGroupMembersInfo(String groupId, String clientId, String secretKey, String tenantId) {
        response = new StringBuilder();
        userMemeberOfSet = new HashSet<E>();
        retry = false;
        retryCount = 0;
        httpclient = null;
        httpGet = null;
        result = null;
        mapper = new ObjectMapper();
        url = "https://graph.microsoft.com/v1.0/groups/" + groupId + "/members";
        isSkipTokenAvailable = false;
        userMemberList = new ArrayList<String>();
        okHttpClient = AADManagementServiceImpl.getOkHttpClient(clientId, secretKey, tenantId);
        do {
            block24: {
                block28: {
                    block26: {
                        block27: {
                            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                            AADManagementServiceImpl.logger.debug(".....group members url...." + url);
                            proxy = this.settingsDao.getProxy(1);
                            if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                                AADManagementServiceImpl.logger.debug("host :" + PCHelperConstant.getProxyHost());
                                AADManagementServiceImpl.logger.debug("port :" + PCHelperConstant.getProxyPort());
                                proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                                routePlanner = new DefaultProxyRoutePlanner(proxyval);
                                httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                            } else {
                                httpclient = HttpClients.custom().build();
                            }
                            httpBuilder = HttpUrl.parse((String)url).newBuilder();
                            request = new Request.Builder().url(httpBuilder.build()).build();
                            responseObj = okHttpClient.newCall(request).execute();
                            httpResponseCode = responseObj.code();
                            AADManagementServiceImpl.logger.debug(groupId + "..........getAADUserFromUserName ........response code ......... " + httpResponseCode);
                            if (httpResponseCode != 200) break block24;
                            inputStream = responseObj.body().byteStream();
                            in = new BufferedReader(new InputStreamReader(inputStream));
                            var24_25 = null;
                            try {
                                while ((inputLine = in.readLine()) != null) {
                                    response.append(inputLine);
                                }
                            }
                            catch (Throwable inputLine) {
                                var24_25 = inputLine;
                                throw inputLine;
                            }
                            finally {
                                if (in != null) {
                                    if (var24_25 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable inputLine) {
                                            var24_25.addSuppressed(inputLine);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                            }
                            jsonObject = new JSONObject(response.toString());
                            arr = jsonObject.optString("value");
                            AADManagementServiceImpl.logger.debug("..output....." + arr);
                            jsonArray = new JSONArray(arr);
                            for (i = 0; i < jsonArray.length(); ++i) {
                                object = (JSONObject)jsonArray.get(i);
                                displayName = object.get("mail");
                                AADManagementServiceImpl.logger.debug(displayName + "..objfound..." + object);
                                if (displayName == null) continue;
                                AADManagementServiceImpl.logger.debug(displayName + "..founduser..." + object);
                                userMemberList.add((String)object.get("id"));
                            }
                            nextLink = "";
                            response = new StringBuilder();
                            if (org.springframework.util.StringUtils.isEmpty((Object)nextLink)) ** GOTO lbl87
                            AADManagementServiceImpl.logger.debug(url + ".... link available....." + nextLink);
                            if (!url.equalsIgnoreCase(nextLink)) break block26;
                            AADManagementServiceImpl.logger.debug(url + ".... link available.but same...." + userMemeberOfSet);
                            isSkipTokenAvailable = false;
                            if (httpGet == null) break block27;
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                        break;
                    }
                    try {
                        url = nextLink;
                        isSkipTokenAvailable = true;
lbl87:
                        // 2 sources

                        if (!org.springframework.util.StringUtils.isEmpty((Object)nextLink)) break block24;
                        AADManagementServiceImpl.logger.debug("....no link available.....");
                        isSkipTokenAvailable = false;
                        if (httpGet == null) break block28;
                    }
                    catch (Exception e) {
                        block29: {
                            try {
                                AADManagementServiceImpl.logger.trace("" + e);
                                AADManagementServiceImpl.logger.error(" ERROR trying to get getAADUserGroupInfo " + e.getMessage());
                                retry = true;
                                ++retryCount;
                                if (httpGet == null) break block29;
                            }
                            catch (Throwable var29_35) {
                                if (httpGet != null) {
                                    httpGet.releaseConnection();
                                }
                                this.closeResponse(result);
                                this.closeHttpClient(httpclient);
                                throw var29_35;
                            }
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                    }
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                break;
            }
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
        } while (retry && retryCount < 2 || isSkipTokenAvailable);
        return userMemberList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getGroupId(int cloudId, String groupName) {
        AADAuthorizationToken authToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (authToken == null || org.springframework.util.StringUtils.isEmpty((Object)authToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return null;
        }
        StringBuilder response = new StringBuilder();
        CloseableHttpClient httpclient = null;
        HttpGet httpGet = null;
        CloseableHttpResponse result = null;
        boolean retry = false;
        int retryCount = 0;
        ObjectMapper mapper = new ObjectMapper();
        do {
            block39: {
                block34: {
                    block35: {
                        block37: {
                            block38: {
                                DefaultProxyRoutePlanner routePlanner;
                                block32: {
                                    block33: {
                                        try {
                                            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                                            String groupNameenc = URLEncoder.encode("startswith(displayName, '" + groupName + "')", UTF_8);
                                            String url = "https://graph.microsoft.com/v1.0/groups?$filter=" + groupNameenc;
                                            logger.debug("url to get the user from aad:" + url);
                                            Proxy proxy = this.settingsDao.getProxy(1);
                                            if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                                                logger.debug("host :" + PCHelperConstant.getProxyHost());
                                                logger.debug("port :" + PCHelperConstant.getProxyPort());
                                                HttpHost proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                                                routePlanner = new DefaultProxyRoutePlanner(proxyval);
                                                httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                                            } else {
                                                httpclient = HttpClients.custom().build();
                                            }
                                            httpGet = new HttpGet(url);
                                            httpGet.addHeader("Authorization", "Bearer " + authToken.getAccess_token());
                                            httpGet.addHeader("Accept", "application/json");
                                            result = httpclient.execute((HttpUriRequest)httpGet);
                                            int httpResponseCode = result.getStatusLine().getStatusCode();
                                            logger.debug("getAADUserFromUserName ........response code ......... " + httpResponseCode);
                                            if (httpResponseCode == 401) {
                                                retry = true;
                                                ++retryCount;
                                                if ((authToken = this.getAccessTokenAndUpdateInDB(authToken)) == null) {
                                                    logger.debug("..token is expred ....");
                                                    routePlanner = null;
                                                    if (httpGet == null) break block32;
                                                    break block33;
                                                }
                                                this.getGroupId(cloudId, groupName);
                                                if (httpGet == null) break block34;
                                                break block35;
                                            }
                                            if (httpResponseCode == 200) {
                                                InputStream inputStream = result.getEntity().getContent();
                                                try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                                                    String inputLine;
                                                    while ((inputLine = in.readLine()) != null) {
                                                        response.append(inputLine);
                                                    }
                                                }
                                                JSONObject jsonObject = new JSONObject(response.toString());
                                                String arr = jsonObject.optString("value");
                                                logger.debug("..output....." + arr);
                                                JSONArray jsonArray = new JSONArray(arr);
                                                for (int i = 0; i < jsonArray.length(); ++i) {
                                                    JSONObject object = (JSONObject)jsonArray.get(i);
                                                    Object displayName = object.get("displayName");
                                                    logger.debug(displayName + "..objfound..." + object);
                                                    if (displayName == null || !groupName.equalsIgnoreCase((String)displayName)) continue;
                                                    logger.debug(displayName + "..foundgroup..." + object);
                                                    String string = (String)object.get("id");
                                                    if (httpGet != null) {
                                                        httpGet.releaseConnection();
                                                    }
                                                    this.closeResponse(result);
                                                    this.closeHttpClient(httpclient);
                                                    return string;
                                                }
                                                if (httpGet != null) {
                                                    httpGet.releaseConnection();
                                                }
                                                this.closeResponse(result);
                                                this.closeHttpClient(httpclient);
                                                return "";
                                            }
                                            logger.debug("..........user not fount.........");
                                            if (httpGet == null) break block37;
                                            break block38;
                                        }
                                        catch (Exception e) {
                                            logger.trace("" + e);
                                            logger.error(" ERROR trying to get AADUser From UserName " + e.getMessage());
                                            retry = true;
                                            ++retryCount;
                                            break block39;
                                        }
                                    }
                                    httpGet.releaseConnection();
                                }
                                this.closeResponse(result);
                                this.closeHttpClient(httpclient);
                                return routePlanner;
                            }
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                        return "";
                    }
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                break block39;
                finally {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                }
            }
            if (!retry) return "";
        } while (retryCount < 2);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getNewGroupId(int cloudId, String groupName, String clientId, String secret, String tenantId) {
        StringBuilder response = new StringBuilder();
        CloseableHttpClient httpclient = null;
        Object httpGet = null;
        CloseableHttpResponse result = null;
        boolean retry = false;
        int retryCount = 0;
        OkHttpClient okHttpClient = AADManagementServiceImpl.getOkHttpClient(clientId, secret, tenantId);
        ObjectMapper mapper = new ObjectMapper();
        do {
            block30: {
                block29: {
                    try {
                        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                        String groupNameenc = URLEncoder.encode("startswith(displayName, '" + groupName + "')", UTF_8);
                        String url = "https://graph.microsoft.com/v1.0/groups?$filter=" + groupNameenc;
                        logger.debug("url to get the user from aad:" + url);
                        Proxy proxy = this.settingsDao.getProxy(1);
                        if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                            logger.debug("host :" + PCHelperConstant.getProxyHost());
                            logger.debug("port :" + PCHelperConstant.getProxyPort());
                            HttpHost proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                            httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                        } else {
                            httpclient = HttpClients.custom().build();
                        }
                        HttpUrl.Builder httpBuilder = HttpUrl.parse((String)url).newBuilder();
                        Request request = new Request.Builder().url(httpBuilder.build()).build();
                        Response responseObj = okHttpClient.newCall(request).execute();
                        int httpResponseCode = responseObj.code();
                        logger.debug("getAADUserFromUserName ........response code ......... " + httpResponseCode);
                        if (httpResponseCode == 200) {
                            InputStream inputStream = responseObj.body().byteStream();
                            try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                                String inputLine;
                                while ((inputLine = in.readLine()) != null) {
                                    response.append(inputLine);
                                }
                            }
                            JSONObject jsonObject = new JSONObject(response.toString());
                            String arr = jsonObject.optString("value");
                            logger.debug("..output....." + arr);
                            JSONArray jsonArray = new JSONArray(arr);
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                JSONObject object = (JSONObject)jsonArray.get(i);
                                Object displayName = object.get("displayName");
                                logger.debug(displayName + "..objfound..." + object);
                                if (displayName == null || !groupName.equalsIgnoreCase((String)displayName)) continue;
                                logger.debug(displayName + "..foundgroup..." + object);
                                String string = (String)object.get("id");
                                if (httpGet != null) {
                                    httpGet.releaseConnection();
                                }
                                this.closeResponse(result);
                                this.closeHttpClient(httpclient);
                                return string;
                            }
                            if (httpGet != null) {
                                httpGet.releaseConnection();
                            }
                            this.closeResponse(result);
                            this.closeHttpClient(httpclient);
                            return "";
                        }
                        logger.debug("..........user not fount.........");
                        if (httpGet == null) break block29;
                    }
                    catch (Exception e) {
                        logger.trace("" + e);
                        logger.error(" ERROR trying to get AADUser From UserName " + e.getMessage());
                        retry = true;
                        break block30;
                    }
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                return "";
                finally {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                }
            }
            if (!retry) return "";
        } while (++retryCount < 2);
        return "";
    }

    private static /* synthetic */ String lambda$getAADUserGroupInfo$9(GraphGroupInfo group) {
        return group.getDisplayName().toLowerCase();
    }
}

