/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.dto.AuthorizationDeviceTo;
import com.parablu.bluvault.udc.service.AlertHistoryService;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.DeviceAndUserSecurityService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.mail.service.CloudMailService;
import com.parablu.mt.service.LdapService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCClientTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BluSyncGroupBackupPolicyElement;
import com.parablu.paracloud.element.BluSyncGroupSyncPolicyElement;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.DeviceRegistrationElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.LdapUserElement;
import com.parablu.paracloud.element.RequestDeviceElement;
import com.parablu.paracloud.element.UserLicenseElement;
import com.parablu.paracloud.element.response.DeviceElementResponse;
import com.parablu.paracloud.util.DateUtil;
import com.parablu.pcbd.domain.AlertHistory;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.Group;
import com.parablu.pcbd.domain.Person;
import com.parablu.pcbd.domain.User;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DeviceController
extends BaseController {
    private static Logger logger = LogManager.getLogger(DeviceController.class);
    private static final String BKP = "Bkp";
    private static final String SYNC = "Sync";
    private static final String PORTAL = "portal";
    private static final String BKP_SYNC = "Bkp-Sync";
    private static final String USER_NAME = "userName";
    private static final String DEVICE_UUID = "deviceUUID";
    private static final String EXCEPTION = " Exception  :";
    private static final String BASE_EXCEPTION = " BaseException  :";
    private static final String DATA_ACCESS_EXCEPTION = " DataAccessException  :";
    private static final String AUTHENTICATION_FAILED = " Authentication failed  for user ";
    private static final String EMPTY_RESULT_DATA_ACCESS_EXCEPTION = " EmptyResultDataAccessException  :";
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private UserManagementService managementService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AuthorizationService authorizationService1;
    @Autowired
    private AlertHistoryService alertHistoryService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private LdapService ldapService;
    @Autowired
    private DeviceAndUserSecurityService deviceAndUserSecurityService;
    @Autowired
    private CloudMailService cloudMailService;

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/devicesdeprecated"}, method={RequestMethod.POST})
    @ResponseBody
    public Object registerDevice(@PathVariable(value="cloudName") String cloudName1, @RequestBody RequestDeviceElement registerDeviceElement, HttpServletRequest request, HttpServletResponse response) {
        int statusCode;
        String cloudName = cloudName1;
        String licenseEnabled = "";
        logger.debug("$%$%%$%$  calling /registerAsNewDevice ..." + registerDeviceElement.getDeviceUUID());
        logger.debug("RegisterDeviceElement ELEMENT .... " + registerDeviceElement.toString());
        String username = registerDeviceElement.getUserName();
        String password = registerDeviceElement.getPassword();
        logger.debug(username + " username  password.... " + password);
        String productVersion = registerDeviceElement.getProductVersion();
        logger.debug("THE PRODUCT VERSION OF AGENT IS>>>>>>" + productVersion);
        if (productVersion != null) {
            registerDeviceElement.setClientVersion(productVersion);
        }
        String client = registerDeviceElement.getClientType();
        int clientType = 1;
        if (client != null) {
            clientType = PCClientTypes.getClientType((String)client);
        }
        client = StringUtils.isEmpty((String)client) || PORTAL.equalsIgnoreCase(client) ? PORTAL : client.toLowerCase();
        User user = null;
        DeviceRegistrationElement deviceRegistrationElement = new DeviceRegistrationElement();
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.error(" Invlaid cloud license ....");
            return this.toJSON(1202);
        }
        cloudName = cl.getCloud().getCloudName();
        if (!org.springframework.util.StringUtils.hasText((String)username)) {
            logger.error(" Invlaid UserName ....");
            return this.toJSON(1300);
        }
        if (registerDeviceElement == null || !org.springframework.util.StringUtils.hasText((String)registerDeviceElement.getDeviceName()) || !org.springframework.util.StringUtils.hasText((String)registerDeviceElement.getDeviceUUID())) {
            logger.error(" Invlaid Device Name ....");
            return this.toJSON(1301);
        }
        int cloudId = cl.getCloud().getCloudId();
        RequestDeviceElement deviceElement = registerDeviceElement;
        Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, registerDeviceElement.getDeviceUUID());
        if (this.isFeatureEnabled(cl, "Server Backup Enabled")) {
            user = this.managementService.getAdminUserWithServerBackupEnabled(cloudId);
        } else {
            try {
                boolean isLdapEnabledForCloud = this.isLdapEnabledForCloud(cl.getCloud());
                boolean skipLocalAD = PCHelperConstant.isLocalAD();
                boolean isAuthenticated = false;
                if (isLdapEnabledForCloud) {
                    // empty if block
                }
                if (isLdapEnabledForCloud && !skipLocalAD && org.springframework.util.StringUtils.isEmpty((Object)password)) {
                    try {
                        user = this.managementService.authenticateV2(cloudId, cloudName, username);
                        if (user != null) {
                            isAuthenticated = true;
                        }
                    }
                    catch (BaseException baseException) {
                        logger.trace("Base Exception happened....." + (Object)((Object)baseException));
                        logger.error("Base Exception happened....." + baseException.getMessage() + "..Error Code>>" + baseException.getErrorCode());
                    }
                } else if (isLdapEnabledForCloud && !skipLocalAD && !org.springframework.util.StringUtils.isEmpty((Object)password)) {
                    logger.debug("Before authenticating through AD....");
                    String encPwd = registerDeviceElement.getEncPwd();
                    String ldapPassword = DeviceController.decryptBS(encPwd, "26ac50996c66634c");
                    Object[] objArr = this.ldapService.authenticate(username, ldapPassword);
                    isAuthenticated = (Boolean)objArr[0];
                    licenseEnabled = (String)objArr[1];
                    if (isAuthenticated) {
                        AuthorizationTokens authorizationTokens = this.authorizationService1.getAuthorizationTokenForUserName(cloudId, cloudName, username);
                        if (authorizationTokens == null) {
                            UUID uuid = UUID.randomUUID();
                            String token = String.valueOf(uuid);
                            this.authorizationService1.addTokenByUser(cloudId, cloudName, token, username, clientType);
                        }
                        user = this.managementService.getUserDetails(cloudId, cloudName, username);
                    }
                }
                logger.debug(password + "...After authenticating through AD....isAuthenticated>>>" + isAuthenticated);
                if (!isAuthenticated) {
                    user = this.managementService.authenticate(cloudId, cloudName, username, password);
                }
            }
            catch (BaseException e) {
                logger.trace(EXCEPTION + (Object)((Object)e));
                logger.error(EXCEPTION + e.getMessage());
                if (3 == clientType) {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, AUTHENTICATION_FAILED + client, username, "", registerDeviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                }
                logger.trace("inside base exception status code:" + e.getErrorStatus());
                return this.toJSON(1210);
            }
        }
        boolean isDeviceBlocked = false;
        if (device != null && device.isBlocked()) {
            isDeviceBlocked = true;
        }
        if ((statusCode = this.validateDeviceAndUser(cloudId, cloudName, username, cl, (DeviceElement)deviceElement, user, registerDeviceElement.getDeviceUUID(), isDeviceBlocked)) > 0) {
            response.setStatus(statusCode);
            logger.error(" validation failed ............");
            if (3 == clientType) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "validation failed " + client, username, "", registerDeviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.VALIDATION_FAIL.getActionTypeValue());
            }
            return this.toJSON(1302);
        }
        try {
            BluSyncGroupBackupPolicyElement groupPolicyElement;
            logger.debug("############################ BEFORE RGISTERING ");
            AuthorizationTokens oldTokens = this.authorizationService1.getAuthorizationTokenForDeviceUUID(cloudId, cloudName, registerDeviceElement.getDeviceUUID());
            AuthorizationDeviceTo authorizationDeviceTo = this.deviceManagementService.registerDeviceV2(cloudId, cloudName, (DeviceElement)deviceElement, oldTokens, user, clientType);
            if (authorizationDeviceTo == null) {
                response.setStatus(420);
                if (3 == clientType) {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "Device blocked " + client, username, "", registerDeviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                }
                return this.toJSON(1303);
            }
            this.authorizationService1.addTokenOrUpdate(cloudId, cloudName, authorizationDeviceTo.getAuthorizationTokens());
            boolean isExternalStorageSelected = false;
            if (cl.getCloud().getExternalStorageAllowed() == 1) {
                isExternalStorageSelected = true;
            }
            Integer uiVersion = this.deviceManagementService.getUIVersion();
            response.addHeader("uiVersion", uiVersion.toString());
            response.addHeader("isExternalStorageSelected", Boolean.toString(isExternalStorageSelected));
            DeviceElement d = new DeviceElement();
            d.setDeviceName(authorizationDeviceTo.getDevice().getDeviceName());
            d.setDecoupled(authorizationDeviceTo.getDevice().isDecoupled());
            d.setDeviceId(authorizationDeviceTo.getDevice().getId().toString());
            d.setDeviceUUID(authorizationDeviceTo.getDevice().getDeviceUUID());
            logger.debug("############################ device id::::: " + authorizationDeviceTo.getDevice().getId().toString());
            logger.debug("############################ device uuid::::: " + authorizationDeviceTo.getDevice().getDeviceUUID());
            boolean isPoliciesAvailable = false;
            if (!org.springframework.util.StringUtils.isEmpty((Object)licenseEnabled) && licenseEnabled.equalsIgnoreCase(BKP_SYNC) || user.isBackupEnabled() && user.isSyncEnabled()) {
                groupPolicyElement = this.deviceManagementService.getBluSyncGroupPolicyElement(cloudId, cloudName, user.getUserName(), d.getDeviceUUID());
                BluSyncGroupSyncPolicyElement groupSyncPolicyElement = this.deviceManagementService.getBluSyncGroupSyncPolicyElement(cloudId, cloudName, user.getUserName(), d.getDeviceUUID());
                logger.debug("Sync and backup Enabled ");
                if (groupPolicyElement != null && groupSyncPolicyElement != null) {
                    deviceRegistrationElement.setBackupPolicyElement(groupPolicyElement);
                    deviceRegistrationElement.setSyncPolicyElement(groupSyncPolicyElement);
                    isPoliciesAvailable = true;
                }
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)licenseEnabled) && licenseEnabled.equalsIgnoreCase(BKP) || user.isBackupEnabled()) {
                groupPolicyElement = this.deviceManagementService.getBluSyncGroupPolicyElement(cloudId, cloudName, user.getUserName(), d.getDeviceUUID());
                logger.debug("Backup Enabled ");
                if (groupPolicyElement != null) {
                    deviceRegistrationElement.setBackupPolicyElement(groupPolicyElement);
                    isPoliciesAvailable = true;
                }
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)licenseEnabled) && licenseEnabled.equalsIgnoreCase(BKP) || user.isSyncEnabled()) {
                logger.debug("Sync Enabled ");
                BluSyncGroupSyncPolicyElement groupSyncPolicyElement = this.deviceManagementService.getBluSyncGroupSyncPolicyElement(cloudId, cloudName, user.getUserName(), d.getDeviceUUID());
                if (groupSyncPolicyElement != null) {
                    deviceRegistrationElement.setSyncPolicyElement(groupSyncPolicyElement);
                    isPoliciesAvailable = true;
                }
            }
            if (!isPoliciesAvailable) {
                response.setStatus(901);
                if (3 == clientType) {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "No Policy Mapped" + client, username, "", registerDeviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.NO_POLICY_MAP.getActionTypeValue());
                }
                return this.toJSON(1303);
            }
            deviceRegistrationElement.setDeviceElement(d);
            DeviceBackupOverView deviceBackupOverView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
            if (deviceBackupOverView == null) {
                logger.debug(" First time saving device backup ....");
                this.deviceManagementService.saveDeviceBackupOverView(cloudId, authorizationDeviceTo.getDevice());
            }
            if (3 == clientType) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "logged into  " + client, username, "", registerDeviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)licenseEnabled)) {
                if (licenseEnabled.equalsIgnoreCase(BKP_SYNC)) {
                    user.setBackupEnabled(true);
                    user.setSyncEnabled(true);
                } else if (licenseEnabled.equalsIgnoreCase(BKP)) {
                    user.setBackupEnabled(true);
                    user.setSyncEnabled(false);
                } else if (licenseEnabled.equalsIgnoreCase(SYNC)) {
                    user.setBackupEnabled(false);
                    user.setSyncEnabled(true);
                }
            }
            deviceRegistrationElement.setUserLicenseElement(this.setUserAndLicenseDetails(response, user, cl, authorizationDeviceTo));
            response.setStatus(201);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return this.toJSON(1203);
        }
        return this.toJSON(200, deviceRegistrationElement);
    }

    private boolean isFeatureEnabled(CloudLicenseTo cl, String feature) {
        List list = cl.getCloud().getCloudCustomisableDetails();
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!customisableDetails.getName().equalsIgnoreCase(feature)) continue;
            return true;
        }
        return false;
    }

    private boolean isLdapEnabledForCloud(Cloud cl) {
        boolean isLdapEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (!"LDAP Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isLdapEnabled = true;
                break;
            }
        }
        return isLdapEnabled;
    }

    private boolean checkWithADandMigrateUser(CloudLicenseTo cl, int cloudId, String cloudName, String userName) {
        boolean success = false;
        boolean isSyncEnabled = false;
        boolean isBackupEnabled = false;
        boolean odbBkpEnabled = false;
        boolean exchangeBkpEnabled = false;
        HttpServletResponse response = null;
        List list = cl.getCloud().getCloudCustomisableDetails();
        try {
            Person person = this.ldapService.getPerson(userName);
            if (person != null) {
                for (CloudCustomisableDetails customisableDetails : list) {
                    if ("Sync Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                        isSyncEnabled = true;
                    }
                    if ("Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                        isBackupEnabled = true;
                    }
                    if ("OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                        odbBkpEnabled = true;
                    }
                    if (!"Exchange Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
                    exchangeBkpEnabled = true;
                }
                int code = this.deviceAndUserSecurityService.validateUserRestrictions(cloudId, cloudName, cl.getCloud());
                if (!this.checkLicense(code, response)) {
                    return success;
                }
                if (isSyncEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                    return success;
                }
                if (isBackupEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                    return success;
                }
                LdapUserElement ldapUserElement = new LdapUserElement();
                ldapUserElement.setUserName(person.getFullName());
                ldapUserElement.setEmailId(person.getEmailId());
                ldapUserElement.setOrganizationUnit(person.getOrganizationalUnit());
                ldapUserElement.setDisplayName(person.getDisplayName());
                ldapUserElement.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
                ldapUserElement.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
                ldapUserElement.setDefaultO365Policy(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
                this.managementService.createUserFromLdap(cloudId, cloudName, ldapUserElement, "AUTO", isSyncEnabled, isBackupEnabled, odbBkpEnabled, exchangeBkpEnabled);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "MIGRATION", "AUTO", ldapUserElement.getUserName(), "LDAP", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
                success = true;
            } else {
                logger.debug(" PERSON NOT FOUND  ..... " + userName);
                success = false;
            }
        }
        catch (Exception e) {
            success = false;
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return success;
    }

    public static final String decryptBS(String encrypted, String key) {
        try {
            SecretKeySpec keySpecification = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, keySpecification);
            byte[] plainBytes = cipher.doFinal(Base64.decodeBase64((String)encrypted));
            return new String(plainBytes);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return "";
        }
    }

    private int validateDeviceAndUser(int cloudId, String cloudName, String username, CloudLicenseTo cl, DeviceElement deviceElement, User user, String deviceUUID, boolean isDeviceBlocked) {
        int statuCode = 0;
        if (isDeviceBlocked) {
            statuCode = 420;
            logger.error("Device Blocked for user ..... ");
        } else {
            List<DeviceElement> list = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, user.getUserName());
            int activeDevicesForUser = this.activeDevicesForUser(list, cloudId, cloudName, username, deviceUUID);
            if (activeDevicesForUser >= cl.getCloud().getNoOfDevicesAllowed()) {
                statuCode = 418;
                logger.error("Device limit exceeded for user ..... " + activeDevicesForUser);
                if (deviceElement != null && this.isLdapEnabledForCloud(cl.getCloud())) {
                    logger.error("EMAIL Device limit exceeded for user ..... " + deviceElement.getDeviceName());
                    this.sendEmailForUserDeviceLimitExceeded(cloudId, cl.getCloud().getCloudName(), user, activeDevicesForUser, deviceElement.getDeviceName());
                    DeviceElement element = list.get(0);
                    Device device = this.deviceManagementService.getDeviceByName(cloudId, cloudName, element.getDeviceName());
                    AlertHistory alertHistory = new AlertHistory();
                    alertHistory.setUser(user);
                    alertHistory.setDevice(device);
                    alertHistory.setJobType("Device Limit Reached");
                    alertHistory.setBatchStartTimestamp(System.currentTimeMillis());
                    alertHistory.setBatchEndTimestamp(System.currentTimeMillis());
                    alertHistory.setAction(user.getUserName() + " already has " + activeDevicesForUser + " active devices. ");
                    this.alertHistoryService.saveAlertHistory(cloudId, cloudName, alertHistory);
                }
            }
        }
        if (!(user == null || user.isSyncEnabled() || user.isBackupEnabled() || user.isServerBackupEnabled())) {
            statuCode = 425;
            logger.error("User does not have backup/server-backup and Sync Enabled ...");
        }
        return statuCode;
    }

    private UserLicenseElement setUserAndLicenseDetails(HttpServletResponse response, User user, CloudLicenseTo cl, AuthorizationDeviceTo authorizationDeviceTo) {
        boolean isRestoreEnabled = this.isRestoreEnabledForCloud(cl);
        UserLicenseElement userLicenseElement = new UserLicenseElement();
        userLicenseElement.setRestoreEnabled(isRestoreEnabled);
        userLicenseElement.setBackupEnabled(user.isBackupEnabled());
        userLicenseElement.setSyncEnabled(user.isSyncEnabled());
        userLicenseElement.setToken(authorizationDeviceTo.getAuthorizationTokens().getToken());
        userLicenseElement.setAdmin(user.isAdmin());
        userLicenseElement.setReadOnlyAdmin(user.isReadOnlyAdmin());
        userLicenseElement.setEmailId(user.getEmailId());
        return userLicenseElement;
    }

    private int activeDevicesForUser(List<DeviceElement> list, int cloudId, String cloudName, String username, String deviceUUID) {
        int activeDevicesForUser = 0;
        for (DeviceElement element : list) {
            if (element.isBlocked() || element.getDeviceUUID().equals(deviceUUID)) continue;
            ++activeDevicesForUser;
        }
        return activeDevicesForUser;
    }

    private boolean isRestoreEnabledForCloud(CloudLicenseTo cl) {
        boolean isRestoreEnabled = false;
        List list = cl.getCloud().getCloudCustomisableDetails();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (!"Restore Enabled".equals(cloudPluginDetails.getName())) continue;
                isRestoreEnabled = true;
                break;
            }
        }
        return isRestoreEnabled;
    }

    private void sendEmailForUserDeviceLimitExceeded(int cloudId, String cloudName, User userObj, int noOfDevices, String deviceName) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("device-limit-reached");
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(userObj.getUserName());
        emailRecipent.setEmail(userObj.getEmailId());
        if (PCHelperConstant.getPropertyFileValueEmailsToadminsOnly()) {
            if (userObj.isAdmin()) {
                emailRecipents.add(emailRecipent);
            }
        } else {
            emailRecipents.add(emailRecipent);
        }
        List<User> users = this.managementService.getAllAdmins(cloudId, cloudName);
        for (User user : users) {
            if (!user.isActive()) continue;
            emailRecipent = new EmailRecipent();
            emailRecipent.setUserName(user.getUserName());
            emailRecipent.setEmail(user.getEmailId());
            emailRecipents.add(emailRecipent);
        }
        email.setActionBy(userObj.getUserName());
        email.setStartDate(DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()));
        email.setDeviceName(deviceName);
        email.setNoOfDevices(Integer.valueOf(noOfDevices));
        email.setRecipents(emailRecipents);
        this.cloudMailService.sendMail(email);
    }

    @RequestMapping(value={"/versions/{versionnumber}/clouds/{cloudName}/users/{userName}/devices"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getAllRegisteredDevicesByUser(@PathVariable(value="versionnumber") String versionNumber1, @PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        DeviceElementResponse devices = new DeviceElementResponse();
        logger.debug("calling /getAllDeviceAllbyUser...");
        try {
            List<DeviceElement> devList;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            userName = this.decodeBase64UTFString(userName);
            if (!this.checkLicense(cl, response)) {
                return this.toJSON(1202);
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return this.toJSON(1201);
            }
            String policyType = request.getHeader("policyType");
            User user = this.managementService.getUserDetails(cloudId, cloudName, userName);
            if (user == null) {
                response.setStatus(400);
                return this.toJSON(1300);
            }
            if (user.isServerBackupEnabled()) {
                if (user.isAdmin()) {
                    devList = this.deviceManagementService.getAllDevices(cloudId, cloudName, policyType);
                } else {
                    Group group = this.managementService.getUserGroup(cloudId, user);
                    devList = this.deviceManagementService.getAllDevicesByGroup(cloudId, group, policyType);
                }
            } else {
                devList = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, user.getUserName());
            }
            if (CollectionUtils.isEmpty(devList)) {
                response.setStatus(204);
                return this.toJSON(1302);
            }
            logger.debug("device list " + devList.size());
            devices.setDevices(devList);
            response.setStatus(200);
            return this.toJSON(200, devices);
        }
        catch (DataAccessException e) {
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            return this.toJSON(1209);
        }
        catch (BaseException e) {
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            return this.toJSON(400);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/devices/{deviceUUID}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Object decoupleDeviceAudit(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID1, @RequestParam(value="action") String action1, HttpServletRequest request, HttpServletResponse response) throws FileNotFoundException {
        logger.debug("Entering DeviceManagementController.auditDeviceDecoupled ....  ");
        try {
            String token;
            String cloudName = cloudName1;
            String deviceUUID = deviceUUID1;
            String action = action1;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return this.toJSON(cl.getCloudLicenseStatus());
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return this.toJSON(this.getTokenValidationResponseStatusCode(response));
            }
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null) {
                response.setStatus(200);
                return this.toJSON(200);
            }
            logger.debug("Action : " + action);
            if ("DECOUPLE".equalsIgnoreCase(action)) {
                User userObj;
                AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
                User user = userObj = authorizationTokens.getUser();
                logger.debug(device + "*****************auditDeviceDecoupled*************************************" + user);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "Decoupled the device", user.getUserName(), device.getDeviceName(), "BluSync", System.currentTimeMillis(), PCActionTypes.DECOUPLE.getActionTypeValue());
                this.deviceManagementService.updateDeviceDecoupled(cloudId, cloudName, deviceUUID);
                if (!this.sendEmailForDecoupledDevice(cloudId, cloudName, user.getUserName(), device.getDeviceName())) {
                    response.setStatus(206);
                    return this.toJSON(1211);
                }
                this.createAlertHistory(cloudId, cloudName, device, userObj);
                Map paramMap = request.getParameterMap();
                return this.toJSON(200, this.getMetadataElement(1, 1, 1L, request.getRequestURI(), paramMap), "");
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return this.toJSON(1203);
        }
        return response;
    }

    private void createAlertHistory(int cloudId, String cloudName, Device device, User userObj) {
        AlertHistory alertHistory = new AlertHistory();
        alertHistory.setUser(userObj);
        alertHistory.setDevice(device);
        alertHistory.setJobType("Decoupled");
        alertHistory.setBatchStartTimestamp(System.currentTimeMillis());
        alertHistory.setBatchEndTimestamp(System.currentTimeMillis());
        alertHistory.setAction("Device Decoupled on " + DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()) + " by " + userObj.getUserName());
        this.alertHistoryService.saveAlertHistory(cloudId, cloudName, alertHistory);
    }

    private boolean sendEmailForDecoupledDevice(int cloudId, String cloudName, String userName, String deviceName) {
        try {
            EmailProps email = new EmailProps();
            ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
            email.setAction("decoupled-device");
            List<User> users = this.managementService.getAllAdmins(cloudId, cloudName);
            for (User user : users) {
                if (!user.isActive()) continue;
                EmailRecipent emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(user.getUserName());
                emailRecipent.setEmail(user.getEmailId());
                emailRecipents.add(emailRecipent);
            }
            email.setActionBy(userName);
            email.setStartDate(DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()));
            email.setDeviceName(deviceName);
            email.setRecipents(emailRecipents);
            this.cloudMailService.sendMail(email);
            return true;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
    }
}

