from .Dependencies.Utilities.util import *

app = Flask(__name__)

app.config['SECRET_KEY'] = "IAMTHEDESTROYER"


bcrypt = Bcrypt(app)


def setup_logger():
    logger = logging.getLogger('my_logger')
    logger.setLevel(logging.DEBUG)

    # create rotating file handler
    handler = RotatingFileHandler('OrderCenter.log', maxBytes=1024*1024, backupCount=5)
    handler.setLevel(logging.DEBUG)

    # create formatter
    formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
    handler.setFormatter(formatter)

    # add handler to logger
    logger.addHandler(handler)

    return logger


my_logger = setup_logger()

@app.route("/")
def home():
    return redirect(url_for('authentication_blueprint.login'))


def timestampToDateTime(value):
    if value is not None:
        if (value == 0):
            return "Skipped Validation"
        
        elif value == "-":
            return value

        elif(value != "Declined") or (value != "N/A") or (value != "Order Placed Time"):
            print(value)
            print(".......The value is ")
            dt_object = datetime.fromtimestamp(value)
            formatted_datetime = dt_object.strftime("%d-%b-%y %I:%M %p")
            return formatted_datetime
        else:
            return "Declined"
    else:
        return "Declined"

app.jinja_env.filters['timestampToDateTime'] = timestampToDateTime

from .Api.ethisalatApi.routes import ethisalatApi
from .Api.Authentication.routes import authentication_blueprint


app.register_blueprint(ethisalatApi)
app.register_blueprint(authentication_blueprint)