from ...Dependencies.Utilities.util import *
from ...Dependencies.SupportMethods.routes import *
from ...Dependencies.MongoConnect.routes import *


ethisalatApi = Blueprint(
    'ethisalatApi',
    __name__,
    url_prefix=''
)

fqdn = "onlybkt2204.parablu.com"
url_endpoint = "https://"+fqdn+"/paracloud/versions/2.2/msp/orders"
auth_Endpoint = "https://onlybkt2204.parablu.com/paracloud/cloud/onlybkt2204/authenthicate"


errorCodeList = [401,402,403,405,406,407,408,409,410,411,412,416,417,418,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,435,436,437,438]

USERNAME = "AUTO_Pack_Manager"
PASSWORD = "Pass@123"
CLIENTTYPE = "ORDER_CENTER"


class OrderType(Enum):
    New_purchase = "NEW_PURCHASE"
    Upgrade = "UPGRADE"
    Downgrade = "DOWNGRADE"
    Add_Pack = "ADD_PACK"
    Remove_Pack = "REMOVE_PACK"
    Suspend = "SUSPEND"
    Resume = "RESUME"
    Cancel = "CANCEL"


errorCode = {
    'companyName': 401,
    'customerId': 402,
    'orderReferenceNumber': 403,
    'userFirstName': 405,
    'userLastName': 406,
    'userEmail': 407,
    'userPhoneNumber': 408,
    'typeOfPurchase': 409,
    'skuName':410
}

@ethisalatApi.route("/api/v1/ping",methods = ["GET"])
def testBilling():
    my_logger.info("Ping Successful..........................................")
    message = {
            "code":200,
            "message":"successful"
            }
    return jsonify(message),200

@ethisalatApi.route("/api/v1/verifyToken",methods = ["GET"])
def verifyToken():
    my_logger.info("...........Line 47")
    api_key = request.headers.get('X-API-Key')
    apiKeySet = MongoCollectionInstance.getApiKeySet()
    my_logger.info(apiKeySet)
    my_logger.info(".................................apiKeyset")

    my_logger.info("......................the api_key")
    my_logger.info(api_key)
    if not api_key or api_key not in apiKeySet:
        apiResponse = {
            "message":'Invalid API Key',
            "code":501
        }
        return jsonify(apiResponse), 501
    
    apiKeyTime = MongoCollectionInstance.getApiTimeStamp(api_key)
    if isTimestampExpiry(apiKeyTime):
        MongoCollectionInstance.removeApiKey(api_key)
        apiResponse = {
            "message":'API Key Expired',
            "code":502
        }
        return jsonify(apiResponse), 502

    returnResponse = {
            "message":'API Key Expired',
            "code":502
        }
    

    my_logger.info(".............Verify token")
    return jsonify({"code":200,"message" : "Api Verification Successfull"}), 200


def get_encrypt_password(password):
    cipher = 'aes-128-cbc'
    
    # Since md5().digest() in Python returns bytes, no need to set $raw_output=true like in PHP's md5
    key = md5('a9985ebcae81'.encode()).digest()
    
    # AES.block_size is the block size of the AES cipher, equivalent to openssl_cipher_iv_length in PHP
    iv_length = AES.block_size
    
    iv = get_random_bytes(iv_length)

    # Creating the cipher config similar to openssl_encrypt
    cipher = AES.new(key, AES.MODE_CBC, iv)
    
    # Padding password to make sure it's a multiple of block_size
    padding_length = iv_length - (len(password) % iv_length)
    padded_password = password + chr(padding_length) * padding_length

    # Encrypting the password
    ciphertext = cipher.encrypt(padded_password.encode())
    
    # Concatenating the IV with the ciphertext like in PHP
    composed = iv + ciphertext

    # Encoding the result to base64 like base64_encode in PHP
    composed_encoded = b64encode(composed).decode('utf-8')  # decode to convert bytes to string

    return composed_encoded


@ethisalatApi.route("/api/v1/generateToken",methods = ["GET"])
def generateToken():
    headers = {
        "Content-Type": "application/json",
        "userName":USERNAME,
        "password":get_encrypt_password(PASSWORD),
        "clientType":CLIENTTYPE
    }

    print("Headers .........")
    print(headers)
    try:
        my_logger.info("Before calling response")
        response = requests.get(auth_Endpoint, headers=headers,timeout = 20)
        my_logger.info(response)
        my_logger.info("..................................................LINE 137")
        if response.status_code == 202:
            responseHeaders = response.headers
            token = responseHeaders['token']
            responseMessage = {
                "token" : token,
                "code" : 200,
                "message": "API Key generated successfully"
            }
            return jsonify(responseMessage),200
        
        elif response.status_code == 400:
            responseMessage = {
                "code" : 400,
                "message": "Authentication Failed"
            }
            return jsonify(responseMessage),400

        else:
            responseJson = {
            "code":400,
            "message": 'Failed in authentication'
        }
        return jsonify(responseJson), 400
    except Exception as e:
        print(e)
        responseJson = {
            "code":405,
            "message": e
        }
        return jsonify(responseJson), 405




@ethisalatApi.route("/api/v1/generateApiKey",methods = ["GET"])
def generateApiKey():
    my_logger.info("This is line 88")

    username = request.headers.get('Username')
    password = request.headers.get('Password')
    if not username or not password:
        responseJson = {
            "code":400,
            "message": 'bad username / password combination'
        }
        return jsonify(responseJson), 400

    my_logger.info(".........................Line 103")
    api_key_length = int(request.args.get('length', 40))
    my_logger.info(api_key_length)
    my_logger.info(".............................LINE 106")
    characters = string.ascii_letters + string.digits
    new_api_key = ''.join(random.choice(characters) for _ in range(api_key_length))
    my_logger.info(new_api_key)
    MongoCollectionInstance.setApiKey(new_api_key,username)
    responseMessage = {
        "token" : new_api_key,
        "code" : 200,
        "message": "API Key generated successfully"
    }
    return jsonify(responseMessage),200

def callPurchaseApi(json_data,api_key):
    my_logger.info("..........................The callpurchaseApi")
    headers = {
        "Content-Type": "application/json",
        "apiKey":api_key
    }
    my_logger.info(".............................BEFORE RESPONSE")
    
    try:
        my_logger.info(".............................................Before the response Lie 114")
        response = requests.post(url_endpoint, data=json_data, headers=headers,timeout = 20)
        my_logger.info(response.text)

        my_logger.info("....................................................After response")
        my_logger.info(".............................AFTER RESPONSE")
        my_logger.info(response)

        response_check = response.json()

        

    except requests.exceptions.Timeout:
        my_logger.info("Request timed out after 15 seconds")
        errorMessage = {
            "code":510,
            "message":"Server reach timeout 15 seconds",
            "error":None
            }

        return errorMessage

    except requests.exceptions.RequestException as e:
        errorMessage = {
            "code":510,
            "message":e,
            "error":None
            }

        return errorMessage

    except Exception as e:
        my_logger.info(e)
        my_logger.info("....................................EXCEPTION E")
        errorMessage = {
            "code":510,
            "message":"Failed in reaching the ethisalat server",
            "error":None
            }

        return errorMessage

    my_logger.info("......................................LINE 106")
    if response.status_code == 200:
        responseStatus = {
            "code":200, 
            "message":"Success",
            "error":None
        }
        return responseStatus
    


    #my_logger.info("........................................Line 117")
    elif response.status_code == 400:
        responseStatus = {
            "code":400, 
            "message":"Internal Server Issue",
            "error":"Internal"
        }
        return responseStatus
    
    elif response.status_code not in errorCodeList:
        my_logger.info(response.text)
        my_logger.info("..............Response")
        response_data = response.json()

        if "orderResponse" in response_data:
            statusMessage = response_data["orderResponse"]["orderStatus"]["statusMessage"]
            responseStatus = {
                "code":response.status_code, 
                "message":statusMessage,
                "error":"Internal"
            }
            return responseStatus
        else:
            responseStatus = {
                "code":500,
                "message":"Issue with the Internal API call",
                "error":"Internal"
            }
            return responseStatus

        
    else:
        my_logger.info("------------------------------------------------THIS is line 294")
        response_data = response.json()
        my_logger.info(response_data)
        errorMessage = response_data["orderResponse"]["orderStatus"]["statusMessage"]
        responseStatus = {
            "code":response.status_code, 
            "message":errorMessage,
            "error":"External"
        }
        return responseStatus


@ethisalatApi.route("/api/v1/purchaseOrder",methods=['POST','GET'])
def validateApi():
    api_key = request.headers.get('X-API-Key')
    actionType = request.headers.get('X-Action-Type')
    apiKeySet = MongoCollectionInstance.getApiKeySet()

    if not api_key:
        apiResponse = {
            "message":'Invalid API Key',
            "code":501
        }
        return jsonify(apiResponse), 501

    missingFields = []
    
    json_data = request.get_json()
    companyName = json_data.get('companyName')
    if companyName is None or companyName == "":
        missingFields.append("companyName")

    customerId = json_data.get('customerId')
    if customerId is None or customerId == "":
        missingFields.append("customerId")

    orderReferenceNumber = json_data.get('orderReferenceNumber')
    if orderReferenceNumber is None or orderReferenceNumber == "":
        missingFields.append("orderReferenceNumber")


    userFirstName = json_data.get("userFirstName")
    if userFirstName is None or userFirstName == "":
        missingFields.append("userFirstName")

    userLastName = json_data.get("userLastName")
    if userLastName is None or userLastName =="":
        missingFields.append("userLastName")

    userEmail = json_data.get("userEmail")
    if userEmail is None or userEmail == "":
        missingFields.append("userEmail")

    userPhoneNumber = json_data.get("userPhoneNumber")
    if userPhoneNumber is None or userPhoneNumber == "":
        missingFields.append("userPhoneNumber")

    typeOfPurchase = json_data.get("typeOfPurchase")
    if typeOfPurchase is None or typeOfPurchase == "":
        missingFields.append("typeOfPurchase")

    skuCode = json_data.get("skuCode")
    if skuCode is None or skuCode == "":
        missingFields.append("skuCode")


    if len(missingFields) == 1:
        missingErrorCode = errorCode.get(missingFields[0])
        responseMessage = {
            "code" : missingErrorCode,
            'message': f"Error: Missing field {missingFields[0]}"
        }
        return jsonify(responseMessage), missingErrorCode
    
    elif len(missingFields) > 1:
        responseMessage = {
                "code" : 411,
                'message': f"Error: Missing fields {', '.join(missingFields)}"
            }
        return jsonify(responseMessage), 411

    if typeOfPurchase.upper() == "NEW_PURCHASE":
        purchaseType = OrderType.New_purchase
    elif typeOfPurchase.upper() == "UPGRADE":
        purchaseType = OrderType.Upgrade

    elif typeOfPurchase.upper() == "DOWNGRADE":
        purchaseType = OrderType.Downgrade
    elif typeOfPurchase.upper() == "ADD_PACK":
        purchaseType = OrderType.Add_Pack
    elif typeOfPurchase.upper() == "REMOVE_PACK":
        purchaseType = OrderType.Remove_Pack
    elif typeOfPurchase.upper() == "SUSPEND":
        purchaseType = OrderType.Suspend
    elif typeOfPurchase.upper() == "CANCEL":
        purchaseType = OrderType.Cancel
    elif typeOfPurchase.upper() == "RESUME":
        purchaseType = OrderType.Resume
    
    else:
        return jsonify({"code":400,"message":"Invalid Product Type"}), 400
    
    if actionType == "validate":
        print("I am in validate ")
        current_date = datetime.now()
        current_timestamp_millis = current_date.timestamp()
        fields = {
        'companyName': companyName,
        'customerId': customerId,
        'referenceNumber': orderReferenceNumber,
        'firstName': userFirstName,
        'lastName': userLastName,
        'email': userEmail,
        'phoneNumber': userPhoneNumber,
        'orderType': purchaseType.value,
        'skuCode':skuCode,
        "actionType" :"validate",
        'validateTime' : current_timestamp_millis,
        'purchaseOrderTime' : None,
        "IsPurchaseOrderPlaced" : False,
        "message":None,
        "apiKey" : api_key
        }

        dataRecieved = json.dumps(fields)
        try:
            apiResult = callPurchaseApi(dataRecieved,api_key)
            fields["message"] = apiResult["message"]
            print(apiResult["code"])

            print("...........................This is line 427")
            if apiResult["code"] != 200:
                my_logger.info("...........................This is line 350")
                my_logger.info(fields)
                #json_data = json.dumps(fields)
                document_id=MongoCollectionInstance.setApiData(fields)
                my_logger.info(".......................Line number 352")
                responseMessage = {
                        "code":apiResult["code"],
                        "message":apiResult.get("message")
                        }
                return jsonify(responseMessage), apiResult["code"]

        except Exception as e:
            my_logger.info(e)
            my_logger.info("...........This is Exception")
            fields["message"] = "Failed in validation Api"
            MongoCollectionInstance.setApiData(fields)
            return jsonify({"message":"Failed in validation Api","code":500}), 500
        
        fields["message"] = "Validation Completed"

        print(".................This came here")

        document_id=MongoCollectionInstance.setApiData(fields)
        MongoCollectionInstance.setApiKeyWithDocumentId(api_key,"AUTO",document_id)
        print(document_id)
        print("...................................document Id")
        message = {
            "message" : "success",
            "code" : 200
        }
        return jsonify(message),200

    elif actionType == "purchase":
        fields = {
        'companyName': companyName,
        'customerId': customerId,
        'referenceNumber': orderReferenceNumber,
        'firstName': userFirstName,
        'lastName': userLastName,
        'email': userEmail,
        'phoneNumber': userPhoneNumber,
        'orderType': purchaseType.value,
        'skuCode':skuCode,
        "actionType" :actionType,
        'validateTime' : 0,
        'purchaseOrderTime' : None,
        "IsPurchaseOrderPlaced" : False,
        "message":None,
        "apiKey" : api_key
        }

        document_id=MongoCollectionInstance.getDocumentIdByApi(api_key)
        print("..................The document id is")
        print(document_id)
        print("...........................................")
        checkModifiedList = MongoCollectionInstance.checkIfFieldsAreModified(fields,document_id)
        if(len(checkModifiedList) > 0):
            error = {
                "Message" : "Field's are modified",
                "FieldModified" : checkModifiedList,
                "ErrorCode":414
            }
            failedList = {
                "message": "Fields are modified"
            }
            MongoCollectionInstance.updateThePurchaseOrder(failedList,document_id)
            return jsonify(error),414

        dataPurchase = json.dumps(fields)

        print(dataPurchase)
        print("..........................DataPOurchase")
        

        my_logger.info("Line number 409.......................")
        try:
            apiResult = callPurchaseApi(dataPurchase,api_key)

            print(apiResult)
            print("...............Line 499")
            # fields["message"] = apiResult["message"]
            if apiResult["code"] != 200:
                failedList = {
                    "message": apiResult['message']
                }
                MongoCollectionInstance.updateThePurchaseOrder(failedList,document_id)
                return jsonify(apiResult), apiResult.get("code")

        except Exception as e:
            print(e)
            failedList = {
                    "message": e
                }
            MongoCollectionInstance.updateThePurchaseOrder(failedList,document_id)
            return jsonify({"message":"Failed in validation Api"}), 400

        

        my_logger.info(".................................Line 430")

        my_logger.info("THE ABOVE OS ")
        current_date = datetime.now()
        current_timestamp_millis = current_date.timestamp()

        fieldsUpdate = {
        'purchaseOrderTime' : current_timestamp_millis,
        "IsPurchaseOrderPlaced" : True
        }

        purchaseOrderUpdate=MongoCollectionInstance.updateThePurchaseOrder(fieldsUpdate,document_id)
        if purchaseOrderUpdate:
            return jsonify({'Error': "Issue in updating the new purchase order"}),500

        finalResponse = {
            'message': "Successfully Placed the Order",
            "code":200
        }
        return jsonify(finalResponse),200
    else:
        return jsonify({'Error': "Invalid Action Type"}),500
    


@ethisalatApi.route("/dashboard")
def dashboard():
    dashboardDetails = []
    dashboardData = MongoCollectionInstance.getApiData()
    for data in dashboardData:
        dashboardDetails.append(data)
    return render_template("/home/tables.html",dashboardDetails = dashboardDetails)



@ethisalatApi.route("/apiDetails",methods = ['POST'])
def apiDetails():
    modalData = {}
    if request.method == 'POST':
        documentId = request.form['userid']
        my_logger.info(".................................Line 560")
        my_logger.info(documentId)
        print(documentId)
        print("..........The above is the Docuement Id")
        apiDetails = MongoCollectionInstance.getParticularApiDetails(documentId)
        # print(apiDetails.get("CustomerName"))
        print(apiDetails)
        my_logger.info(apiDetails)
        my_logger.info("...................................API Details")
        try:
            modalData.update({"Company Name":apiDetails.get("companyName")})
        except Exception as e:
            print(e)
            modalData.update({"Company Name":"N/A"})
        
        try:
            modalData.update({"Customer Id":apiDetails.get("customerId")})
        except Exception as e:
            print(e)
            modalData.update({"Customer Id":"N/A"})

        try:
            modalData.update({"Order Reference Number":apiDetails.get("referenceNumber")})
        except Exception as e:
            print(e)
            modalData.update({"Order Reference Number":"N/A"})

        try:
            modalData.update({"User First Name":apiDetails.get("firstName")})
        except Exception as e:
            print(e)
            modalData.update({"User First Name":"N/A"})

        try:
            modalData.update({"User Last Name":apiDetails.get("lastName")})
        except Exception as e:
            print(e)
            modalData.update({"User Last Name":"N/A"})

        try:
            modalData.update({"User Email Id":apiDetails.get("email")})
        except Exception as e:
            print(e)
            modalData.update({"User Email Id":"N/A"})
        
        try:
            modalData.update({"User Phone Number":apiDetails.get("phoneNumber")})
        except Exception as e:
            print(e)
            modalData.update({"User Phone Number":"N/A"})

        try:
            modalData.update({"Purchase Type":apiDetails.get("orderType")})
        except Exception as e:
            print(e)
            modalData.update({"Purchase Type":"N/A"})
        
        try:
            modalData.update({"SKU name":apiDetails.get("skuCode")})
        except Exception as e:
            print(e)
            modalData.update({"SKU name":"N/A"})

        try:
            modalData.update({"Order Validated On":apiDetails.get("validateTime")})
        except Exception as e:
            print(e)
            modalData.update({"Order Validated On":"N/A"})
        
        my_logger.info("................................Before Order placed time")

        orderPacedTime = timestampToDateTime(apiDetails.get("purchaseOrderTime"))

        my_logger.info("...................................After Order placed time")
        print(orderPacedTime)
        print("..................Order placed time")


        if orderPacedTime== "Declined":
            orderStatus = "Declined"
            orderPlacetime = "-"
        else:
            orderStatus = "Approved"
            orderPlacetime = orderPacedTime


        my_logger.info("..............................................Line 646")
        try:
            modalData.update({"Order Status":orderStatus})
        except:
            modalData.update({"Order Status":"Declined"})


        try:
            modalData.update({"Order Placed Time":orderPlacetime})
        except:
            modalData.update({"Order Status":"-"})

        try:
            message = apiDetails.get("message")
            modalData.update({"message":message})
        except:
            message = "Issue in identifying the problem"
            modalData.update({"message":message})
        

        documentId = apiDetails.get("_id")

        my_logger.info("..................................documentId")
        my_logger.info(documentId)
        my_logger.info(".........................................................................")
        my_logger.info(message)
        my_logger.info(".............................................................................")
        my_logger.info(modalData)
        my_logger.info("..............................................................................")
        my_logger.info(documentId)
    return jsonify({'htmlresponse': render_template('accounts/apiDetails.html',message = message,modalData = modalData,documentId = documentId)})



