import hashlib
from Crypto.Cipher import AES
import base64

def aes_encrypt(password, key_string, cipher_string):
    try:
        # Prepare the key
        key_bytes = hashlib.md5(key_string.encode('utf-8')).digest()
        key_spec = AES.new(key_bytes, AES.MODE_ECB)

        # Pad the password to be a multiple of 16 bytes
        block_size = 16
        padded_password = password + (block_size - len(password) % block_size) * chr(block_size - len(password) % block_size)

        # Encrypt the password
        encrypted_bytes = key_spec.encrypt(padded_password.encode('utf-8'))

        # Encode the encrypted data using Base64
        return base64.b64encode(encrypted_bytes).decode('utf-8')
    except Exception as e:
        print(e)
        return None

# Usage example
password = "parablu123"
key_string = "a9985ebcae81"
cipher_string = "AES/ECB/PKCS5Padding"
encrypted = aes_encrypt(password, key_string, cipher_string)
print("Encrypted:", encrypted)


import requests

AUTHENTICATE_URL = "https://dev-etisalat.parablu.com/paracloud/cloud/dev-etisalat/authenthicate"
USERNAME = "AUTO_Pack_Manager"
PASSWORD = "Pass@123"
CLIENTTYPE = "ORDER_CENTER"

headers = {
    "userName": USERNAME,
    "password": PASSWORD,
    "clientType":CLIENTTYPE
}

try:
    response = requests.get(AUTHENTICATE_URL, headers=headers)
    response.raise_for_status()  # Raise an exception for HTTP errors (4xx and 5xx)
    authenticate_response = response.text
    print("Authentication Response:", authenticate_response)
except requests.exceptions.RequestException as e:
    print("Error:", e)
