from ...Dependencies.Utilities.util import *
from ...Dependencies.SupportMethods.routes import *
from ...Dependencies.MongoConnect.routes import *
from BillingApi import *


authentication_blueprint = Blueprint(
    'authentication_blueprint',
    __name__,
    url_prefix=''
)

class LoginForm(FlaskForm):
    username = StringField('Username', validators=[DataRequired()])
    password = PasswordField('Password', validators=[DataRequired()])

class RegistrationForm(FlaskForm):
    username = StringField('Username', validators=[DataRequired(), Length(min=4, max=20)])
    email = StringField('Email', validators=[DataRequired(), Email()])
    password = PasswordField('Password', validators=[DataRequired(), Length(min=8)])

@authentication_blueprint.route('/login', methods=['GET', 'POST'])
def login():
    msg = None
    form = LoginForm()
    if request.method == 'POST':
        # Process login form data here
        username = request.form['username']
        password = request.form['password']
        user = userTable.find_one({"email": username})
        if(userTable.find_one({"email": username}) is not None):
            if user and bcrypt.check_password_hash(user['password'], password):   
                session['logged_in'] = True
                session['username'] = user['username']
                session['logged_in_at'] = datetime.now().timestamp()
                flash('You have been logged in!', 'success')
                return redirect(url_for('ethisalatApi.dashboard'))
            else:
                flash("Password didn't match","warning")
                return redirect(url_for('authentication_blueprint.login'))

        elif(userTable.find_one({"username": username}) is not None):
            user = userTable.find_one({"username": username})
            if user and bcrypt.check_password_hash(user['password'], password):
                session['logged_in'] = True
                session['username'] = user['username']
                session['logged_in_at'] = datetime.now().timestamp()
                flash('You have been logged in!', 'success')
                return redirect(url_for('ethisalatApi.dashboard'))
            else:
                flash("Password didn't match","warning")
                return redirect(url_for('authentication_blueprint.login'))

        else:
            msg = "Account not found!!!"
            return redirect(url_for('authentication_blueprint.login',msg = msg))
    return render_template('accounts/login.html', msg=msg,form=form)


@authentication_blueprint.route('/register', methods=['GET', 'POST'])
def register():
    form = RegistrationForm()
    if request.method == 'POST':
        username = request.form['username']
        email = request.form['email']
        password = request.form['password']
            # return redirect(url_for('login'))
        if userTable.find_one({'$or': [{'username': username}, {'email': email}]}):
            user_exists = "User Already Existed"
            return redirect(url_for('authentication_blueprint.register',msg = user_exists))

        hashed_password = bcrypt.generate_password_hash(password).decode('utf-8')
        user_details = {
            'username': username,
            'email': email,
            'password': hashed_password
        }

        userTable.insert_one(user_details)
        flash("Account Successfully Created")
        return redirect(url_for('authentication_blueprint.login',msg = "Account Successfully Created"))
    return render_template('accounts/register.html',form=form)


@authentication_blueprint.route('/logout')
def logout():
    if session.get('logged_in'):
        user = userTable.find_one({"username": session['username']})
        session.pop('username', None)
        session.clear()
        flash("You have been logged out!", "healthy")
    return redirect(url_for('authentication_blueprint.login'))