/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.base.Optional;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.UltraDNSWSError;
import org.jclouds.util.SaxUtils;

public class UltraWSExceptionHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<UltraDNSWSError> {
    private StringBuilder currentText = new StringBuilder();
    private int code = -1;
    private String description;

    @Override
    public UltraDNSWSError getResult() {
        return this.code != -1 ? UltraDNSWSError.fromCodeAndDescription(this.code, Optional.fromNullable(this.description)) : null;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "errorCode")) {
            this.code = Integer.parseInt(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "errorDescription")) {
            this.description = SaxUtils.currentOrNull(this.currentText);
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

