/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.ultradns.ws.domain.TrafficControllerPoolRecord;

public final class TrafficControllerPoolRecordDetail {
    private final String id;
    private final String poolId;
    private final TrafficControllerPoolRecord record;
    private final int weight;
    private final int priority;
    private final String forceAnswer;
    private final boolean probingEnabled;
    private final Status status;
    private final boolean serving;
    private final String description;

    private TrafficControllerPoolRecordDetail(String id, String poolId, TrafficControllerPoolRecord record, int weight, int priority, String forceAnswer, boolean probingEnabled, Status status, boolean serving, String description) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.poolId = Preconditions.checkNotNull(poolId, "poolId for %s", (Object)id);
        this.record = Preconditions.checkNotNull(record, "record for %s", (Object)poolId);
        Preconditions.checkArgument(weight >= 0, "weight of %s must be >= 0", (Object)id);
        this.weight = weight;
        Preconditions.checkArgument(priority >= 0, "priority of %s must be >= 0", (Object)id);
        this.priority = priority;
        this.forceAnswer = Preconditions.checkNotNull(forceAnswer, "forceAnswer for %s", (Object)poolId);
        this.probingEnabled = probingEnabled;
        this.status = Preconditions.checkNotNull(status, "status for %s", (Object)poolId);
        this.serving = serving;
        this.description = Preconditions.checkNotNull(description, "description for %s", (Object)poolId);
    }

    public String getId() {
        return this.id;
    }

    public String getPoolId() {
        return this.poolId;
    }

    public TrafficControllerPoolRecord getRecord() {
        return this.record;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getForceAnswer() {
        return this.forceAnswer;
    }

    public boolean isProbingEnabled() {
        return this.probingEnabled;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isServing() {
        return this.serving;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.poolId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrafficControllerPoolRecordDetail that = (TrafficControllerPoolRecordDetail)TrafficControllerPoolRecordDetail.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.poolId, that.poolId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("poolId", this.poolId).add("record", this.record).add("weight", this.weight).add("priority", this.priority).add("forceAnswer", this.forceAnswer).add("probingEnabled", this.probingEnabled).add("status", (Object)this.status).add("serving", this.serving).add("description", this.description).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return TrafficControllerPoolRecordDetail.builder().from(this);
    }

    public static final class Builder {
        private String id;
        private String poolId;
        private TrafficControllerPoolRecord record;
        private int weight;
        private int priority;
        private String forceAnswer;
        private boolean probingEnabled;
        private Status status;
        private boolean serving;
        private String description;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public Builder record(TrafficControllerPoolRecord record) {
            this.record = record;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder forceAnswer(String forceAnswer) {
            this.forceAnswer = forceAnswer;
            return this;
        }

        public Builder probingEnabled(boolean probingEnabled) {
            this.probingEnabled = probingEnabled;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder serving(boolean serving) {
            this.serving = serving;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public TrafficControllerPoolRecordDetail build() {
            return new TrafficControllerPoolRecordDetail(this.id, this.poolId, this.record, this.weight, this.priority, this.forceAnswer, this.probingEnabled, this.status, this.serving, this.description);
        }

        public Builder from(TrafficControllerPoolRecordDetail in) {
            return this.id(in.id).poolId(in.poolId).weight(in.weight).record(in.record).priority(in.priority).forceAnswer(in.forceAnswer).probingEnabled(in.probingEnabled).status(in.status).serving(in.serving).description(in.description);
        }
    }

    public static enum Status {
        OK,
        WARNING,
        CRITICAL,
        FAILURE,
        DISABLED,
        UNRECOGNIZED;


        public static Status fromValue(String status) {
            try {
                return Status.valueOf(Preconditions.checkNotNull(status, "status").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

