/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class TrafficControllerPoolRecord {
    private final String type;
    private final String rdata;

    public static TrafficControllerPoolRecord createA(String rdata) {
        return new TrafficControllerPoolRecord("A", rdata);
    }

    public static TrafficControllerPoolRecord createCNAME(String rdata) {
        return new TrafficControllerPoolRecord("CNAME", rdata);
    }

    public static TrafficControllerPoolRecord create(String type, String rdata) {
        return new TrafficControllerPoolRecord(type, rdata);
    }

    private TrafficControllerPoolRecord(String type, String rdata) {
        this.type = Preconditions.checkNotNull(type, "type");
        this.rdata = Preconditions.checkNotNull(rdata, "rdata");
    }

    public String getType() {
        return this.type;
    }

    public String getRData() {
        return this.rdata;
    }

    public int hashCode() {
        return Objects.hashCode(this.type, this.rdata);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrafficControllerPoolRecord that = (TrafficControllerPoolRecord)TrafficControllerPoolRecord.class.cast(obj);
        return Objects.equal(this.type, that.type) && Objects.equal(this.rdata, that.rdata);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", this.type).add("rdata", this.rdata).toString();
    }
}

