/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class TrafficControllerPool {
    private final String zoneId;
    private final String id;
    private final String name;
    private final String dname;
    private final int statusCode;
    private final boolean failOverEnabled;
    private final boolean probingEnabled;

    private TrafficControllerPool(String zoneId, String id, String name, String dname, int statusCode, boolean failOverEnabled, boolean probingEnabled) {
        this.zoneId = Preconditions.checkNotNull(zoneId, "zoneId");
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = Preconditions.checkNotNull(name, "name for %s", (Object)id);
        this.dname = Preconditions.checkNotNull(dname, "dname for %s", (Object)id);
        this.statusCode = statusCode;
        this.failOverEnabled = failOverEnabled;
        this.probingEnabled = probingEnabled;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDName() {
        return this.dname;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isFailOverEnabled() {
        return this.failOverEnabled;
    }

    public boolean isProbingEnabled() {
        return this.probingEnabled;
    }

    public int hashCode() {
        return Objects.hashCode(this.zoneId, this.id, this.name, this.dname);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrafficControllerPool that = (TrafficControllerPool)TrafficControllerPool.class.cast(obj);
        return Objects.equal(this.zoneId, that.zoneId) && Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.dname, that.dname);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("zoneId", this.zoneId).add("id", this.id).add("name", this.name).add("dname", this.dname).add("status", this.statusCode).add("failOverEnabled", this.failOverEnabled).add("probingEnabled", this.probingEnabled).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return TrafficControllerPool.builder().from(this);
    }

    public static final class Builder {
        private String zoneId;
        private String id;
        private String name;
        private String dname;
        private int statusCode;
        private boolean failOverEnabled;
        private boolean probingEnabled;

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder dname(String dname) {
            this.dname = dname;
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder failOverEnabled(boolean failOverEnabled) {
            this.failOverEnabled = failOverEnabled;
            return this;
        }

        public Builder probingEnabled(boolean probingEnabled) {
            this.probingEnabled = probingEnabled;
            return this;
        }

        public TrafficControllerPool build() {
            return new TrafficControllerPool(this.zoneId, this.id, this.name, this.dname, this.statusCode, this.failOverEnabled, this.probingEnabled);
        }

        public Builder from(TrafficControllerPool in) {
            return this.zoneId(in.zoneId).id(in.id).name(in.name).dname(in.dname).statusCode(in.statusCode).failOverEnabled(in.failOverEnabled).probingEnabled(in.probingEnabled);
        }
    }

    public static enum RecordType {
        IPV4(1),
        IPV6(28);

        private final int code;

        public String toString() {
            return String.valueOf(this.code);
        }

        private RecordType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

