/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;

public class DirectionalGroup
extends ForwardingMultimap<String, String> {
    private final String name;
    private final Optional<String> description;
    private final Multimap<String, String> regionToTerritories;

    private DirectionalGroup(String name, Optional<String> description, Multimap<String, String> regionToTerritories) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.description = Preconditions.checkNotNull(description, "description of %s", (Object)name);
        this.regionToTerritories = Preconditions.checkNotNull(regionToTerritories, "regionToTerritories of %s", (Object)name);
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Multimap<String, String> getRegionToTerritories() {
        return this.regionToTerritories;
    }

    @Override
    protected Multimap<String, String> delegate() {
        return this.regionToTerritories;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.name, this.regionToTerritories);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DirectionalGroup that = (DirectionalGroup)DirectionalGroup.class.cast(obj);
        return Objects.equal(this.name, that.name) && Objects.equal(this.regionToTerritories, that.regionToTerritories);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("description", this.description.orNull()).add("regionToTerritories", this.regionToTerritories).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return DirectionalGroup.builder().from(this);
    }

    public static final class Builder {
        private String name;
        private Optional<String> description = Optional.absent();
        private ImmutableMultimap.Builder<String, String> regionToTerritories = ImmutableMultimap.builder();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.fromNullable(description);
            return this;
        }

        public Builder mapRegionToTerritories(String region, Iterable<String> territories) {
            this.regionToTerritories.putAll(region, territories);
            return this;
        }

        public Builder mapRegionToTerritory(String region, String territory) {
            this.regionToTerritories.put(region, territory);
            return this;
        }

        public Builder mapRegion(String region) {
            this.regionToTerritories.put(region, "all");
            return this;
        }

        public Builder regionToTerritories(Multimap<String, String> regionToTerritories) {
            this.regionToTerritories = ImmutableMultimap.builder().putAll(regionToTerritories);
            return this;
        }

        public DirectionalGroup build() {
            return new DirectionalGroup(this.name, this.description, this.regionToTerritories.build());
        }

        public Builder from(DirectionalGroup in) {
            return this.name(in.getName()).regionToTerritories(in.getRegionToTerritories());
        }
    }
}

