/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.OperatingSystem;
import org.jclouds.softlayer.domain.PowerState;
import org.jclouds.softlayer.domain.SecuritySshKey;
import org.jclouds.softlayer.domain.SoftwareLicense;
import org.jclouds.softlayer.domain.TagReference;
import org.jclouds.softlayer.domain.VirtualGuestAttribute;
import org.jclouds.softlayer.domain.VirtualGuestBlockDevice;
import org.jclouds.softlayer.domain.VirtualGuestBlockDeviceTemplateGroup;
import org.jclouds.softlayer.domain.VirtualGuestNetworkComponent;

public class VirtualGuest {
    private final int accountId;
    private final Date createDate;
    private final String domain;
    private final String fullyQualifiedDomainName;
    private final String hostname;
    private final int id;
    private final Date lastVerifiedDate;
    private final int maxCpu;
    private final String maxCpuUnits;
    private final int maxMemory;
    private final Date metricPollDate;
    private final Date modifyDate;
    private final String notes;
    private final int startCpus;
    private final int statusId;
    private final String uuid;
    private final String primaryBackendIpAddress;
    private final String primaryIpAddress;
    private final int billingItemId;
    private final OperatingSystem operatingSystem;
    private final String operatingSystemReferenceCode;
    private final Datacenter datacenter;
    private final PowerState powerState;
    private final SoftwareLicense softwareLicense;
    private final int activeTransactionCount;
    private final List<VirtualGuestBlockDevice> blockDevices;
    private final boolean hourlyBillingFlag;
    private final boolean localDiskFlag;
    private final boolean dedicatedAccountHostOnlyFlag;
    private final boolean privateNetworkOnlyFlag;
    private final VirtualGuestBlockDeviceTemplateGroup blockDeviceTemplateGroup;
    private final Set<VirtualGuestNetworkComponent> networkComponents;
    private final Set<TagReference> tagReferences;
    private final VirtualGuestNetworkComponent primaryNetworkComponent;
    private final VirtualGuestNetworkComponent primaryBackendNetworkComponent;
    private final String postInstallScriptUri;
    private final VirtualGuestAttribute virtualGuestAttribute;
    private final Set<SecuritySshKey> sshKeys;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVirtualGuest(this);
    }

    @ConstructorProperties(value={"accountId", "createDate", "domain", "fullyQualifiedDomainName", "hostname", "id", "lastVerifiedDate", "maxCpu", "maxCpuUnits", "maxMemory", "metricPollDate", "modifyDate", "notes", "startCpus", "statusId", "uuid", "primaryBackendIpAddress", "primaryIpAddress", "billingItem", "operatingSystem", "operatingSystemReferenceCode", "datacenter", "powerState", "softwareLicense", "activeTransactionCount", "blockDevices", "hourlyBillingFlag", "localDiskFlag", "dedicatedAccountHostOnlyFlag", "privateNetworkOnlyFlag", "blockDeviceTemplateGroup", "networkComponents", "tagReferences", "primaryNetworkComponent", "primaryBackendNetworkComponent", "postInstallScriptUri", "virtualGuestAttribute", "sshKeys"})
    protected VirtualGuest(int accountId, @Nullable Date createDate, @Nullable String domain, @Nullable String fullyQualifiedDomainName, @Nullable String hostname, int id, @Nullable Date lastVerifiedDate, int maxCpu, @Nullable String maxCpuUnits, int maxMemory, @Nullable Date metricPollDate, @Nullable Date modifyDate, @Nullable String notes, int startCpus, int statusId, @Nullable String uuid, @Nullable String primaryBackendIpAddress, @Nullable String primaryIpAddress, @Nullable BillingItem billingItem, @Nullable OperatingSystem operatingSystem, @Nullable String operatingSystemReferenceCode, @Nullable Datacenter datacenter, @Nullable PowerState powerState, @Nullable SoftwareLicense softwareLicense, int activeTransactionCount, @Nullable List<VirtualGuestBlockDevice> blockDevices, boolean hourlyBillingFlag, boolean localDiskFlag, boolean dedicatedAccountHostOnlyFlag, boolean privateNetworkOnlyFlag, @Nullable VirtualGuestBlockDeviceTemplateGroup blockDeviceTemplateGroup, @Nullable Set<VirtualGuestNetworkComponent> networkComponents, @Nullable Set<TagReference> tagReferences, @Nullable VirtualGuestNetworkComponent primaryNetworkComponent, @Nullable VirtualGuestNetworkComponent primaryBackendNetworkComponent, @Nullable String postInstallScriptUri, @Nullable VirtualGuestAttribute virtualGuestAttribute, @Nullable Set<SecuritySshKey> sshKeys) {
        this.accountId = accountId;
        this.createDate = createDate;
        this.domain = domain;
        this.fullyQualifiedDomainName = fullyQualifiedDomainName;
        this.hostname = hostname;
        this.id = id;
        this.lastVerifiedDate = lastVerifiedDate;
        this.maxCpu = maxCpu;
        this.maxCpuUnits = maxCpuUnits;
        this.maxMemory = maxMemory;
        this.metricPollDate = metricPollDate;
        this.modifyDate = modifyDate;
        this.notes = notes;
        this.startCpus = startCpus;
        this.statusId = statusId;
        this.uuid = uuid;
        this.primaryBackendIpAddress = primaryBackendIpAddress;
        this.primaryIpAddress = primaryIpAddress;
        this.blockDevices = blockDevices;
        this.billingItemId = billingItem == null ? 0 : billingItem.id;
        this.operatingSystem = operatingSystem;
        this.operatingSystemReferenceCode = operatingSystemReferenceCode;
        this.datacenter = datacenter;
        this.powerState = powerState;
        this.softwareLicense = softwareLicense;
        this.activeTransactionCount = activeTransactionCount;
        this.hourlyBillingFlag = hourlyBillingFlag;
        this.localDiskFlag = localDiskFlag;
        this.dedicatedAccountHostOnlyFlag = dedicatedAccountHostOnlyFlag;
        this.privateNetworkOnlyFlag = privateNetworkOnlyFlag;
        this.blockDeviceTemplateGroup = blockDeviceTemplateGroup;
        this.networkComponents = networkComponents;
        this.tagReferences = tagReferences;
        this.primaryNetworkComponent = primaryNetworkComponent;
        this.primaryBackendNetworkComponent = primaryBackendNetworkComponent;
        this.postInstallScriptUri = postInstallScriptUri;
        this.virtualGuestAttribute = virtualGuestAttribute;
        this.sshKeys = sshKeys;
    }

    public int getAccountId() {
        return this.accountId;
    }

    @Nullable
    public Date getCreateDate() {
        return this.createDate;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getFullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public Date getLastVerifiedDate() {
        return this.lastVerifiedDate;
    }

    public int getMaxCpu() {
        return this.maxCpu;
    }

    @Nullable
    public String getMaxCpuUnits() {
        return this.maxCpuUnits;
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    @Nullable
    public Date getMetricPollDate() {
        return this.metricPollDate;
    }

    @Nullable
    public Date getModifyDate() {
        return this.modifyDate;
    }

    @Nullable
    public String getNotes() {
        return this.notes;
    }

    public int getStartCpus() {
        return this.startCpus;
    }

    public int getStatusId() {
        return this.statusId;
    }

    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    @Nullable
    public String getPrimaryBackendIpAddress() {
        return this.primaryBackendIpAddress;
    }

    @Nullable
    public String getPrimaryIpAddress() {
        return this.primaryIpAddress;
    }

    public int getBillingItemId() {
        return this.billingItemId;
    }

    @Nullable
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getOperatingSystemReferenceCode() {
        return this.operatingSystemReferenceCode;
    }

    @Nullable
    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    @Nullable
    public SoftwareLicense getSoftwareLicense() {
        return this.softwareLicense;
    }

    @Nullable
    public PowerState getPowerState() {
        return this.powerState;
    }

    public int getActiveTransactionCount() {
        return this.activeTransactionCount;
    }

    @Nullable
    public List<VirtualGuestBlockDevice> getVirtualGuestBlockDevices() {
        return this.blockDevices;
    }

    public boolean isHourlyBillingFlag() {
        return this.hourlyBillingFlag;
    }

    public boolean isLocalDiskFlag() {
        return this.localDiskFlag;
    }

    public boolean isPrivateNetworkOnly() {
        return this.privateNetworkOnlyFlag;
    }

    public boolean isDedicatedAccountHostOnly() {
        return this.dedicatedAccountHostOnlyFlag;
    }

    public VirtualGuestBlockDeviceTemplateGroup getVirtualGuestBlockDeviceTemplateGroup() {
        return this.blockDeviceTemplateGroup;
    }

    @Nullable
    public Set<VirtualGuestNetworkComponent> getVirtualGuestNetworkComponents() {
        return this.networkComponents;
    }

    @Nullable
    public Set<TagReference> getTagReferences() {
        return this.tagReferences;
    }

    public VirtualGuestNetworkComponent getPrimaryNetworkComponent() {
        return this.primaryNetworkComponent;
    }

    public VirtualGuestNetworkComponent getPrimaryBackendNetworkComponent() {
        return this.primaryBackendNetworkComponent;
    }

    public String getPostInstallScriptUri() {
        return this.postInstallScriptUri;
    }

    public VirtualGuestAttribute getVirtualGuestAttribute() {
        return this.virtualGuestAttribute;
    }

    public Set<SecuritySshKey> getSshKeys() {
        return this.sshKeys;
    }

    public int hashCode() {
        return Objects.hashCode(this.accountId, this.createDate, this.domain, this.fullyQualifiedDomainName, this.hostname, this.id, this.lastVerifiedDate, this.maxCpu, this.maxCpuUnits, this.maxMemory, this.metricPollDate, this.modifyDate, this.notes, this.startCpus, this.statusId, this.uuid, this.primaryBackendIpAddress, this.primaryIpAddress, this.billingItemId, this.operatingSystem, this.datacenter, this.powerState, this.softwareLicense, this.blockDevices, this.hourlyBillingFlag, this.localDiskFlag, this.dedicatedAccountHostOnlyFlag, this.privateNetworkOnlyFlag, this.blockDeviceTemplateGroup, this.tagReferences, this.primaryNetworkComponent, this.primaryBackendNetworkComponent, this.postInstallScriptUri, this.virtualGuestAttribute, this.sshKeys);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualGuest that = (VirtualGuest)VirtualGuest.class.cast(obj);
        return Objects.equal(this.accountId, that.accountId) && Objects.equal(this.createDate, that.createDate) && Objects.equal(this.domain, that.domain) && Objects.equal(this.fullyQualifiedDomainName, that.fullyQualifiedDomainName) && Objects.equal(this.hostname, that.hostname) && Objects.equal(this.id, that.id) && Objects.equal(this.lastVerifiedDate, that.lastVerifiedDate) && Objects.equal(this.maxCpu, that.maxCpu) && Objects.equal(this.maxCpuUnits, that.maxCpuUnits) && Objects.equal(this.maxMemory, that.maxMemory) && Objects.equal(this.metricPollDate, that.metricPollDate) && Objects.equal(this.modifyDate, that.modifyDate) && Objects.equal(this.notes, that.notes) && Objects.equal(this.startCpus, that.startCpus) && Objects.equal(this.statusId, that.statusId) && Objects.equal(this.uuid, that.uuid) && Objects.equal(this.primaryBackendIpAddress, that.primaryBackendIpAddress) && Objects.equal(this.primaryIpAddress, that.primaryIpAddress) && Objects.equal(this.billingItemId, that.billingItemId) && Objects.equal(this.operatingSystem, that.operatingSystem) && Objects.equal(this.operatingSystemReferenceCode, that.operatingSystemReferenceCode) && Objects.equal(this.datacenter, that.datacenter) && Objects.equal(this.powerState, that.powerState) && Objects.equal(this.softwareLicense, that.softwareLicense) && Objects.equal(this.blockDevices, that.blockDevices) && Objects.equal(this.hourlyBillingFlag, that.hourlyBillingFlag) && Objects.equal(this.localDiskFlag, that.localDiskFlag) && Objects.equal(this.dedicatedAccountHostOnlyFlag, that.dedicatedAccountHostOnlyFlag) && Objects.equal(this.privateNetworkOnlyFlag, that.privateNetworkOnlyFlag) && Objects.equal(this.blockDeviceTemplateGroup, that.blockDeviceTemplateGroup) && Objects.equal(this.networkComponents, that.networkComponents) && Objects.equal(this.tagReferences, that.tagReferences) && Objects.equal(this.sshKeys, that.sshKeys);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountId", this.accountId).add("createDate", this.createDate).add("domain", this.domain).add("fullyQualifiedDomainName", this.fullyQualifiedDomainName).add("hostname", this.hostname).add("id", this.id).add("lastVerifiedDate", this.lastVerifiedDate).add("maxCpu", this.maxCpu).add("maxCpuUnits", this.maxCpuUnits).add("maxMemory", this.maxMemory).add("metricPollDate", this.metricPollDate).add("modifyDate", this.modifyDate).add("notes", this.notes).add("startCpus", this.startCpus).add("statusId", this.statusId).add("uuid", this.uuid).add("primaryBackendIpAddress", this.primaryBackendIpAddress).add("primaryIpAddress", this.primaryIpAddress).add("billingItemId", this.billingItemId).add("operatingSystem", this.operatingSystem).add("operatingSystemReferenceCode", this.operatingSystemReferenceCode).add("datacenter", this.datacenter).add("powerState", this.powerState).add("softwareLicense", this.softwareLicense).add("activeTransactionCount", this.activeTransactionCount).add("blockDevices", this.blockDevices).add("hourlyBillingFlag", this.hourlyBillingFlag).add("localDiskFlag", this.localDiskFlag).add("dedicatedAccountHostOnlyFlag", this.dedicatedAccountHostOnlyFlag).add("privateNetworkOnlyFlag", this.privateNetworkOnlyFlag).add("blockDeviceTemplateGroup", this.blockDeviceTemplateGroup).add("networkComponents", this.networkComponents).add("tagReferences", this.tagReferences).add("primaryNetworkComponent", this.primaryNetworkComponent).add("primaryBackendNetworkComponent", this.primaryBackendNetworkComponent).add("postInstallScriptUri", this.postInstallScriptUri).add("virtualGuestAttribute", this.virtualGuestAttribute).add("sshKeys", this.sshKeys).toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int accountId;
        protected Date createDate;
        protected String domain;
        protected String fullyQualifiedDomainName;
        protected String hostname;
        protected int id;
        protected Date lastVerifiedDate;
        protected int maxCpu;
        protected String maxCpuUnits;
        protected int maxMemory;
        protected Date metricPollDate;
        protected Date modifyDate;
        protected String notes;
        protected int startCpus;
        protected int statusId;
        protected String uuid;
        protected String primaryBackendIpAddress;
        protected String primaryIpAddress;
        protected int billingItemId;
        protected OperatingSystem operatingSystem;
        protected String operatingSystemReferenceCode;
        protected Datacenter datacenter;
        protected PowerState powerState;
        protected SoftwareLicense softwareLicense;
        protected int activeTransactionCount;
        protected List<VirtualGuestBlockDevice> blockDevices;
        protected boolean hourlyBillingFlag;
        protected boolean localDiskFlag;
        protected boolean dedicatedAccountHostOnlyFlag;
        protected boolean privateNetworkOnlyFlag;
        protected VirtualGuestBlockDeviceTemplateGroup blockDeviceTemplateGroup;
        protected Set<VirtualGuestNetworkComponent> networkComponents;
        protected Set<TagReference> tagReferences;
        protected VirtualGuestNetworkComponent primaryNetworkComponent;
        protected VirtualGuestNetworkComponent primaryBackendNetworkComponent;
        protected String postInstallScriptUri;
        protected VirtualGuestAttribute virtualGuestAttribute;
        protected Set<SecuritySshKey> sshKeys;

        protected abstract T self();

        public T accountId(int accountId) {
            this.accountId = accountId;
            return this.self();
        }

        public T createDate(Date createDate) {
            this.createDate = createDate;
            return this.self();
        }

        public T dedicatedAccountHostOnly(boolean dedicatedAccountHostOnlyFlag) {
            this.dedicatedAccountHostOnlyFlag = dedicatedAccountHostOnlyFlag;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T fullyQualifiedDomainName(String fullyQualifiedDomainName) {
            this.fullyQualifiedDomainName = fullyQualifiedDomainName;
            return this.self();
        }

        public T hostname(String hostname) {
            this.hostname = hostname;
            return this.self();
        }

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T lastVerifiedDate(Date lastVerifiedDate) {
            this.lastVerifiedDate = lastVerifiedDate;
            return this.self();
        }

        public T maxCpu(int maxCpu) {
            this.maxCpu = maxCpu;
            return this.self();
        }

        public T maxCpuUnits(String maxCpuUnits) {
            this.maxCpuUnits = maxCpuUnits;
            return this.self();
        }

        public T maxMemory(int maxMemory) {
            this.maxMemory = maxMemory;
            return this.self();
        }

        public T metricPollDate(Date metricPollDate) {
            this.metricPollDate = metricPollDate;
            return this.self();
        }

        public T modifyDate(Date modifyDate) {
            this.modifyDate = modifyDate;
            return this.self();
        }

        public T notes(String notes) {
            this.notes = notes;
            return this.self();
        }

        public T startCpus(int startCpus) {
            this.startCpus = startCpus;
            return this.self();
        }

        public T statusId(int statusId) {
            this.statusId = statusId;
            return this.self();
        }

        public T uuid(String uuid) {
            this.uuid = uuid;
            return this.self();
        }

        public T primaryBackendIpAddress(String primaryBackendIpAddress) {
            this.primaryBackendIpAddress = primaryBackendIpAddress;
            return this.self();
        }

        public T primaryIpAddress(String primaryIpAddress) {
            this.primaryIpAddress = primaryIpAddress;
            return this.self();
        }

        public T billingItemId(int billingItemId) {
            this.billingItemId = billingItemId;
            return this.self();
        }

        public T operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this.self();
        }

        public T operatingSystemReferenceCode(String operatingSystemReferenceCode) {
            this.operatingSystemReferenceCode = operatingSystemReferenceCode;
            return this.self();
        }

        public T datacenter(Datacenter datacenter) {
            this.datacenter = datacenter;
            return this.self();
        }

        public T powerState(PowerState powerState) {
            this.powerState = powerState;
            return this.self();
        }

        public T softwareLicense(SoftwareLicense softwareLicense) {
            this.softwareLicense = softwareLicense;
            return this.self();
        }

        public T activeTransactionCount(int activeTransactionCount) {
            this.activeTransactionCount = activeTransactionCount;
            return this.self();
        }

        public T blockDevices(List<VirtualGuestBlockDevice> blockDevices) {
            this.blockDevices = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(blockDevices, "blockDevices"));
            return this.self();
        }

        public T blockDevices(VirtualGuestBlockDevice ... in) {
            return this.blockDevices(ImmutableList.copyOf(Preconditions.checkNotNull(in, "blockDevices")));
        }

        public T hourlyBillingFlag(boolean hourlyBillingFlag) {
            this.hourlyBillingFlag = hourlyBillingFlag;
            return this.self();
        }

        public T localDiskFlag(boolean localDiskFlag) {
            this.localDiskFlag = localDiskFlag;
            return this.self();
        }

        public T dedicatedAccountHostOnlyFlag(boolean dedicatedAccountHostOnlyFlag) {
            this.dedicatedAccountHostOnlyFlag = dedicatedAccountHostOnlyFlag;
            return this.self();
        }

        public T privateNetworkOnlyFlag(boolean privateNetworkOnlyFlag) {
            this.privateNetworkOnlyFlag = privateNetworkOnlyFlag;
            return this.self();
        }

        public T blockDeviceTemplateGroup(VirtualGuestBlockDeviceTemplateGroup blockDeviceTemplateGroup) {
            this.blockDeviceTemplateGroup = blockDeviceTemplateGroup;
            return this.self();
        }

        public T networkComponents(Set<VirtualGuestNetworkComponent> networkComponents) {
            this.networkComponents = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(networkComponents, "networkComponents"));
            return this.self();
        }

        public T networkComponents(VirtualGuestNetworkComponent ... in) {
            return this.networkComponents(ImmutableSet.copyOf(Preconditions.checkNotNull(in, "networkComponents")));
        }

        public T tagReferences(Set<TagReference> tagReferences) {
            this.tagReferences = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(tagReferences, "tagReferences"));
            return this.self();
        }

        public T tagReferences(TagReference ... in) {
            return this.tagReferences(ImmutableSet.copyOf(Preconditions.checkNotNull(in, "tagReferences")));
        }

        public T primaryNetworkComponent(VirtualGuestNetworkComponent primaryNetworkComponent) {
            this.primaryNetworkComponent = primaryNetworkComponent;
            return this.self();
        }

        public T primaryBackendNetworkComponent(VirtualGuestNetworkComponent primaryBackendNetworkComponent) {
            this.primaryBackendNetworkComponent = primaryBackendNetworkComponent;
            return this.self();
        }

        public T postInstallScriptUri(String postInstallScriptUri) {
            this.postInstallScriptUri = postInstallScriptUri;
            return this.self();
        }

        public T virtualGuestAttribute(VirtualGuestAttribute virtualGuestAttribute) {
            this.virtualGuestAttribute = virtualGuestAttribute;
            return this.self();
        }

        public T sshKeys(Set<SecuritySshKey> sshKeys) {
            this.sshKeys = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(sshKeys, "sshKeys"));
            return this.self();
        }

        public T sshKeys(SecuritySshKey ... in) {
            return this.sshKeys(ImmutableSet.copyOf(Preconditions.checkNotNull(in, "sshKeys")));
        }

        public VirtualGuest build() {
            return new VirtualGuest(this.accountId, this.createDate, this.domain, this.fullyQualifiedDomainName, this.hostname, this.id, this.lastVerifiedDate, this.maxCpu, this.maxCpuUnits, this.maxMemory, this.metricPollDate, this.modifyDate, this.notes, this.startCpus, this.statusId, this.uuid, this.primaryBackendIpAddress, this.primaryIpAddress, new BillingItem(this.billingItemId), this.operatingSystem, this.operatingSystemReferenceCode, this.datacenter, this.powerState, this.softwareLicense, this.activeTransactionCount, this.blockDevices, this.hourlyBillingFlag, this.localDiskFlag, this.dedicatedAccountHostOnlyFlag, this.privateNetworkOnlyFlag, this.blockDeviceTemplateGroup, this.networkComponents, this.tagReferences, this.primaryNetworkComponent, this.primaryBackendNetworkComponent, this.postInstallScriptUri, this.virtualGuestAttribute, this.sshKeys);
        }

        public T fromVirtualGuest(VirtualGuest in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.accountId(in.getAccountId())).createDate(in.getCreateDate())).dedicatedAccountHostOnly(in.isDedicatedAccountHostOnly())).domain(in.getDomain())).fullyQualifiedDomainName(in.getFullyQualifiedDomainName())).hostname(in.getHostname())).id(in.getId())).lastVerifiedDate(in.getLastVerifiedDate())).maxCpu(in.getMaxCpu())).maxCpuUnits(in.getMaxCpuUnits())).maxMemory(in.getMaxMemory())).metricPollDate(in.getMetricPollDate())).modifyDate(in.getModifyDate())).notes(in.getNotes())).startCpus(in.getStartCpus())).statusId(in.getStatusId())).uuid(in.getUuid())).primaryBackendIpAddress(in.getPrimaryBackendIpAddress())).primaryIpAddress(in.getPrimaryIpAddress())).billingItemId(in.getBillingItemId())).operatingSystem(in.getOperatingSystem())).operatingSystemReferenceCode(in.getOperatingSystemReferenceCode())).datacenter(in.getDatacenter())).powerState(in.getPowerState())).activeTransactionCount(in.getActiveTransactionCount())).hourlyBillingFlag(in.isHourlyBillingFlag())).localDiskFlag(in.isLocalDiskFlag())).dedicatedAccountHostOnlyFlag(in.isDedicatedAccountHostOnly())).privateNetworkOnlyFlag(in.isPrivateNetworkOnly())).blockDeviceTemplateGroup(in.getVirtualGuestBlockDeviceTemplateGroup())).networkComponents(in.getVirtualGuestNetworkComponents())).tagReferences(in.getTagReferences())).postInstallScriptUri(in.getPostInstallScriptUri())).virtualGuestAttribute(in.getVirtualGuestAttribute())).sshKeys(in.getSshKeys());
        }
    }

    public static class BillingItem {
        private final int id;

        @ConstructorProperties(value={"id"})
        public BillingItem(int id) {
            this.id = id;
        }

        public String toString() {
            return "[id=" + this.id + "]";
        }
    }

    public static enum State {
        HALTED,
        PAUSED,
        RUNNING,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(state, "state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

