/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.handlers;

import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.Uris;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.http.handlers.RedirectionRetryHandler;

@Singleton
public class S3RedirectionRetryHandler
extends RedirectionRetryHandler {
    private final AWSUtils utils;

    @Inject
    public S3RedirectionRetryHandler(BackoffLimitedRetryHandler backoffHandler, AWSUtils utils) {
        super(backoffHandler);
        this.utils = utils;
    }

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        if (response.getFirstHeaderOrNull("Location") == null && (response.getStatusCode() == 301 || response.getStatusCode() == 307)) {
            command.incrementRedirectCount();
            HttpUtils.closeClientButKeepContentStream(response);
            AWSError error = this.utils.parseAWSErrorFromContent(command.getCurrentRequest(), response);
            String host = error.getDetails().get("Endpoint");
            if (host != null) {
                if (host.equals(command.getCurrentRequest().getEndpoint().getHost())) {
                    return this.backoffHandler.shouldRetryRequest(command, response);
                }
                URI newHost = Uris.uriBuilder(command.getCurrentRequest().getEndpoint()).host(host).build();
                command.setCurrentRequest(((HttpRequest.Builder)((HttpRequest.Builder)command.getCurrentRequest().toBuilder()).endpoint(newHost)).build());
                return true;
            }
            return false;
        }
        return super.shouldRetryRequest(command, response);
    }
}

