/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.base.Throwables;
import java.util.Collection;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.s3.binders.XMLHelper;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketLogging;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class BindBucketLoggingToXmlPayload
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        BucketLogging from = (BucketLogging)payload;
        try {
            request.setPayload(this.generatePayload(from));
            request.getPayload().getContentMetadata().setContentType("text/xml");
            return request;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible(e);
            throw new RuntimeException("error transforming bucketLogging: " + from, e);
        }
    }

    private String generatePayload(BucketLogging bucketLogging) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        Document document = XMLHelper.createDocument();
        Element rootNode = XMLHelper.elem(document, "BucketLoggingStatus", document);
        rootNode.setAttribute("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        Element loggingNode = XMLHelper.elem(rootNode, "LoggingEnabled", document);
        XMLHelper.elemWithText(loggingNode, "TargetBucket", bucketLogging.getTargetBucket(), document);
        XMLHelper.elemWithText(loggingNode, "TargetPrefix", bucketLogging.getTargetPrefix(), document);
        BindBucketLoggingToXmlPayload.addGrants(XMLHelper.elem(loggingNode, "TargetGrants", document), bucketLogging.getTargetGrants(), document);
        return XMLHelper.asString(document);
    }

    static void addGrants(Element grantsNode, Collection<AccessControlList.Grant> grants, Document document) {
        for (AccessControlList.Grant grant : grants) {
            Element grantNode = XMLHelper.elem(grantsNode, "Grant", document);
            Element granteeNode = XMLHelper.elem(grantNode, "Grantee", document);
            granteeNode.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (grant.getGrantee() instanceof AccessControlList.GroupGrantee) {
                granteeNode.setAttribute("xsi:type", "Group");
                XMLHelper.elemWithText(granteeNode, "URI", grant.getGrantee().getIdentifier(), document);
            } else if (grant.getGrantee() instanceof AccessControlList.CanonicalUserGrantee) {
                AccessControlList.CanonicalUserGrantee grantee = (AccessControlList.CanonicalUserGrantee)grant.getGrantee();
                granteeNode.setAttribute("xsi:type", "CanonicalUser");
                XMLHelper.elemWithText(granteeNode, "ID", grantee.getIdentifier(), document);
                if (grantee.getDisplayName() != null) {
                    XMLHelper.elemWithText(granteeNode, "DisplayName", grantee.getDisplayName(), document);
                }
            } else if (grant.getGrantee() instanceof AccessControlList.EmailAddressGrantee) {
                granteeNode.setAttribute("xsi:type", "AmazonCustomerByEmail");
                XMLHelper.elemWithText(granteeNode, "EmailAddress", grant.getGrantee().getIdentifier(), document);
            }
            XMLHelper.elemWithText(grantNode, "Permission", grant.getPermission(), document);
        }
    }
}

