/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.filters;

import com.google.common.base.Charsets;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.rest.RequestSigner;

@Singleton
public class RestAuthentication
implements HttpRequestFilter,
RequestSigner {
    private final Supplier<Credentials> creds;
    private final Provider<String> timeStampProvider;

    @Inject
    public RestAuthentication(@org.jclouds.location.Provider Supplier<Credentials> creds, @TimeStamp Provider<String> timeStampProvider) {
        this.creds = creds;
        this.timeStampProvider = timeStampProvider;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        Credentials current = this.creds.get();
        if (current instanceof SessionCredentials) {
            request = this.replaceSecurityTokenHeader(request, (SessionCredentials)SessionCredentials.class.cast(current));
        }
        request = this.replaceDateHeader(request, this.timeStampProvider.get());
        String signature = this.sign(this.createStringToSign(request));
        return this.replaceAuthorizationHeader(request, signature);
    }

    private HttpRequest replaceSecurityTokenHeader(HttpRequest request, SessionCredentials current) {
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("x-amz-security-token", current.getSessionToken())).build();
    }

    private HttpRequest replaceDateHeader(HttpRequest request, String timestamp) {
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("Date", timestamp)).build();
        return request;
    }

    @Override
    public String createStringToSign(HttpRequest input) {
        return input.getFirstHeaderOrNull("Date");
    }

    @Override
    public String sign(String toSign) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(this.creds.get().credential.getBytes(Charsets.UTF_8), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(keySpec);
            byte[] result = mac.doFinal(toSign.getBytes(Charsets.UTF_8));
            return BaseEncoding.base64().encode(result);
        }
        catch (InvalidKeyException e) {
            throw Throwables.propagate(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw Throwables.propagate(e);
        }
    }

    private HttpRequest replaceAuthorizationHeader(HttpRequest request, String signature) {
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("X-Amzn-Authorization", "AWS3-HTTPS AWSAccessKeyId=" + this.creds.get().identity + ",Algorithm=HmacSHA256,Signature=" + signature)).build();
        return request;
    }
}

