/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.jclouds.route53.domain.Change;
import org.jclouds.route53.domain.HostedZone;
import org.jclouds.route53.domain.HostedZoneAndNameServers;

public final class NewHostedZone {
    private final HostedZoneAndNameServers zone;
    private final Change change;

    private NewHostedZone(HostedZoneAndNameServers zone, Change change) {
        this.zone = Preconditions.checkNotNull(zone, "zone");
        this.change = Preconditions.checkNotNull(change, "change of %s", (Object)zone);
    }

    public HostedZone getZone() {
        return this.zone.getZone();
    }

    public ImmutableList<String> getNameServers() {
        return this.zone.getNameServers();
    }

    public Change getChange() {
        return this.change;
    }

    public int hashCode() {
        return Objects.hashCode(this.zone);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NewHostedZone that = (NewHostedZone)NewHostedZone.class.cast(obj);
        return Objects.equal(this.zone, that.zone);
    }

    public String toString() {
        return MoreObjects.toStringHelper("").add("zone", this.zone.getZone()).add("nameServers", this.zone.getNameServers()).add("change", this.change).toString();
    }

    public static NewHostedZone create(HostedZoneAndNameServers zone, Change change) {
        return new NewHostedZone(zone, change);
    }
}

