/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rest.InvocationContext;

public class ParseAlgorithms
implements Function<HttpResponse, List<String>>,
InvocationContext<ParseAlgorithms> {
    private final ParseJson<Map<String, List<Map<String, String>>>> json;

    @Inject
    ParseAlgorithms(ParseJson<Map<String, List<Map<String, String>>>> json) {
        this.json = Preconditions.checkNotNull(json, "json");
    }

    @Override
    public List<String> apply(HttpResponse response) {
        Map<String, List<Map<String, String>>> map = this.json.apply(response);
        if (map == null || map.isEmpty()) {
            throw new HttpResponseException("Unexpected JSON format returned.", null, response);
        }
        List<Map<String, String>> list = Iterables.get(map.values(), 0);
        ArrayList<String> algorithms = Lists.newArrayList();
        for (Map<String, String> nameAlgorithmPair : list) {
            algorithms.add(Iterables.get(nameAlgorithmPair.values(), 0));
        }
        return algorithms;
    }

    @Override
    public ParseAlgorithms setContext(HttpRequest request) {
        return this;
    }
}

