/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Metadata;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.internal.BaseNode;

public class Node
extends BaseNode<Node> {
    private int id;
    private Status status;
    private Metadata metadata = new Metadata();

    protected Node() {
    }

    public Node(String address, int port, BaseNode.Condition condition, BaseNode.Type type, Integer weight, int id, Status status, Metadata metadata) {
        super(address, port, condition, type, weight);
        Preconditions.checkArgument(id != -1, "id must be specified");
        this.id = id;
        this.status = Preconditions.checkNotNull(status, "status");
        this.metadata = metadata != null ? metadata : this.metadata;
    }

    public int getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("address", this.address).add("port", this.port).add("condition", (Object)this.condition).add("type", (Object)this.type).add("weight", this.weight).add("status", (Object)this.status).add("metadata", this.metadata);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Node that = (Node)Node.class.cast(obj);
        return Objects.equal(this.id, that.id);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static class Builder
    extends BaseNode.Builder<Node> {
        private int id = -1;
        private Status status;
        private Metadata metadata;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder metadata(Metadata metadata) {
            this.metadata = Preconditions.checkNotNull(metadata, "metadata");
            return this;
        }

        public Node build() {
            return new Node(this.address, this.port, this.condition, this.type, this.weight, this.id, this.status, this.metadata);
        }

        public Builder address(String address) {
            return (Builder)Builder.class.cast(super.address(address));
        }

        public Builder condition(BaseNode.Condition condition) {
            return (Builder)Builder.class.cast(super.condition(condition));
        }

        public Builder type(BaseNode.Type type) {
            return (Builder)Builder.class.cast(super.type(type));
        }

        public Builder port(int port) {
            return (Builder)Builder.class.cast(super.port(port));
        }

        public Builder weight(Integer weight) {
            return (Builder)Builder.class.cast(super.weight(weight));
        }

        public Builder from(Node in) {
            return ((Builder)Builder.class.cast(super.from(in))).id(in.getId()).status(in.getStatus()).metadata(in.getMetadata());
        }
    }

    public static enum Status {
        ONLINE,
        OFFLINE,
        DRAINING,
        UNRECOGNIZED;


        public static Status fromValue(String status) {
            try {
                return Status.valueOf(Preconditions.checkNotNull(status, "status"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

