/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class HealthMonitor {
    private final Type type;
    private final int delay;
    private final int timeout;
    private final int attemptsBeforeDeactivation;
    private final Optional<String> bodyRegex;
    private final Optional<String> statusRegex;
    private final Optional<String> path;
    private final Optional<String> hostHeader;

    @ConstructorProperties(value={"type", "delay", "timeout", "attemptsBeforeDeactivation", "bodyRegex", "statusRegex", "path", "hostHeader"})
    protected HealthMonitor(Type type, int delay, int timeout, int attemptsBeforeDeactivation, @Nullable String bodyRegex, @Nullable String statusRegex, @Nullable String path, @Nullable String hostHeader) {
        this.type = Preconditions.checkNotNull(type, "type");
        this.delay = delay;
        this.timeout = timeout;
        this.attemptsBeforeDeactivation = attemptsBeforeDeactivation;
        this.bodyRegex = Optional.fromNullable(bodyRegex);
        this.statusRegex = Optional.fromNullable(statusRegex);
        this.path = Optional.fromNullable(path);
        this.hostHeader = Optional.fromNullable(hostHeader);
        if (!this.isValid()) {
            if (type.equals((Object)Type.CONNECT)) {
                throw new IllegalArgumentException("Only delay, timeout, and attemptsBeforeDeactivation must be set.");
            }
            throw new IllegalArgumentException("At least delay, timeout, attemptsBeforeDeactivation, path and one or both of bodyRegex and statusRegex must be set.");
        }
    }

    public Type getType() {
        return this.type;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getAttemptsBeforeDeactivation() {
        return this.attemptsBeforeDeactivation;
    }

    public Optional<String> getBodyRegex() {
        return this.bodyRegex;
    }

    public Optional<String> getStatusRegex() {
        return this.statusRegex;
    }

    public Optional<String> getPath() {
        return this.path;
    }

    public Optional<String> getHostHeader() {
        return this.hostHeader;
    }

    public boolean isValid() {
        boolean required;
        boolean bl = required = this.delay != 0 && this.timeout != 0 && this.attemptsBeforeDeactivation != 0;
        if (this.type.equals((Object)Type.CONNECT)) {
            return required && !this.path.isPresent() && !this.statusRegex.isPresent() && !this.bodyRegex.isPresent() && !this.hostHeader.isPresent();
        }
        return required && this.path.isPresent() && (this.statusRegex.isPresent() || this.bodyRegex.isPresent());
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.type, this.delay, this.timeout, this.attemptsBeforeDeactivation, this.bodyRegex, this.statusRegex, this.path, this.hostHeader});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HealthMonitor that = (HealthMonitor)HealthMonitor.class.cast(obj);
        return Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.delay, that.delay) && Objects.equal(this.timeout, that.timeout) && Objects.equal(this.attemptsBeforeDeactivation, that.attemptsBeforeDeactivation) && Objects.equal(this.bodyRegex, that.bodyRegex) && Objects.equal(this.statusRegex, that.statusRegex) && Objects.equal(this.path, that.path) && Objects.equal(this.hostHeader, that.hostHeader);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("type", (Object)this.type).add("delay", this.delay).add("timeout", this.timeout).add("attemptsBeforeDeactivation", this.attemptsBeforeDeactivation).add("bodyRegex", this.bodyRegex.orNull()).add("statusRegex", this.statusRegex.orNull()).add("path", this.path.orNull()).add("hostHeader", this.hostHeader.orNull());
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static class Builder {
        private Type type;
        private int delay;
        private int timeout;
        private int attemptsBeforeDeactivation;
        private String bodyRegex;
        private String statusRegex;
        private String path;
        private String hostHeader;

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder delay(int delay) {
            this.delay = delay;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder attemptsBeforeDeactivation(int attemptsBeforeDeactivation) {
            this.attemptsBeforeDeactivation = attemptsBeforeDeactivation;
            return this;
        }

        public Builder bodyRegex(String bodyRegex) {
            this.bodyRegex = bodyRegex;
            return this;
        }

        public Builder statusRegex(String statusRegex) {
            this.statusRegex = statusRegex;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder hostHeader(String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        public HealthMonitor build() {
            return new HealthMonitor(this.type, this.delay, this.timeout, this.attemptsBeforeDeactivation, this.bodyRegex, this.statusRegex, this.path, this.hostHeader);
        }

        public Builder from(HealthMonitor in) {
            return this.type(in.getType()).delay(in.getDelay()).timeout(in.getTimeout()).attemptsBeforeDeactivation(in.getAttemptsBeforeDeactivation()).bodyRegex(in.getBodyRegex().orNull()).statusRegex(in.getStatusRegex().orNull()).path(in.getPath().orNull()).hostHeader(in.getHostHeader().orNull());
        }
    }

    public static enum Type {
        CONNECT,
        HTTP,
        HTTPS,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf(Preconditions.checkNotNull(type, "type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

