/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rest.Binder;

@Singleton
public class BindMetadataToJsonPayload
implements Binder {
    protected final Json jsonBinder;

    @Inject
    public BindMetadataToJsonPayload(Json jsonBinder) {
        this.jsonBinder = Preconditions.checkNotNull(jsonBinder, "jsonBinder");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Map, "This binder is only valid for Map<String, String>");
        Preconditions.checkNotNull(request, "request");
        Map metadata = (Map)input;
        ArrayList<ImmutableMap<String, String>> clbMetadata = Lists.newArrayList();
        for (Map.Entry entry : metadata.entrySet()) {
            clbMetadata.add(ImmutableMap.of("key", (String)entry.getKey(), "value", (String)entry.getValue()));
        }
        String json = this.jsonBinder.toJson(ImmutableMap.of("metadata", clbMetadata));
        request.setPayload(json);
        request.getPayload().getContentMetadata().setContentType("application/json");
        return request;
    }
}

