/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudfiles.v1.options;

import com.google.common.base.Preconditions;
import com.google.common.net.MediaType;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class UpdateCDNContainerOptions
extends BaseHttpRequestOptions {
    public static final UpdateCDNContainerOptions NONE = new UpdateCDNContainerOptions();

    public UpdateCDNContainerOptions ttl(int ttl) {
        Preconditions.checkState(ttl >= Integer.valueOf(900), "ttl must be >= 900");
        Preconditions.checkState(ttl <= Integer.valueOf(31536000), "ttl must be <= 31536000");
        this.headers.put("X-Ttl", Integer.toString(ttl));
        return this;
    }

    public UpdateCDNContainerOptions logRetention(boolean logRetention) {
        this.headers.put("X-Log-Retention", Boolean.toString(logRetention));
        return this;
    }

    public UpdateCDNContainerOptions enabled(boolean enabled) {
        this.headers.put("X-Cdn-Enabled", Boolean.toString(enabled));
        return this;
    }

    public UpdateCDNContainerOptions staticWebsiteDirectoryType(MediaType directoryType) {
        Preconditions.checkNotNull(directoryType, "directoryType cannot be null");
        this.headers.put("X-Container-Meta-Web-Directory-Type", directoryType.toString());
        return this;
    }

    public UpdateCDNContainerOptions staticWebsiteErrorPage(String errorPage) {
        Preconditions.checkNotNull(errorPage, "error page cannot be null");
        this.headers.put("X-Container-Meta-Web-Error", errorPage);
        return this;
    }

    public UpdateCDNContainerOptions staticWebsiteIndexPage(String indexPage) {
        Preconditions.checkNotNull(indexPage, "index page cannot be null");
        this.headers.put("X-Container-Meta-Web-Index", indexPage);
        return this;
    }

    public UpdateCDNContainerOptions staticWebsiteListings(boolean listings) {
        this.headers.put("X-Container-Meta-Web-Listings", Boolean.toString(listings));
        return this;
    }

    public UpdateCDNContainerOptions staticWebsiteListingsCSS(String listingsCSS) {
        Preconditions.checkNotNull(listingsCSS, "listingsCSS page cannot be null");
        this.headers.put("X-Container-Meta-Web-Listings-CSS", listingsCSS);
        return this;
    }

    public static class Builder {
        public static UpdateCDNContainerOptions ttl(int ttl) {
            UpdateCDNContainerOptions options = new UpdateCDNContainerOptions();
            return options.ttl(ttl);
        }

        public static UpdateCDNContainerOptions logRetention(boolean logRetention) {
            UpdateCDNContainerOptions options = new UpdateCDNContainerOptions();
            return options.logRetention(logRetention);
        }

        public static UpdateCDNContainerOptions enabled(boolean enabled) {
            UpdateCDNContainerOptions options = new UpdateCDNContainerOptions();
            return options.enabled(enabled);
        }

        public static UpdateCDNContainerOptions staticWebsiteDirectoryType(MediaType directoryType) {
            UpdateCDNContainerOptions options = new UpdateCDNContainerOptions();
            return options.staticWebsiteDirectoryType(directoryType);
        }

        public static UpdateCDNContainerOptions staticWebsiteErrorPage(String errorPage) {
            UpdateCDNContainerOptions options = new UpdateCDNContainerOptions();
            return options.staticWebsiteErrorPage(errorPage);
        }

        public static UpdateCDNContainerOptions staticWebsiteIndexPage(String indexPage) {
            UpdateCDNContainerOptions options = new UpdateCDNContainerOptions();
            return options.staticWebsiteIndexPage(indexPage);
        }

        public static UpdateCDNContainerOptions staticWebsiteListings(boolean enabled) {
            UpdateCDNContainerOptions options = new UpdateCDNContainerOptions();
            return options.staticWebsiteListings(enabled);
        }

        public static UpdateCDNContainerOptions staticWebsiteListingsCSS(String cssPage) {
            UpdateCDNContainerOptions options = new UpdateCDNContainerOptions();
            return options.staticWebsiteListingsCSS(cssPage);
        }
    }
}

