/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.rackspace.clouddns.v1.domain.Subdomain;
import org.jclouds.rest.InvocationContext;

public class ParseSubdomains
implements Function<HttpResponse, PaginatedCollection<Subdomain>>,
InvocationContext<ParseSubdomains> {
    private final ParseJson<Subdomains> json;

    @Inject
    ParseSubdomains(ParseJson<Subdomains> json) {
        this.json = Preconditions.checkNotNull(json, "json");
    }

    @Override
    public PaginatedCollection<Subdomain> apply(HttpResponse response) {
        Subdomains subdomains = this.json.apply(response);
        return subdomains;
    }

    @Override
    public ParseSubdomains setContext(HttpRequest request) {
        return this;
    }

    static class Subdomains
    extends PaginatedCollection<Subdomain> {
        @ConstructorProperties(value={"domains", "links", "totalEntries"})
        protected Subdomains(Iterable<Subdomain> domains, Iterable<Link> links, int totalEntries) {
            super(domains, links, totalEntries);
        }
    }
}

