/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;

public class UpdateDomain {
    private final Optional<String> emailAddress;
    private final Optional<Integer> ttl;
    private final Optional<String> comment;

    private UpdateDomain(Optional<String> email, Optional<Integer> ttl, Optional<String> comment) {
        this.emailAddress = email;
        this.ttl = ttl;
        this.comment = comment;
    }

    public Optional<String> getEmail() {
        return this.emailAddress;
    }

    public Optional<Integer> getTTL() {
        return this.ttl;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public int hashCode() {
        return Objects.hashCode(this.emailAddress, this.ttl, this.comment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateDomain that = (UpdateDomain)UpdateDomain.class.cast(obj);
        return Objects.equal(this.emailAddress, that.emailAddress) && Objects.equal(this.ttl, that.ttl) && Objects.equal(this.comment, that.comment);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("email", this.emailAddress.orNull()).add("ttl", this.ttl.orNull()).add("comment", this.comment.orNull());
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static class Builder {
        private Optional<String> emailAddress = Optional.absent();
        private Optional<Integer> ttl = Optional.absent();
        private Optional<String> comment = Optional.absent();

        public Builder email(String email) {
            this.emailAddress = Optional.fromNullable(email);
            return this;
        }

        public Builder ttl(Integer ttl) {
            this.ttl = Optional.fromNullable(ttl);
            return this;
        }

        public Builder comment(String comment) {
            this.comment = Optional.fromNullable(comment);
            return this;
        }

        public UpdateDomain build() {
            return new UpdateDomain(this.emailAddress, this.ttl, this.comment);
        }

        public Builder from(UpdateDomain in) {
            return this.email(in.getEmail().orNull()).ttl(in.getTTL().orNull()).comment(in.getComment().orNull());
        }
    }
}

