/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rackspace.clouddns.v1.binders.UpdateRecordsToJSON;
import org.jclouds.rest.MapBinder;

public class UpdateReverseDNSToJSON
implements MapBinder {
    private final Json jsonBinder;

    @Inject
    public UpdateReverseDNSToJSON(Json jsonBinder) {
        this.jsonBinder = Preconditions.checkNotNull(jsonBinder, "jsonBinder");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument(Preconditions.checkNotNull(postParams.get("href"), "href") instanceof URI, "href is only valid for a URI!");
        Preconditions.checkArgument(Preconditions.checkNotNull(postParams.get("idsToRecords"), "idsToRecords") instanceof Map, "records is only valid for a Map!");
        Preconditions.checkNotNull(postParams.get("serviceName"), "serviceName");
        Map idsToRecords = (Map)Map.class.cast(postParams.get("idsToRecords"));
        List<UpdateRecordsToJSON.UpdateRecord> updateRecords = UpdateRecordsToJSON.toUpdateRecordList(idsToRecords);
        URI deviceURI = (URI)URI.class.cast(postParams.get("href"));
        String serviceName = postParams.get("serviceName").toString();
        String json = this.toJSON(updateRecords, deviceURI, serviceName);
        request.setPayload(json);
        request.getPayload().getContentMetadata().setContentType("application/json");
        return (R)((HttpRequest.Builder)request.toBuilder().payload(json)).build();
    }

    private String toJSON(Iterable<UpdateRecordsToJSON.UpdateRecord> records, URI deviceURI, String serviceName) {
        return this.jsonBinder.toJson(ImmutableMap.of("recordsList", ImmutableMap.of("records", records), "link", ImmutableMap.of("href", deviceURI, "rel", serviceName)));
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new UnsupportedOperationException("use map form");
    }
}

