/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.compute;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.profitbricks.ProfitBricksApi;
import org.jclouds.profitbricks.compute.concurrent.ProvisioningJob;
import org.jclouds.profitbricks.compute.concurrent.ProvisioningManager;
import org.jclouds.profitbricks.compute.strategy.TemplateWithDataCenter;
import org.jclouds.profitbricks.domain.AvailabilityZone;
import org.jclouds.profitbricks.domain.DataCenter;
import org.jclouds.profitbricks.domain.Image;
import org.jclouds.profitbricks.domain.Provisionable;
import org.jclouds.profitbricks.domain.Server;
import org.jclouds.profitbricks.domain.Snapshot;
import org.jclouds.profitbricks.domain.Storage;
import org.jclouds.profitbricks.features.ServerApi;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.PasswordGenerator;

@Singleton
public class ProfitBricksComputeServiceAdapter
implements ComputeServiceAdapter<Server, Hardware, Provisionable, Location> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final ProfitBricksApi api;
    private final Predicate<String> waitDcUntilAvailable;
    private final ListeningExecutorService executorService;
    private final ProvisioningJob.Factory jobFactory;
    private final ProvisioningManager provisioningManager;
    private final PasswordGenerator.Config passwordGenerator;
    private static final Integer DEFAULT_LAN_ID = 1;

    @Inject
    ProfitBricksComputeServiceAdapter(ProfitBricksApi api, @Named(value="jclouds.profitbricks.predicate.datacenter") Predicate<String> waitDcUntilAvailable, @Named(value="jclouds.user-threads") ListeningExecutorService executorService, ProvisioningJob.Factory jobFactory, ProvisioningManager provisioningManager, PasswordGenerator.Config passwordGenerator) {
        this.api = api;
        this.waitDcUntilAvailable = waitDcUntilAvailable;
        this.executorService = executorService;
        this.jobFactory = jobFactory;
        this.provisioningManager = provisioningManager;
        this.passwordGenerator = passwordGenerator;
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<Server> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Preconditions.checkArgument(template instanceof TemplateWithDataCenter, "This implementation requires a TemplateWithDataCenter");
        return this.createNodeWithGroupEncodedIntoName(group, name, (TemplateWithDataCenter)TemplateWithDataCenter.class.cast(template));
    }

    protected ComputeServiceAdapter.NodeAndInitialCredentials<Server> createNodeWithGroupEncodedIntoName(String group, String name, TemplateWithDataCenter template) {
        Preconditions.checkArgument(template.getLocation().getScope() == LocationScope.ZONE, "Template must use a ZONE-scoped location");
        String dataCenterId = template.getDataCenter().id();
        Hardware hardware = template.getHardware();
        TemplateOptions options = template.getOptions();
        String loginUser = Strings.isNullOrEmpty(options.getLoginUser()) ? "root" : options.getLoginUser();
        String password = options.hasLoginPassword() ? options.getLoginPassword() : this.passwordGenerator.generate();
        org.jclouds.compute.domain.Image image = template.getImage();
        List<? extends Volume> volumes = hardware.getVolumes();
        ArrayList<String> storageIds = Lists.newArrayListWithExpectedSize(volumes.size());
        int i = 1;
        for (Volume volume : volumes) {
            try {
                this.logger.trace("<< provisioning storage '%s'", volume);
                final Storage.Request.CreatePayload.Builder storageBuilder = Storage.Request.creatingBuilder();
                if (i == 1) {
                    storageBuilder.mountImageId(image.getId());
                    Provisionable.Type provisionableType = Provisionable.Type.fromValue(image.getUserMetadata().get("provisionableType"));
                    if (provisionableType == Provisionable.Type.IMAGE) {
                        storageBuilder.imagePassword(password);
                    }
                }
                storageBuilder.dataCenterId(dataCenterId).name(String.format("%s-disk-%d", name, i++)).size(volume.getSize().floatValue());
                String storageId = (String)this.provisioningManager.provision(this.jobFactory.create(dataCenterId, new Supplier<Object>(){

                    @Override
                    public Object get() {
                        return ProfitBricksComputeServiceAdapter.this.api.storageApi().createStorage(storageBuilder.build());
                    }
                }));
                storageIds.add(storageId);
                this.logger.trace(">> provisioning complete for storage. returned id='%s'", storageId);
            }
            catch (Exception ex) {
                if (i - 1 == 1) {
                    throw Throwables.propagate(ex);
                }
                this.logger.warn(ex, ">> failed to provision storage. skipping..", new Object[0]);
            }
        }
        int lanId = DEFAULT_LAN_ID;
        if (options.getNetworks() != null) {
            try {
                String string = Iterables.get(options.getNetworks(), 0);
                lanId = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.logger.warn("no valid network id found from options. using default id='%d'", DEFAULT_LAN_ID);
            }
        }
        Double d = ComputeServiceUtils.getCores(hardware);
        String serverId = null;
        try {
            String storageBootDeviceId = (String)Iterables.get(storageIds, 0);
            final Server.Request.CreatePayload serverRequest = Server.Request.creatingBuilder().dataCenterId(dataCenterId).name(name).bootFromStorageId(storageBootDeviceId).cores(d.intValue()).ram(hardware.getRam()).availabilityZone(AvailabilityZone.AUTO).hasInternetAccess(true).lanId(lanId).build();
            this.logger.trace("<< provisioning server '%s'", serverRequest);
            serverId = (String)this.provisioningManager.provision(this.jobFactory.create(dataCenterId, new Supplier<Object>(){

                @Override
                public Object get() {
                    return ProfitBricksComputeServiceAdapter.this.api.serverApi().createServer(serverRequest);
                }
            }));
            this.logger.trace(">> provisioning complete for server. returned id='%s'", serverId);
        }
        catch (Exception ex) {
            this.logger.error(ex, ">> failed to provision server. rollbacking..", new Object[0]);
            this.destroyStorages(storageIds, dataCenterId);
            throw Throwables.propagate(ex);
        }
        int storageCount = storageIds.size();
        for (int j = 1; j < storageCount; ++j) {
            String storageId = (String)storageIds.get(j);
            try {
                this.logger.trace("<< connecting storage '%s' to server '%s'", storageId, serverId);
                final Storage.Request.ConnectPayload request = Storage.Request.connectingBuilder().storageId(storageId).serverId(serverId).build();
                this.provisioningManager.provision(this.jobFactory.create(group, new Supplier<Object>(){

                    @Override
                    public Object get() {
                        return ProfitBricksComputeServiceAdapter.this.api.storageApi().connectStorageToServer(request);
                    }
                }));
                this.logger.trace(">> storage connected.", new Object[0]);
                continue;
            }
            catch (Exception ex) {
                this.logger.warn(ex, ">> failed to connect storage '%s'. deleting..", storageId);
                this.destroyStorage(storageId, dataCenterId);
            }
        }
        this.waitDcUntilAvailable.apply(dataCenterId);
        LoginCredentials serverCredentials = LoginCredentials.builder().user(loginUser).password(password).build();
        Server server = this.getNode(serverId);
        return new ComputeServiceAdapter.NodeAndInitialCredentials<Server>(server, serverId, serverCredentials);
    }

    @Override
    public Iterable<Hardware> listHardwareProfiles() {
        ArrayList<Hardware> hardwares = Lists.newArrayList();
        for (int core = 1; core <= 48; ++core) {
            for (int ram : new int[]{1024, 2048, 4096, 8192, 10240, 16384, 24576, 28672, 32768}) {
                for (float size : new float[]{10.0f, 20.0f, 30.0f, 50.0f, 80.0f, 100.0f, 150.0f, 200.0f, 250.0f, 500.0f}) {
                    String id = String.format("cpu=%d,ram=%s,disk=%f", core, ram, Float.valueOf(size));
                    hardwares.add(new HardwareBuilder().ids(id).ram(ram).hypervisor("kvm").name(id).processor(new Processor(core, 1.0)).volume(new VolumeImpl(Float.valueOf(size), true, true)).build());
                }
            }
        }
        return hardwares;
    }

    @Override
    public Iterable<Provisionable> listImages() {
        Future images = this.executorService.submit(new Callable<List<Image>>(){

            @Override
            public List<Image> call() throws Exception {
                ProfitBricksComputeServiceAdapter.this.logger.trace("<< fetching images..", new Object[0]);
                Iterable<Image> filteredImages = Iterables.filter(ProfitBricksComputeServiceAdapter.this.api.imageApi().getAllImages(), new Predicate<Image>(){

                    @Override
                    public boolean apply(Image image) {
                        return image.type() == Image.Type.HDD;
                    }
                });
                ProfitBricksComputeServiceAdapter.this.logger.trace(">> images fetched.", new Object[0]);
                return ImmutableList.copyOf(filteredImages);
            }
        });
        Future snapshots = this.executorService.submit(new Callable<List<Snapshot>>(){

            @Override
            public List<Snapshot> call() throws Exception {
                ProfitBricksComputeServiceAdapter.this.logger.trace("<< fetching snapshots", new Object[0]);
                List<Snapshot> remoteSnapshots = ProfitBricksComputeServiceAdapter.this.api.snapshotApi().getAllSnapshots();
                ProfitBricksComputeServiceAdapter.this.logger.trace(">> snapshots feched.", new Object[0]);
                return remoteSnapshots;
            }
        });
        return Iterables.concat((Iterable)Futures.getUnchecked(images), (Iterable)Futures.getUnchecked(snapshots));
    }

    @Override
    public Provisionable getImage(String id) {
        this.logger.trace("<< searching for image with id=%s", id);
        try {
            Image image = this.api.imageApi().getImage(id);
            if (image != null) {
                this.logger.trace(">> found image [%s].", image.name());
                return image;
            }
        }
        catch (Exception ex) {
            this.logger.warn(ex, ">> unexpected error getting image. Trying to get as a snapshot...", new Object[0]);
        }
        this.logger.trace("<< not found from images. searching for snapshot with id=%s", id);
        Snapshot snapshot = this.api.snapshotApi().getSnapshot(id);
        if (snapshot != null) {
            this.logger.trace(">> found snapshot [%s]", snapshot.name());
            return snapshot;
        }
        throw new ResourceNotFoundException("No image/snapshot with id '" + id + "' was found");
    }

    @Override
    public Iterable<Location> listLocations() {
        throw new UnsupportedOperationException("Locations are configured in jclouds properties");
    }

    @Override
    public Server getNode(String id) {
        this.logger.trace("<< searching for server with id=%s", id);
        Server server = this.api.serverApi().getServer(id);
        if (server != null) {
            this.logger.trace(">> found server [%s]", server.name());
        }
        return server;
    }

    @Override
    public void destroyNode(String nodeId) {
        ServerApi serverApi = this.api.serverApi();
        Server server = serverApi.getServer(nodeId);
        if (server != null) {
            String dataCenterId = server.dataCenter().id();
            for (Storage storage : server.storages()) {
                this.destroyStorage(storage.id(), dataCenterId);
            }
            try {
                this.destroyServer(nodeId, dataCenterId);
            }
            catch (Exception ex) {
                this.logger.warn(ex, ">> failed to delete server with id=%s", nodeId);
            }
        }
    }

    @Override
    public void rebootNode(final String id) {
        final Server node = this.getRequiredNode(id);
        DataCenter dataCenter = node.dataCenter();
        this.provisioningManager.provision(this.jobFactory.create(dataCenter.id(), new Supplier<Object>(){

            @Override
            public Object get() {
                ProfitBricksComputeServiceAdapter.this.api.serverApi().resetServer(id);
                return node;
            }
        }));
    }

    @Override
    public void resumeNode(final String id) {
        final Server node = this.getRequiredNode(id);
        if (node.status() == Server.Status.RUNNING) {
            return;
        }
        DataCenter dataCenter = node.dataCenter();
        this.provisioningManager.provision(this.jobFactory.create(dataCenter.id(), new Supplier<Object>(){

            @Override
            public Object get() {
                ProfitBricksComputeServiceAdapter.this.api.serverApi().startServer(id);
                return node;
            }
        }));
    }

    @Override
    public void suspendNode(final String id) {
        final Server node = this.getRequiredNode(id);
        if (node.status() == Server.Status.SHUTOFF) {
            return;
        }
        DataCenter dataCenter = node.dataCenter();
        this.provisioningManager.provision(this.jobFactory.create(dataCenter.id(), new Supplier<Object>(){

            @Override
            public Object get() {
                ProfitBricksComputeServiceAdapter.this.api.serverApi().stopServer(id);
                return node;
            }
        }));
    }

    @Override
    public Iterable<Server> listNodes() {
        this.logger.trace(">> fetching all servers..", new Object[0]);
        List<Server> servers = this.api.serverApi().getAllServers();
        this.logger.trace(">> servers fetched.", new Object[0]);
        return servers;
    }

    @Override
    public Iterable<Server> listNodesByIds(Iterable<String> ids) {
        ListenableFuture<List<Server>> futures = Futures.allAsList(Iterables.transform(ids, new Function<String, ListenableFuture<Server>>(){

            @Override
            public ListenableFuture<Server> apply(final String input) {
                return ProfitBricksComputeServiceAdapter.this.executorService.submit(new Callable<Server>(){

                    @Override
                    public Server call() throws Exception {
                        return ProfitBricksComputeServiceAdapter.this.getNode(input);
                    }
                });
            }
        }));
        return Futures.getUnchecked(futures);
    }

    private void destroyServer(final String serverId, String dataCenterId) {
        try {
            this.logger.trace("<< deleting server with id=%s", serverId);
            this.provisioningManager.provision(this.jobFactory.create(dataCenterId, new Supplier<Object>(){

                @Override
                public Object get() {
                    ProfitBricksComputeServiceAdapter.this.api.serverApi().deleteServer(serverId);
                    return serverId;
                }
            }));
            this.logger.trace(">> server '%s' deleted.", serverId);
        }
        catch (Exception ex) {
            this.logger.warn(ex, ">> failed to delete server with id=%s", serverId);
        }
    }

    private void destroyStorages(List<String> storageIds, String dataCenterId) {
        for (String storageId : storageIds) {
            this.destroyStorage(storageId, dataCenterId);
        }
    }

    private void destroyStorage(final String storageId, String dataCenterId) {
        try {
            this.logger.trace("<< deleting storage with id=%s", storageId);
            this.provisioningManager.provision(this.jobFactory.create(dataCenterId, new Supplier<Object>(){

                @Override
                public Object get() {
                    ProfitBricksComputeServiceAdapter.this.api.storageApi().deleteStorage(storageId);
                    return storageId;
                }
            }));
            this.logger.trace(">> storage '%s' deleted.", storageId);
        }
        catch (Exception ex) {
            this.logger.warn(ex, ">> failed to delete storage with id=%s", storageId);
        }
    }

    private Server getRequiredNode(String nodeId) {
        Server node = this.getNode(nodeId);
        if (node == null) {
            throw new ResourceNotFoundException("Node with id'" + nodeId + "' was not found.");
        }
        return node;
    }
}

