/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.domain.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.packet.domain.Href;
import org.jclouds.packet.domain.internal.AutoValue_PaginatedCollection_Meta;

public abstract class PaginatedCollection<T>
extends IterableWithMarker<T> {
    private final List<T> items;
    private final Meta meta;

    protected PaginatedCollection(List<T> items, Meta meta) {
        this.items = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(items, "items cannot be null"));
        this.meta = meta;
    }

    public List<T> items() {
        return this.items;
    }

    public Meta meta() {
        return this.meta;
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    @Override
    public Optional<Object> nextMarker() {
        if (this.meta == null || this.meta.next() == null) {
            return Optional.absent();
        }
        return Optional.fromNullable(this.meta.next());
    }

    public static abstract class Meta {
        public abstract long total();

        @Nullable
        public abstract Href first();

        @Nullable
        public abstract Href previous();

        @Nullable
        public abstract Href self();

        @Nullable
        public abstract Href next();

        @Nullable
        public abstract Href last();

        @SerializedNames(value={"total", "first", "previous", "self", "next", "last"})
        public static Meta create(long total, Href first, Href previous, Href self, Href next, Href last) {
            return new AutoValue_PaginatedCollection_Meta(total, first, previous, self, next, last);
        }

        Meta() {
        }
    }
}

