/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.ovf.Network;
import org.jclouds.ovf.Section;

public class NetworkSection
extends Section<NetworkSection> {
    private final Set<Network> networks;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return NetworkSection.builder().fromNetworkSection(this);
    }

    public NetworkSection(String info, Iterable<Network> networks) {
        super(info);
        this.networks = ImmutableSet.copyOf(Preconditions.checkNotNull(networks, "networks"));
    }

    public Set<Network> getNetworks() {
        return this.networks;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        result = 31 * result + (this.networks == null ? 0 : this.networks.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkSection other = (NetworkSection)obj;
        if (this.info == null ? other.info != null : !this.info.equals(other.info)) {
            return false;
        }
        return !(this.networks == null ? other.networks != null : !this.networks.equals(other.networks));
    }

    @Override
    public String toString() {
        return String.format("[info=%s, networks=%s]", this.info, this.networks);
    }

    public static class Builder
    extends Section.Builder<NetworkSection> {
        protected Set<Network> networks = Sets.newLinkedHashSet();

        public Builder network(Network network) {
            this.networks.add(Preconditions.checkNotNull(network, "network"));
            return this;
        }

        public Builder networks(Iterable<Network> networks) {
            this.networks = ImmutableSet.copyOf(Preconditions.checkNotNull(networks, "networks"));
            return this;
        }

        public NetworkSection build() {
            return new NetworkSection(this.info, this.networks);
        }

        public Builder fromNetworkSection(NetworkSection in) {
            return this.networks(in.getNetworks()).info(in.getInfo());
        }

        public Builder fromSection(Section<NetworkSection> in) {
            return (Builder)Builder.class.cast(super.fromSection(in));
        }

        public Builder info(String info) {
            return (Builder)Builder.class.cast(super.info(info));
        }
    }
}

