/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class User
implements Comparable<User> {
    private final String name;
    private final String password;
    private final String host;
    private final List<Map<String, String>> databases;

    @ConstructorProperties(value={"name", "password", "host", "databases"})
    protected User(String name, String password, String host, List<Map<String, String>> databases) {
        this.name = Preconditions.checkNotNull(name, "name required");
        this.password = password;
        this.host = host;
        this.databases = databases == null ? Lists.newArrayList() : databases;
    }

    protected User(String name, String password, String host, Set<String> databases) {
        this.name = Preconditions.checkNotNull(name, "name required");
        this.password = password;
        this.host = host;
        if (databases == null) {
            this.databases = Lists.newArrayList();
        } else {
            ArrayList databaseList = Lists.newArrayList();
            for (String databaseName : databases) {
                HashMap<String, String> singleDatabase = Maps.newHashMap();
                singleDatabase.put("name", databaseName);
                databaseList.add(singleDatabase);
            }
            this.databases = ImmutableList.copyOf(databaseList);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public String getIdentifier() {
        if (this.host == null || "%".equals(this.host)) {
            return this.name;
        }
        return this.name + "@" + this.host;
    }

    public List<String> getDatabases() {
        ArrayList<String> databaseList = Lists.newArrayList();
        for (Map<String, String> database : this.databases) {
            databaseList.add(database.get("name"));
        }
        return ImmutableList.copyOf(databaseList);
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.password, this.databases);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        User that = (User)User.class.cast(obj);
        return Objects.equal(this.name, that.name) && Objects.equal(this.password, that.password) && Objects.equal(this.host, that.host) && Objects.equal(this.databases, that.databases);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("password", this.password).add("host", this.host).add("databases", this.databases);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromUser(this);
    }

    @Override
    public int compareTo(User that) {
        return this.getName().compareTo(that.getName());
    }

    public static class Builder {
        protected String name;
        protected String password;
        protected String host;
        protected Set<String> databases;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder databases(Set<String> databases) {
            this.databases = databases;
            return this;
        }

        public User build() {
            return new User(this.name, this.password, this.host, this.databases);
        }

        public Builder fromUser(User in) {
            return this.name(in.getName()).password(in.getPassword()).host(in.getHost()).databases(ImmutableSet.copyOf(in.getDatabases()));
        }
    }
}

