/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.binders;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.trove.v1.internal.Volume;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class BindCreateInstanceToJson
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        HashMap<String, Object> databaseInstance = Maps.newHashMap();
        databaseInstance.put("flavorRef", postParams.get("flavorRef"));
        databaseInstance.put("volume", new Volume((Integer)postParams.get("size")));
        if (postParams.get("name") != null) {
            databaseInstance.put("name", postParams.get("name"));
        }
        return this.jsonBinder.bindToRequest(request, ImmutableMap.of("instance", databaseInstance));
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("CreateInstance is a POST operation");
    }
}

