/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.binders;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class BindCreateDatabaseToJson
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ImmutableMap.Builder<String, String> databaseBuilder = ImmutableMap.builder();
        databaseBuilder.put("name", (String)postParams.get("database"));
        if (postParams.get("character_set") != null) {
            databaseBuilder.put("character_set", (String)postParams.get("character_set"));
        }
        if (postParams.get("collate") != null) {
            databaseBuilder.put("collate", (String)postParams.get("collate"));
        }
        return this.jsonBinder.bindToRequest(request, ImmutableMap.of("databases", ImmutableSet.of(databaseBuilder.build())));
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("Create database is a POST operation");
    }
}

