/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.options;

import com.google.common.collect.Multimap;
import java.util.Map;
import org.jclouds.http.options.BaseHttpRequestOptions;
import org.jclouds.openstack.swift.v1.binders.BindMetadataToHeaders;

public class CreateContainerOptions
extends BaseHttpRequestOptions {
    public static final CreateContainerOptions NONE = new CreateContainerOptions();
    private static final BindMetadataToHeaders bindMetadataToHeaders = new BindMetadataToHeaders("X-Container-Meta-");

    public CreateContainerOptions headers(Multimap<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public CreateContainerOptions metadata(Map<String, String> metadata) {
        this.headers.putAll(bindMetadataToHeaders.toHeaders(metadata));
        return this;
    }

    public CreateContainerOptions anybodyRead() {
        this.headers.put("X-Container-Read", ".r:*,.rlistings");
        return this;
    }

    public CreateContainerOptions versionsLocation(String containerName) {
        this.headers.put("X-Versions-Location", containerName);
        return this;
    }

    public static class Builder {
        public static CreateContainerOptions anybodyRead() {
            CreateContainerOptions options = new CreateContainerOptions();
            return options.anybodyRead();
        }

        public static CreateContainerOptions headers(Multimap<String, String> headers) {
            CreateContainerOptions options = new CreateContainerOptions();
            return options.headers(headers);
        }

        public static CreateContainerOptions metadata(Map<String, String> metadata) {
            CreateContainerOptions options = new CreateContainerOptions();
            return options.metadata(metadata);
        }

        public static CreateContainerOptions versionsLocation(String containerName) {
            CreateContainerOptions options = new CreateContainerOptions();
            return options.versionsLocation(containerName);
        }
    }
}

