/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.jclouds.io.Payload;

public class SwiftObject
implements Comparable<SwiftObject> {
    private final String name;
    private final URI uri;
    private final String etag;
    private final Date lastModified;
    private final Multimap<String, String> headers;
    private final Map<String, String> metadata;
    private final Payload payload;

    protected SwiftObject(String name, URI uri, String etag, Date lastModified, Multimap<String, String> headers, Map<String, String> metadata, Payload payload) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.uri = Preconditions.checkNotNull(uri, "uri of %s", (Object)name);
        this.etag = etag != null ? etag.replace("\"", "") : null;
        this.lastModified = Preconditions.checkNotNull(lastModified, "lastModified of %s", (Object)name);
        this.headers = headers == null ? ImmutableMultimap.of() : Preconditions.checkNotNull(headers, "headers of %s", (Object)name);
        this.metadata = metadata == null ? ImmutableMap.of() : metadata;
        this.payload = Preconditions.checkNotNull(payload, "payload of %s", (Object)name);
    }

    public String getName() {
        return this.name;
    }

    public URI getUri() {
        return this.uri;
    }

    @Deprecated
    public String getEtag() {
        return this.etag;
    }

    public String getETag() {
        return this.etag;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SwiftObject) {
            SwiftObject that = (SwiftObject)SwiftObject.class.cast(object);
            return Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getUri(), that.getUri()) && Objects.equal(this.getETag(), that.getETag());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getName(), this.getUri(), this.getETag());
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("name", this.getName()).add("uri", this.getUri()).add("etag", this.getETag()).add("lastModified", this.getLastModified()).add("metadata", this.getMetadata());
    }

    @Override
    public int compareTo(SwiftObject that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.getName().compareTo(that.getName());
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SwiftObject.builder().fromObject(this);
    }

    public static class Builder {
        protected String name;
        protected URI uri;
        protected String etag;
        protected Date lastModified;
        protected Payload payload;
        protected Multimap<String, String> headers = ImmutableMultimap.of();
        protected Map<String, String> metadata = ImmutableMap.of();

        public Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = Preconditions.checkNotNull(uri, "uri");
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder lastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        public Builder headers(Multimap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
            for (Map.Entry<String, String> entry : Preconditions.checkNotNull(metadata, "metadata").entrySet()) {
                builder.put(entry.getKey().toLowerCase(), entry.getValue());
            }
            this.metadata = builder.build();
            return this;
        }

        public SwiftObject build() {
            return new SwiftObject(this.name, this.uri, this.etag, this.lastModified, this.headers, this.metadata, this.payload);
        }

        public Builder fromObject(SwiftObject from) {
            return this.name(from.getName()).uri(from.getUri()).etag(from.getETag()).lastModified(from.getLastModified()).headers(from.getHeaders()).metadata(from.getMetadata()).payload(from.getPayload());
        }
    }
}

