/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.nova.v2_0.domain.Volume;

public class VolumeSnapshot {
    private final String id;
    private final String volumeId;
    private final Volume.Status status;
    private final int size;
    @Named(value="createdAt")
    private final Date created;
    @Named(value="displayName")
    private final String name;
    @Named(value="displayDescription")
    private final String description;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVolumeSnapshot(this);
    }

    @ConstructorProperties(value={"id", "volumeId", "status", "size", "createdAt", "displayName", "displayDescription"})
    protected VolumeSnapshot(String id, String volumeId, Volume.Status status, int size, @Nullable Date created, @Nullable String name, @Nullable String description) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.volumeId = Preconditions.checkNotNull(volumeId, "volumeId");
        this.status = Preconditions.checkNotNull(status, "status");
        this.size = size;
        this.created = created;
        this.name = name;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public Volume.Status getStatus() {
        return this.status;
    }

    public int getSize() {
        return this.size;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.volumeId, this.status, this.size, this.created, this.name, this.description});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VolumeSnapshot that = (VolumeSnapshot)VolumeSnapshot.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.volumeId, that.volumeId) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal(this.size, that.size) && Objects.equal(this.created, that.created) && Objects.equal(this.name, that.name) && Objects.equal(this.description, that.description);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("volumeId", this.volumeId).add("status", (Object)this.status).add("size", this.size).add("created", this.created).add("name", this.name).add("description", this.description);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String volumeId;
        protected Volume.Status status;
        protected int size;
        protected Date created;
        protected String name;
        protected String description;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this.self();
        }

        public T status(Volume.Status status) {
            this.status = status;
            return this.self();
        }

        public T size(int size) {
            this.size = size;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public VolumeSnapshot build() {
            return new VolumeSnapshot(this.id, this.volumeId, this.status, this.size, this.created, this.name, this.description);
        }

        public T fromVolumeSnapshot(VolumeSnapshot in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).volumeId(in.getVolumeId())).status(in.getStatus())).size(in.getSize())).created(in.getCreated())).name(in.getName())).description(in.getDescription());
        }
    }
}

