/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.domain.Location;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.FlavorInRegion;

public class FlavorInRegionToHardware
implements Function<FlavorInRegion, Hardware> {
    private final Supplier<Map<String, Location>> locationIndex;

    @Inject
    public FlavorInRegionToHardware(Supplier<Map<String, Location>> locationIndex) {
        this.locationIndex = Preconditions.checkNotNull(locationIndex, "locationIndex");
    }

    @Override
    public Hardware apply(FlavorInRegion flavorInRegion) {
        Location location = this.locationIndex.get().get(flavorInRegion.getRegion());
        Preconditions.checkState(location != null, "location %s not in locationIndex: %s", (Object)flavorInRegion.getRegion(), this.locationIndex.get());
        Flavor flavor = flavorInRegion.getFlavor();
        return new HardwareBuilder().id(flavorInRegion.slashEncode()).providerId(flavor.getId()).name(flavor.getName()).ram(flavor.getRam()).processor(new Processor(flavor.getVcpus(), 1.0)).volume(new VolumeImpl(Float.valueOf(flavor.getDisk()), true, true)).location(location).build();
    }
}

