/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.neutron.v2.domain.RuleDirection;
import org.jclouds.openstack.neutron.v2.domain.RuleEthertype;
import org.jclouds.openstack.neutron.v2.domain.RuleProtocol;

public class Rule {
    private String id;
    @Named(value="tenant_id")
    private String tenantId;
    private RuleDirection direction;
    @Named(value="security_group_id")
    private String securityGroupId;
    private RuleEthertype ethertype;
    @Named(value="port_range_min")
    private Integer portRangeMin;
    @Named(value="port_range_max")
    private Integer portRangeMax;
    private RuleProtocol protocol;
    @Named(value="remote_group_id")
    private String remoteGroupId;
    @Named(value="remote_ip_prefix")
    private String remoteIpPrefix;

    @ConstructorProperties(value={"id", "tenant_id", "direction", "security_group_id", "ethertype", "port_range_min", "port_range_max", "protocol", "remote_group_id", "remote_ip_prefix"})
    protected Rule(String id, String tenantId, RuleDirection direction, String securityGroupId, RuleEthertype ethertype, Integer portRangeMin, Integer portRangeMax, RuleProtocol protocol, String remoteGroupId, String remoteIpPrefix) {
        this.id = id;
        this.tenantId = tenantId;
        this.direction = direction;
        this.securityGroupId = securityGroupId;
        this.ethertype = ethertype;
        this.portRangeMin = portRangeMin;
        this.portRangeMax = portRangeMax;
        this.protocol = protocol;
        this.remoteGroupId = remoteGroupId;
        this.remoteIpPrefix = remoteIpPrefix;
    }

    private Rule(Rule rule) {
        this(rule.id, rule.tenantId, rule.direction, rule.securityGroupId, rule.ethertype, rule.portRangeMin, rule.portRangeMax, rule.protocol, rule.remoteGroupId, rule.remoteIpPrefix);
    }

    private Rule() {
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public RuleDirection getDirection() {
        return this.direction;
    }

    @Nullable
    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    @Nullable
    public RuleEthertype getEthertype() {
        return this.ethertype;
    }

    @Nullable
    public Integer getPortRangeMin() {
        return this.portRangeMin;
    }

    @Nullable
    public Integer getPortRangeMax() {
        return this.portRangeMax;
    }

    @Nullable
    public RuleProtocol getProtocol() {
        return this.protocol;
    }

    @Nullable
    public String getRemoteGroupId() {
        return this.remoteGroupId;
    }

    @Nullable
    public String getRemoteIpPrefix() {
        return this.remoteIpPrefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule that = (Rule)o;
        return Objects.equal(this.id, that.id) && Objects.equal(this.tenantId, that.tenantId) && Objects.equal((Object)this.direction, (Object)that.direction) && Objects.equal(this.securityGroupId, that.securityGroupId) && Objects.equal((Object)this.ethertype, (Object)that.ethertype) && Objects.equal(this.portRangeMin, that.portRangeMin) && Objects.equal(this.portRangeMax, that.portRangeMax) && Objects.equal((Object)this.protocol, (Object)that.protocol) && Objects.equal(this.remoteGroupId, that.remoteGroupId) && Objects.equal(this.remoteIpPrefix, that.remoteIpPrefix);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.tenantId, this.direction, this.securityGroupId, this.ethertype, this.portRangeMin, this.portRangeMax, this.protocol, this.remoteGroupId, this.remoteIpPrefix});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("tenantId", this.tenantId).add("direction", (Object)this.direction).add("securityGroupId", this.securityGroupId).add("ethertype", (Object)this.ethertype).add("portRangeMin", this.portRangeMin).add("portRangeMax", this.portRangeMax).add("protocol", (Object)this.protocol).add("remoteGroupId", this.remoteGroupId).add("remoteIpPrefix", this.remoteIpPrefix).toString();
    }

    public static CreateBuilder createBuilder(RuleDirection direction, String securityGroupId) {
        return new CreateBuilder(direction, securityGroupId);
    }

    public static class CreateRule
    extends Rule {
        private CreateRule(Rule rule) {
            super(rule);
            Preconditions.checkNotNull(this.getDirection(), "direction should not be null");
            Preconditions.checkNotNull(this.getSecurityGroupId(), "security group id should not be null");
            if (this.getPortRangeMax() != null && this.getPortRangeMin() != null) {
                Preconditions.checkArgument(this.getPortRangeMax() >= this.getPortRangeMin(), "port range max should be greater than or equal to port range min");
            }
            Preconditions.checkArgument(this.getRemoteGroupId() == null || this.getRemoteIpPrefix() == null, "You can specify either remote_group_id or remote_ip_prefix in the request body.");
        }
    }

    public static class CreateBuilder
    extends Builder<CreateBuilder> {
        private CreateBuilder(RuleDirection direction, String securityGroupId) {
            this.rule.direction = direction;
            this.rule.securityGroupId = securityGroupId;
        }

        public CreateRule build() {
            return new CreateRule(this.rule);
        }

        @Override
        protected CreateBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<ParameterizedBuilderType> {
        protected Rule rule = new Rule();

        private Builder() {
        }

        protected abstract ParameterizedBuilderType self();

        public ParameterizedBuilderType tenantId(String tenantId) {
            this.rule.tenantId = tenantId;
            return this.self();
        }

        public ParameterizedBuilderType direction(RuleDirection direction) {
            this.rule.direction = direction;
            return this.self();
        }

        public ParameterizedBuilderType securityGroupId(String securityGroupId) {
            this.rule.securityGroupId = securityGroupId;
            return this.self();
        }

        public ParameterizedBuilderType ethertype(RuleEthertype ethertype) {
            this.rule.ethertype = ethertype;
            return this.self();
        }

        public ParameterizedBuilderType portRangeMin(Integer portRangeMin) {
            this.rule.portRangeMin = portRangeMin;
            return this.self();
        }

        public ParameterizedBuilderType portRangeMax(Integer portRangeMax) {
            this.rule.portRangeMax = portRangeMax;
            return this.self();
        }

        public ParameterizedBuilderType protocol(RuleProtocol protocol) {
            this.rule.protocol = protocol;
            return this.self();
        }

        public ParameterizedBuilderType remoteGroupId(String remoteGroupId) {
            this.rule.remoteGroupId = remoteGroupId;
            return this.self();
        }

        public ParameterizedBuilderType remoteIpPrefix(String remoteIpPrefix) {
            this.rule.remoteIpPrefix = remoteIpPrefix;
            return this.self();
        }
    }
}

