/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ohai.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.JsonBall;
import org.jclouds.json.Json;

@Singleton
public class NestSlashKeys
implements Function<Multimap<String, Supplier<JsonBall>>, Map<String, JsonBall>> {
    private final Json json;
    final Type mapLiteral = new TypeLiteral<Map<String, JsonBall>>(){}.getType();
    final Type listLiteral = new TypeLiteral<List<JsonBall>>(){}.getType();

    @Inject
    NestSlashKeys(Json json) {
        this.json = Preconditions.checkNotNull(json, "json");
    }

    @Override
    public Map<String, JsonBall> apply(Multimap<String, Supplier<JsonBall>> from) {
        Map<String, JsonBall> autoAttrs = this.mergeSameKeys(from);
        LinkedHashMap<String, JsonBall> modifiableFlatMap = Maps.newLinkedHashMap(Maps.filterKeys(autoAttrs, new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return input.indexOf(47) == -1;
            }
        }));
        Map<String, JsonBall> withSlashesMap = Maps.difference(autoAttrs, modifiableFlatMap).entriesOnlyOnLeft();
        for (Map.Entry<String, JsonBall> entry : withSlashesMap.entrySet()) {
            ArrayList<String> keyParts = Lists.newArrayList(Splitter.on('/').split(entry.getKey()));
            JsonBall toInsert = entry.getValue();
            try {
                this.putUnderContext(keyParts, toInsert, modifiableFlatMap);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("error inserting value in entry: " + entry.getKey(), e);
            }
        }
        return modifiableFlatMap;
    }

    private Map<String, JsonBall> mergeSameKeys(Multimap<String, Supplier<JsonBall>> from) {
        LinkedHashMap<String, JsonBall> merged = Maps.newLinkedHashMap();
        for (Map.Entry<String, Supplier<JsonBall>> entry : from.entries()) {
            if (merged.containsKey(entry.getKey())) {
                this.mergeAsPeer(entry.getKey(), entry.getValue().get(), merged);
                continue;
            }
            merged.put(entry.getKey(), entry.getValue().get());
        }
        return merged;
    }

    @VisibleForTesting
    void mergeAsPeer(String key, JsonBall value, Map<String, JsonBall> insertionContext) {
        Map immutableValueContext = (Map)this.json.fromJson(insertionContext.get(key).toString(), this.mapLiteral);
        LinkedHashMap<String, JsonBall> valueContext = Maps.newLinkedHashMap(immutableValueContext);
        Map toPut = (Map)this.json.fromJson(value.toString(), this.mapLiteral);
        Sets.SetView<String> uniques = Sets.difference(toPut.keySet(), valueContext.keySet());
        for (String k : uniques) {
            valueContext.put(k, (JsonBall)toPut.get(k));
        }
        Sets.SetView<String> conflicts = Sets.difference(toPut.keySet(), uniques);
        for (String k : conflicts) {
            JsonBall v = (JsonBall)toPut.get(k);
            if (v.toString().matches("^\\{.*\\}$")) {
                this.mergeAsPeer(k, v, valueContext);
                continue;
            }
            valueContext.put(k, v);
        }
        insertionContext.put(key, new JsonBall(this.json.toJson(valueContext, this.mapLiteral)));
    }

    void putUnderContext(List<String> keyParts, JsonBall toInsert, Map<String, JsonBall> destination) {
        Preconditions.checkNotNull(keyParts, "keyParts");
        Preconditions.checkArgument(keyParts.size() >= 1, "keyParts must contain at least one element");
        Preconditions.checkNotNull(toInsert, "toInsert");
        Preconditions.checkNotNull(destination, "destination");
        String rootKey = keyParts.remove(0);
        String rootValue = destination.containsKey(rootKey) ? destination.get(rootKey).toString() : "{}";
        Preconditions.checkArgument(rootValue.matches("^\\{.*\\}$"), "value must be a hash: %s", (Object)rootValue);
        Map immutableInsertionContext = (Map)this.json.fromJson(rootValue, this.mapLiteral);
        LinkedHashMap<String, JsonBall> insertionContext = Maps.newLinkedHashMap(immutableInsertionContext);
        if (keyParts.size() == 1) {
            if (!insertionContext.containsKey(keyParts.get(0))) {
                insertionContext.put(keyParts.get(0), toInsert);
            } else {
                String key = keyParts.get(0);
                this.mergeAsPeer(key, toInsert, insertionContext);
            }
        } else {
            this.putUnderContext(keyParts, toInsert, insertionContext);
        }
        destination.put(rootKey, new JsonBall(this.json.toJson(insertionContext, this.mapLiteral)));
    }
}

