/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.utils;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import org.jclouds.util.Strings2;

public class QueryValue
implements Comparable {
    private final boolean encoded;
    private final Object value;
    private final Iterable<Character> skipChars;

    public QueryValue(Object value, boolean encoded) {
        this.value = value;
        this.encoded = encoded;
        this.skipChars = ImmutableList.of(Character.valueOf('/'), Character.valueOf(','));
    }

    public String toString() {
        if (!this.encoded) {
            return Strings2.urlEncode(this.value.toString(), this.skipChars);
        }
        return this.value.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof QueryValue) {
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.toString());
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }
}

