/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.Snapshot;
import org.jclouds.googlecomputeengine.internal.BaseToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/snapshots")
@Consumes(value={"application/json"})
public interface SnapshotApi {
    @Named(value="Snapshots:get")
    @GET
    @Path(value="/{snapshot}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Snapshot get(@PathParam(value="snapshot") String var1);

    @Named(value="Snapshots:delete")
    @DELETE
    @Path(value="/{snapshot}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation delete(@PathParam(value="snapshot") String var1);

    @Named(value="Snapshots:list")
    @GET
    public ListPage<Snapshot> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="Snapshots:list")
    @GET
    @Transform(value=SnapshotPages.class)
    public Iterator<ListPage<Snapshot>> list();

    @Named(value="Snapshots:list")
    @GET
    @Transform(value=SnapshotPages.class)
    public Iterator<ListPage<Snapshot>> list(ListOptions var1);

    public static final class SnapshotPages
    extends BaseToIteratorOfListPage<Snapshot, SnapshotPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        SnapshotPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<Snapshot>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<Snapshot>>(){

                @Override
                public ListPage<Snapshot> apply(String pageToken) {
                    return api.snapshots().listPage(pageToken, options);
                }
            };
        }
    }
}

