/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.config;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Provides;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.domain.Credentials;
import org.jclouds.googlecloud.config.CurrentProject;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Project;
import org.jclouds.googlecomputeengine.handlers.GoogleComputeEngineErrorHandler;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.Provider;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.config.BinderUtils;
import org.jclouds.rest.config.HttpApiModule;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;

@ConfiguresHttpApi
public final class GoogleComputeEngineHttpApiModule
extends HttpApiModule<GoogleComputeEngineApi> {
    @Override
    protected void configure() {
        super.configure();
        BinderUtils.bindHttpApi(this.binder(), UseApiToResolveProjectName.GetProject.class);
        this.bind(OAuthScopes.class).toInstance(OAuthScopes.ReadOrWriteScopes.create("https://www.googleapis.com/auth/compute.readonly", "https://www.googleapis.com/auth/compute"));
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(GoogleComputeEngineErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(GoogleComputeEngineErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(GoogleComputeEngineErrorHandler.class);
    }

    @Provides
    @Singleton
    @CurrentProject
    Supplier<URI> project(final @Named(value="jclouds.googlecloud.project-name") String projectName, @Provider Supplier<URI> defaultEndpoint, UseApiToResolveProjectName useApiToResolveProjectName, @Provider Supplier<Credentials> creds, AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds) {
        if (Strings.emptyToNull(projectName) != null) {
            return Suppliers.memoizeWithExpiration(Suppliers.compose(new Function<URI, URI>(){

                @Override
                public URI apply(URI input) {
                    return URI.create(String.format("%s/projects/%s", input, projectName));
                }
            }, defaultEndpoint), seconds, TimeUnit.SECONDS);
        }
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, Suppliers.compose(useApiToResolveProjectName, creds), seconds, TimeUnit.SECONDS);
    }

    static final class UseApiToResolveProjectName
    implements Function<Credentials, URI> {
        private final GetProject api;
        private final Supplier<URI> defaultEndpoint;

        @Inject
        UseApiToResolveProjectName(GetProject api, @Provider Supplier<URI> defaultEndpoint, ProviderMetadata metadata) {
            this.api = api;
            this.defaultEndpoint = defaultEndpoint;
        }

        @Override
        public URI apply(Credentials in) {
            String projectNumber = CurrentProject.ClientEmail.toProjectNumber(in.identity);
            return URI.create(this.defaultEndpoint.get() + "/projects/" + this.api.get(projectNumber).name());
        }

        @SkipEncoding(value={47, 61})
        @RequestFilters(value={OAuthFilter.class})
        @Consumes(value={"application/json"})
        static interface GetProject {
            @Named(value="Projects:get")
            @GET
            @Path(value="/projects/{projectNumber}")
            public Project get(@PathParam(value="projectNumber") String var1);
        }
    }
}

