/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.options;

import com.google.common.base.Preconditions;
import org.jclouds.googlecloudstorage.domain.DomainResourceReferences;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListObjectOptions
extends BaseHttpRequestOptions {
    public ListObjectOptions delimiter(String delimiter) {
        this.queryParameters.put("delimiter", Preconditions.checkNotNull(delimiter, "delimiter"));
        return this;
    }

    public ListObjectOptions prefix(String prefix) {
        this.queryParameters.put("prefix", Preconditions.checkNotNull(prefix, "delimeter"));
        return this;
    }

    public ListObjectOptions versions(Boolean versions) {
        this.queryParameters.put("versions", Preconditions.checkNotNull(versions, "versions") + "");
        return this;
    }

    public ListObjectOptions pageToken(String pageToken) {
        this.queryParameters.put("pageToken", Preconditions.checkNotNull(pageToken, "pageToken"));
        return this;
    }

    public ListObjectOptions maxResults(Integer maxResults) {
        this.queryParameters.put("maxResults", Preconditions.checkNotNull(maxResults, "maxResults") + "");
        return this;
    }

    public ListObjectOptions projection(DomainResourceReferences.Projection projection) {
        this.queryParameters.put("projection", Preconditions.checkNotNull(projection, "projection").toString());
        return this;
    }

    public static class Builder {
        public ListObjectOptions delimiter(String delimiter) {
            return new ListObjectOptions().delimiter(delimiter);
        }

        public ListObjectOptions prefix(String prefix) {
            return new ListObjectOptions().prefix(prefix);
        }

        public ListObjectOptions versions(Boolean versions) {
            return new ListObjectOptions().versions(versions);
        }

        public ListObjectOptions pageToken(String pageToken) {
            return new ListObjectOptions().pageToken(pageToken);
        }

        public ListObjectOptions maxResults(Integer maxResults) {
            return new ListObjectOptions().maxResults(maxResults);
        }

        public ListObjectOptions projection(DomainResourceReferences.Projection projection) {
            return new ListObjectOptions().projection(projection);
        }
    }
}

